/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.watcher;

import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.client.watcher.WatchStatusDateParser;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;

public class ActionStatus {
    private final AckStatus ackStatus;
    @Nullable
    private final Execution lastExecution;
    @Nullable
    private final Execution lastSuccessfulExecution;
    @Nullable
    private final Throttle lastThrottle;

    public ActionStatus(AckStatus ackStatus, @Nullable Execution lastExecution, @Nullable Execution lastSuccessfulExecution, @Nullable Throttle lastThrottle) {
        this.ackStatus = ackStatus;
        this.lastExecution = lastExecution;
        this.lastSuccessfulExecution = lastSuccessfulExecution;
        this.lastThrottle = lastThrottle;
    }

    public AckStatus ackStatus() {
        return this.ackStatus;
    }

    public Execution lastExecution() {
        return this.lastExecution;
    }

    public Execution lastSuccessfulExecution() {
        return this.lastSuccessfulExecution;
    }

    public Throttle lastThrottle() {
        return this.lastThrottle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionStatus that = (ActionStatus)o;
        return Objects.equals(this.ackStatus, that.ackStatus) && Objects.equals(this.lastExecution, that.lastExecution) && Objects.equals(this.lastSuccessfulExecution, that.lastSuccessfulExecution) && Objects.equals(this.lastThrottle, that.lastThrottle);
    }

    public int hashCode() {
        return Objects.hash(this.ackStatus, this.lastExecution, this.lastSuccessfulExecution, this.lastThrottle);
    }

    public static ActionStatus parse(String actionId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        AckStatus ackStatus = null;
        Execution lastExecution = null;
        Execution lastSuccessfulExecution = null;
        Throttle lastThrottle = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Field.ACK_STATUS.match(currentFieldName, parser.getDeprecationHandler())) {
                ackStatus = AckStatus.parse(actionId, parser);
                continue;
            }
            if (Field.LAST_EXECUTION.match(currentFieldName, parser.getDeprecationHandler())) {
                lastExecution = Execution.parse(actionId, parser);
                continue;
            }
            if (Field.LAST_SUCCESSFUL_EXECUTION.match(currentFieldName, parser.getDeprecationHandler())) {
                lastSuccessfulExecution = Execution.parse(actionId, parser);
                continue;
            }
            if (Field.LAST_THROTTLE.match(currentFieldName, parser.getDeprecationHandler())) {
                lastThrottle = Throttle.parse(actionId, parser);
                continue;
            }
            parser.skipChildren();
        }
        if (ackStatus == null) {
            throw new ElasticsearchParseException("could not parse action status for [{}]. missing required field [{}]", new Object[]{actionId, Field.ACK_STATUS.getPreferredName()});
        }
        return new ActionStatus(ackStatus, lastExecution, lastSuccessfulExecution, lastThrottle);
    }

    public static class AckStatus {
        private final ZonedDateTime timestamp;
        private final State state;

        public AckStatus(ZonedDateTime timestamp, State state) {
            assert (timestamp.getOffset() == ZoneOffset.UTC);
            this.timestamp = timestamp;
            this.state = state;
        }

        public ZonedDateTime timestamp() {
            return this.timestamp;
        }

        public State state() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AckStatus ackStatus = (AckStatus)o;
            return Objects.equals(this.timestamp, ackStatus.timestamp) && Objects.equals((Object)this.state, (Object)ackStatus.state);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.timestamp, this.state});
        }

        public static AckStatus parse(String actionId, XContentParser parser) throws IOException {
            XContentParser.Token token;
            ZonedDateTime timestamp = null;
            State state = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (Field.TIMESTAMP.match(currentFieldName, parser.getDeprecationHandler())) {
                    timestamp = WatchStatusDateParser.parseDate(parser.text());
                    continue;
                }
                if (Field.ACK_STATUS_STATE.match(currentFieldName, parser.getDeprecationHandler())) {
                    state = State.valueOf(parser.text().toUpperCase(Locale.ROOT));
                    continue;
                }
                parser.skipChildren();
            }
            if (timestamp == null) {
                throw new ElasticsearchParseException("could not parse action status for [{}]. missing required field [{}.{}]", new Object[]{actionId, Field.ACK_STATUS.getPreferredName(), Field.TIMESTAMP.getPreferredName()});
            }
            if (state == null) {
                throw new ElasticsearchParseException("could not parse action status for [{}]. missing required field [{}.{}]", new Object[]{actionId, Field.ACK_STATUS.getPreferredName(), Field.ACK_STATUS_STATE.getPreferredName()});
            }
            return new AckStatus(timestamp, state);
        }

        public static enum State {
            AWAITS_SUCCESSFUL_EXECUTION,
            ACKABLE,
            ACKED;

        }
    }

    public static class Execution {
        private final ZonedDateTime timestamp;
        private final boolean successful;
        private final String reason;

        public static Execution successful(ZonedDateTime timestamp) {
            return new Execution(timestamp, true, null);
        }

        public static Execution failure(ZonedDateTime timestamp, String reason) {
            return new Execution(timestamp, false, reason);
        }

        private Execution(ZonedDateTime timestamp, boolean successful, String reason) {
            this.timestamp = timestamp.withZoneSameInstant(ZoneOffset.UTC);
            this.successful = successful;
            this.reason = reason;
        }

        public ZonedDateTime timestamp() {
            return this.timestamp;
        }

        public boolean successful() {
            return this.successful;
        }

        public String reason() {
            return this.reason;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Execution execution = (Execution)o;
            return Objects.equals(this.successful, execution.successful) && Objects.equals(this.timestamp, execution.timestamp) && Objects.equals(this.reason, execution.reason);
        }

        public int hashCode() {
            return Objects.hash(this.timestamp, this.successful, this.reason);
        }

        public static Execution parse(String actionId, XContentParser parser) throws IOException {
            XContentParser.Token token;
            ZonedDateTime timestamp = null;
            Boolean successful = null;
            String reason = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (Field.TIMESTAMP.match(currentFieldName, parser.getDeprecationHandler())) {
                    timestamp = WatchStatusDateParser.parseDate(parser.text());
                    continue;
                }
                if (Field.EXECUTION_SUCCESSFUL.match(currentFieldName, parser.getDeprecationHandler())) {
                    successful = parser.booleanValue();
                    continue;
                }
                if (Field.REASON.match(currentFieldName, parser.getDeprecationHandler())) {
                    reason = parser.text();
                    continue;
                }
                parser.skipChildren();
            }
            if (timestamp == null) {
                throw new ElasticsearchParseException("could not parse action status for [{}]. missing required field [{}.{}]", new Object[]{actionId, Field.LAST_EXECUTION.getPreferredName(), Field.TIMESTAMP.getPreferredName()});
            }
            if (successful == null) {
                throw new ElasticsearchParseException("could not parse action status for [{}]. missing required field [{}.{}]", new Object[]{actionId, Field.LAST_EXECUTION.getPreferredName(), Field.EXECUTION_SUCCESSFUL.getPreferredName()});
            }
            if (successful.booleanValue()) {
                return Execution.successful(timestamp);
            }
            if (reason == null) {
                throw new ElasticsearchParseException("could not parse action status for [{}]. missing required field for unsuccessful execution [{}.{}]", new Object[]{actionId, Field.LAST_EXECUTION.getPreferredName(), Field.REASON.getPreferredName()});
            }
            return Execution.failure(timestamp, reason);
        }
    }

    public static class Throttle {
        private final ZonedDateTime timestamp;
        private final String reason;

        public Throttle(ZonedDateTime timestamp, String reason) {
            this.timestamp = timestamp.withZoneSameInstant(ZoneOffset.UTC);
            this.reason = reason;
        }

        public ZonedDateTime timestamp() {
            return this.timestamp;
        }

        public String reason() {
            return this.reason;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Throttle throttle = (Throttle)o;
            return Objects.equals(this.timestamp, throttle.timestamp) && Objects.equals(this.reason, throttle.reason);
        }

        public int hashCode() {
            return Objects.hash(this.timestamp, this.reason);
        }

        public static Throttle parse(String actionId, XContentParser parser) throws IOException {
            XContentParser.Token token;
            ZonedDateTime timestamp = null;
            String reason = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (Field.TIMESTAMP.match(currentFieldName, parser.getDeprecationHandler())) {
                    timestamp = WatchStatusDateParser.parseDate(parser.text());
                    continue;
                }
                if (Field.REASON.match(currentFieldName, parser.getDeprecationHandler())) {
                    reason = parser.text();
                    continue;
                }
                parser.skipChildren();
            }
            if (timestamp == null) {
                throw new ElasticsearchParseException("could not parse action status for [{}]. missing required field [{}.{}]", new Object[]{actionId, Field.LAST_THROTTLE.getPreferredName(), Field.TIMESTAMP.getPreferredName()});
            }
            if (reason == null) {
                throw new ElasticsearchParseException("could not parse action status for [{}]. missing required field [{}.{}]", new Object[]{actionId, Field.LAST_THROTTLE.getPreferredName(), Field.REASON.getPreferredName()});
            }
            return new Throttle(timestamp, reason);
        }
    }

    private static interface Field {
        public static final ParseField ACK_STATUS = new ParseField("ack", new String[0]);
        public static final ParseField ACK_STATUS_STATE = new ParseField("state", new String[0]);
        public static final ParseField LAST_EXECUTION = new ParseField("last_execution", new String[0]);
        public static final ParseField LAST_SUCCESSFUL_EXECUTION = new ParseField("last_successful_execution", new String[0]);
        public static final ParseField EXECUTION_SUCCESSFUL = new ParseField("successful", new String[0]);
        public static final ParseField LAST_THROTTLE = new ParseField("last_throttle", new String[0]);
        public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
        public static final ParseField REASON = new ParseField("reason", new String[0]);
    }
}

