/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.MailboxStatusResponse;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.model.UidValidity;

public class MailboxStatusResponseEncoder
implements ImapConstants,
ImapResponseEncoder<MailboxStatusResponse> {
    @Override
    public Class<MailboxStatusResponse> acceptableMessages() {
        return MailboxStatusResponse.class;
    }

    @Override
    public void encode(MailboxStatusResponse response, ImapResponseComposer composer) throws IOException {
        Long messages = response.getMessages();
        Long recent = response.getRecent();
        MessageUid uidNext = response.getUidNext();
        ModSeq highestModSeq = response.getHighestModSeq();
        UidValidity uidValidity = response.getUidValidity();
        Long unseen = response.getUnseen();
        String mailboxName = response.getMailbox();
        composer.untagged();
        composer.message(STATUS_COMMAND.getName());
        composer.quote(mailboxName);
        composer.openParen();
        if (messages != null) {
            composer.message("MESSAGES");
            long messagesValue = messages;
            composer.message(messagesValue);
        }
        if (recent != null) {
            composer.message("RECENT");
            long recentValue = recent;
            composer.message(recentValue);
        }
        if (uidNext != null) {
            composer.message("UIDNEXT");
            long uidNextValue = uidNext.asLong();
            composer.message(uidNextValue);
        }
        if (highestModSeq != null) {
            composer.message("HIGHESTMODSEQ");
            composer.message(highestModSeq.asLong());
        }
        if (uidValidity != null) {
            composer.message("UIDVALIDITY");
            UidValidity uidValidityValue = uidValidity;
            composer.message(uidValidityValue.asLong());
        }
        if (unseen != null) {
            composer.message("UNSEEN");
            long unseenValue = unseen;
            composer.message(unseenValue);
        }
        composer.closeParen();
        composer.end();
    }
}

