/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.LastHttpContent;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.http.nio.netty.internal.utils.NettyClientLogger;

@ChannelHandler.Sharable
@SdkInternalApi
public final class LastHttpContentHandler
extends ChannelInboundHandlerAdapter {
    private static final LastHttpContentHandler INSTANCE = new LastHttpContentHandler();
    private static final NettyClientLogger logger = NettyClientLogger.getLogger(LastHttpContent.class);

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof LastHttpContent) {
            logger.debug(ctx.channel(), () -> "Received LastHttpContent " + ctx.channel());
            ctx.channel().attr(ChannelAttributeKey.LAST_HTTP_CONTENT_RECEIVED_KEY).set((Object)true);
        }
        ctx.fireChannelRead(msg);
    }

    public static LastHttpContentHandler create() {
        return INSTANCE;
    }
}

