/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.BindRequestAuthenticationType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.BindRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONRequestAccessLogMessage;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class JSONBindRequestAccessLogMessage
extends JSONRequestAccessLogMessage
implements BindRequestAccessLogMessage {
    private static final long serialVersionUID = 6983414352725940767L;
    @Nullable
    private final BindRequestAuthenticationType authenticationType;
    @Nullable
    private final String dn = this.getString(JSONFormattedAccessLogFields.BIND_DN);
    @Nullable
    private final String protocolVersion = this.getString(JSONFormattedAccessLogFields.BIND_PROTOCOL_VERSION);
    @Nullable
    private final String saslMechanismName = this.getString(JSONFormattedAccessLogFields.BIND_SASL_MECHANISM);

    public JSONBindRequestAccessLogMessage(@NotNull JSONObject jsonObject) throws LogException {
        super(jsonObject);
        String authType = this.getString(JSONFormattedAccessLogFields.BIND_AUTHENTICATION_TYPE);
        this.authenticationType = authType == null ? null : BindRequestAuthenticationType.forName(authType);
    }

    @Override
    @NotNull
    public final AccessLogOperationType getOperationType() {
        return AccessLogOperationType.BIND;
    }

    @Override
    @Nullable
    public final BindRequestAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    @Override
    @Nullable
    public final String getDN() {
        return this.dn;
    }

    @Override
    @Nullable
    public final String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    @Nullable
    public final String getSASLMechanismName() {
        return this.saslMechanismName;
    }
}

