/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.james.imap.message.response.NamespaceResponse;
import org.apache.james.mailbox.MailboxSession;

public interface NamespaceSupplier {
    public Collection<NamespaceResponse.Namespace> personalNamespaces(MailboxSession var1);

    public Collection<NamespaceResponse.Namespace> otherUsersNamespaces(MailboxSession var1);

    public Collection<NamespaceResponse.Namespace> sharedNamespaces(MailboxSession var1);

    public static class Default
    implements NamespaceSupplier {
        @Override
        public Collection<NamespaceResponse.Namespace> personalNamespaces(MailboxSession session) {
            return ImmutableList.of((Object)new NamespaceResponse.Namespace("", session.getPathDelimiter()));
        }

        @Override
        public Collection<NamespaceResponse.Namespace> otherUsersNamespaces(MailboxSession session) {
            return ImmutableList.of((Object)new NamespaceResponse.Namespace("#user", session.getPathDelimiter()));
        }

        @Override
        public Collection<NamespaceResponse.Namespace> sharedNamespaces(MailboxSession session) {
            return ImmutableList.of();
        }
    }
}

