/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.jpa;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAConfiguration {
    public static final String JPA_CONNECTION_DRIVER_NAME = "openjpa.ConnectionDriverName";
    public static final String JPA_CONNECTION_USERNAME = "openjpa.ConnectionUserName";
    public static final String JPA_CONNECTION_PASSWORD = "openjpa.ConnectionPassword";
    public static final String JPA_CONNECTION_PROPERTIES = "openjpa.ConnectionProperties";
    public static final String JPA_CONNECTION_URL = "openjpa.ConnectionURL";
    public static final String JPA_MULTITHREADED = "openjpa.Multithreaded";
    public static final List<String> DEFAULT_JPA_PROPERTIES = List.of("openjpa.ConnectionDriverName", "openjpa.ConnectionURL", "openjpa.Multithreaded", "openjpa.ConnectionUserName", "openjpa.ConnectionPassword");
    public static final String DATASOURCE_TEST_ON_BORROW = "datasource.testOnBorrow";
    public static final String DATASOURCE_VALIDATION_QUERY_TIMEOUT_SEC = "datasource.validationQueryTimeoutSec";
    public static final String DATASOURCE_VALIDATION_QUERY = "datasource.validationQuery";
    public static final String DATASOURCE_MAX_TOTAL = "datasource.maxTotal";
    public static final List<String> DEFAULT_DATASOURCE_PROPERTIES = List.of("datasource.testOnBorrow", "datasource.validationQueryTimeoutSec", "datasource.validationQuery", "datasource.maxTotal");
    public static final String ATTACHMENT_STORAGE = "attachmentStorage.enabled";
    private final String driverName;
    private final String driverURL;
    private final Optional<Boolean> testOnBorrow;
    private final Optional<Boolean> multithreaded;
    private final Optional<Integer> validationQueryTimeoutSec;
    private final Optional<Credential> credential;
    private final Optional<String> validationQuery;
    private final Optional<Integer> maxConnections;
    private Map<String, String> customDatasourceProperties;
    private Map<String, String> customOpenjpaProperties;
    private final Optional<Boolean> attachmentStorage;

    public JPAConfiguration() {
        this.driverName = "";
        this.driverURL = "";
        this.credential = Optional.empty();
        this.testOnBorrow = Optional.empty();
        this.multithreaded = Optional.empty();
        this.validationQueryTimeoutSec = Optional.empty();
        this.validationQuery = Optional.empty();
        this.maxConnections = Optional.empty();
        this.customDatasourceProperties = Map.of();
        this.customOpenjpaProperties = Map.of();
        this.attachmentStorage = Optional.empty();
    }

    public static RequireDriverName builder() {
        return driverName -> driverURL -> new ReadyToBuild(driverName, driverURL, Credential.NO_CREDENTIAL, ReadyToBuild.NO_TEST_ON_BORROW, ReadyToBuild.NO_MULTITHREADED, ReadyToBuild.NO_VALIDATION_QUERY_TIMEOUT_SEC, ReadyToBuild.NO_VALIDATION_QUERY, ReadyToBuild.NO_MAX_CONNECTIONS, ReadyToBuild.CUSTOM_DATASOURCE_PROPERTIES, ReadyToBuild.CUSTOM_OPENJPA_PROPERTIES, ReadyToBuild.NO_ATTACHMENT_STORAGE);
    }

    @VisibleForTesting
    JPAConfiguration(String driverName, String driverURL, Optional<Credential> credential, Optional<Boolean> testOnBorrow, Optional<Boolean> multithreaded, Optional<Integer> validationQueryTimeoutSec, Optional<String> validationQuery, Optional<Integer> maxConnections, Map<String, String> customDatasourceProperties, Map<String, String> customOpenjpaProperties, Optional<Boolean> attachmentStorage) {
        Preconditions.checkNotNull((Object)driverName, (Object)"driverName cannot be null");
        Preconditions.checkNotNull((Object)driverURL, (Object)"driverURL cannot be null");
        validationQueryTimeoutSec.ifPresent(timeoutInSec -> Preconditions.checkArgument((timeoutInSec > 0 ? 1 : 0) != 0, (Object)"validationQueryTimeoutSec is required to be greater than 0"));
        maxConnections.ifPresent(maxCon -> Preconditions.checkArgument((maxCon == -1 || maxCon > 0 ? 1 : 0) != 0, (Object)"maxConnections is required to be -1 (no limit) or  greater than 0"));
        this.driverName = driverName;
        this.driverURL = driverURL;
        this.credential = credential;
        this.testOnBorrow = testOnBorrow;
        this.multithreaded = multithreaded;
        this.validationQueryTimeoutSec = validationQueryTimeoutSec;
        this.validationQuery = validationQuery;
        this.maxConnections = maxConnections;
        this.customDatasourceProperties = customDatasourceProperties;
        this.customOpenjpaProperties = customOpenjpaProperties;
        this.attachmentStorage = attachmentStorage;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverURL() {
        return this.driverURL;
    }

    public Optional<Boolean> isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public Optional<Boolean> isMultithreaded() {
        return this.multithreaded;
    }

    public Optional<Integer> getValidationQueryTimeoutSec() {
        return this.validationQueryTimeoutSec;
    }

    public Optional<String> getValidationQuery() {
        return this.validationQuery;
    }

    public Optional<Credential> getCredential() {
        return this.credential;
    }

    public Map<String, String> getCustomOpenjpaProperties() {
        return this.customOpenjpaProperties;
    }

    public Map<String, String> getCustomDatasourceProperties() {
        return this.customDatasourceProperties;
    }

    public Optional<Integer> getMaxConnections() {
        return this.maxConnections;
    }

    public Optional<Boolean> isAttachmentStorageEnabled() {
        return this.attachmentStorage;
    }

    @FunctionalInterface
    public static interface RequireDriverName {
        public RequireDriverURL driverName(String var1);
    }

    @FunctionalInterface
    public static interface RequireDriverURL {
        public ReadyToBuild driverURL(String var1);
    }

    public static class ReadyToBuild {
        static final Optional<Boolean> NO_TEST_ON_BORROW = Optional.empty();
        static final Optional<Boolean> NO_MULTITHREADED = Optional.empty();
        static final Optional<Integer> NO_VALIDATION_QUERY_TIMEOUT_SEC = Optional.empty();
        static final Optional<String> NO_VALIDATION_QUERY = Optional.empty();
        static final Optional<Integer> NO_MAX_CONNECTIONS = Optional.empty();
        static final Map<String, String> CUSTOM_OPENJPA_PROPERTIES = Map.of();
        static final Map<String, String> CUSTOM_DATASOURCE_PROPERTIES = Map.of();
        static final Optional<Boolean> NO_ATTACHMENT_STORAGE = Optional.empty();
        private final String driverName;
        private final String driverURL;
        private Optional<Credential> credential;
        private Optional<Boolean> testOnBorrow;
        private Optional<Boolean> multithreaded;
        private Optional<Integer> validationQueryTimeoutSec;
        private Optional<String> validationQuery;
        private Optional<Integer> maxConnections;
        private Map<String, String> customDatasourceProperties;
        private Map<String, String> customOpenjpaProperties;
        private Optional<Boolean> attachmentStorage;

        private ReadyToBuild(String driverName, String driverURL, Optional<Credential> credential, Optional<Boolean> testOnBorrow, Optional<Boolean> multithreaded, Optional<Integer> validationQueryTimeoutSec, Optional<String> validationQuery, Optional<Integer> maxConnections, Map<String, String> customDatasourceProperties, Map<String, String> customOpenjpaProperties, Optional<Boolean> attachmentStorage) {
            this.driverName = driverName;
            this.driverURL = driverURL;
            this.credential = credential;
            this.testOnBorrow = testOnBorrow;
            this.multithreaded = multithreaded;
            this.validationQueryTimeoutSec = validationQueryTimeoutSec;
            this.validationQuery = validationQuery;
            this.maxConnections = maxConnections;
            this.customDatasourceProperties = customDatasourceProperties;
            this.customOpenjpaProperties = customOpenjpaProperties;
            this.attachmentStorage = attachmentStorage;
        }

        public JPAConfiguration build() {
            return new JPAConfiguration(this.driverName, this.driverURL, this.credential, this.testOnBorrow, this.multithreaded, this.validationQueryTimeoutSec, this.validationQuery, this.maxConnections, this.customDatasourceProperties, this.customOpenjpaProperties, this.attachmentStorage);
        }

        public RequirePassword username(String username) {
            return password -> new ReadyToBuild(this.driverName, this.driverURL, Credential.of(username, password), this.testOnBorrow, this.multithreaded, this.validationQueryTimeoutSec, this.validationQuery, this.maxConnections, this.customDatasourceProperties, this.customOpenjpaProperties, this.attachmentStorage);
        }

        public ReadyToBuild testOnBorrow(Boolean testOnBorrow) {
            this.testOnBorrow = Optional.ofNullable(testOnBorrow);
            return this;
        }

        public ReadyToBuild multithreaded(Boolean multithreaded) {
            this.multithreaded = Optional.ofNullable(multithreaded);
            return this;
        }

        public ReadyToBuild validationQueryTimeoutSec(Integer validationQueryTimeoutSec) {
            this.validationQueryTimeoutSec = Optional.ofNullable(validationQueryTimeoutSec);
            return this;
        }

        public ReadyToBuild validationQuery(String validationQuery) {
            this.validationQuery = Optional.ofNullable(validationQuery);
            return this;
        }

        public ReadyToBuild maxConnections(Integer maxConnections) {
            this.maxConnections = Optional.ofNullable(maxConnections);
            return this;
        }

        public ReadyToBuild attachmentStorage(Boolean attachmentStorage) {
            this.attachmentStorage = Optional.ofNullable(attachmentStorage);
            return this;
        }

        public ReadyToBuild setCustomDatasourceProperties(Map<String, String> customDatasourceProperties) {
            this.customDatasourceProperties = new HashMap<String, String>(customDatasourceProperties);
            DEFAULT_DATASOURCE_PROPERTIES.forEach(this.customDatasourceProperties::remove);
            return this;
        }

        public ReadyToBuild setCustomOpenjpaProperties(Map<String, String> customOpenjpaProperties) {
            this.customOpenjpaProperties = customOpenjpaProperties;
            DEFAULT_JPA_PROPERTIES.forEach(this.customOpenjpaProperties::remove);
            return this;
        }
    }

    public static class Credential {
        private static final Logger LOGGER = LoggerFactory.getLogger(Credential.class);
        static final Optional<Credential> NO_CREDENTIAL = Optional.empty();
        private final String username;
        private final String password;

        public static Optional<Credential> of(String username, String password) {
            if (StringUtils.isBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)password)) {
                LOGGER.debug("username and password are blank, returns no credential by default");
                return NO_CREDENTIAL;
            }
            return Optional.of(new Credential(username, password));
        }

        private Credential(String username, String password) {
            Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password) ? 1 : 0) != 0, (Object)"username and password for connecting to database can't be blank");
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }

    @FunctionalInterface
    public static interface RequirePassword {
        public ReadyToBuild password(String var1);
    }
}

