/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.opensearch._types.mapping.StandardNumberProperty;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class ShortNumberProperty
extends StandardNumberProperty
implements PropertyVariant {
    @Nullable
    private final Number nullValue;
    public static final JsonpDeserializer<ShortNumberProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShortNumberProperty::setupShortNumberPropertyDeserializer);

    private ShortNumberProperty(Builder builder) {
        super(builder);
        this.nullValue = builder.nullValue;
    }

    public static ShortNumberProperty of(Function<Builder, ObjectBuilder<ShortNumberProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Short;
    }

    @Nullable
    public final Number nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "short");
        super.serializeInternal(generator, mapper);
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue.doubleValue());
        }
    }

    protected static void setupShortNumberPropertyDeserializer(ObjectDeserializer<Builder> op) {
        StandardNumberProperty.setupStandardNumberPropertyDeserializer(op);
        op.add(Builder::nullValue, JsonpDeserializer.numberDeserializer(), "null_value");
        op.ignore("type");
    }

    public static class Builder
    extends StandardNumberProperty.AbstractBuilder<Builder>
    implements ObjectBuilder<ShortNumberProperty> {
        @Nullable
        private Number nullValue;

        public final Builder nullValue(@Nullable Number value) {
            this.nullValue = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShortNumberProperty build() {
            this._checkSingleUse();
            return new ShortNumberProperty(this);
        }
    }
}

