/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import lombok.Generated;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Master;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.SetResponseType;
import org.xbill.DNS.Type;
import org.xbill.DNS.ZoneTransferException;
import org.xbill.DNS.ZoneTransferIn;

public class Zone
implements Serializable,
Iterable<RRset> {
    public static final int PRIMARY = 1;
    public static final int SECONDARY = 2;
    private final transient ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final transient ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final transient ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
    private final Map<Name, Object> data = new ConcurrentSkipListMap<Name, Object>();
    private Object originNode;
    private boolean hasWild;
    private Name origin;
    private RRset nsRRset;
    private SOARecord soaRecord;

    public int getDClass() {
        return 1;
    }

    public RRset getNS() {
        return this.withReadLock(() -> new RRset(this.nsRRset));
    }

    public SOARecord getSOA() {
        return this.soaRecord;
    }

    public Zone(Name zone, InputStream input) throws IOException {
        if (zone == null) {
            throw new IllegalArgumentException("no zone name specified");
        }
        if (input == null) {
            throw new IllegalArgumentException("no input stream specified");
        }
        this.origin = zone;
        this.fromMasterFile(new Master(input, this.origin));
    }

    public Zone(Name zone, String file) throws IOException {
        if (zone == null) {
            throw new IllegalArgumentException("no zone name specified");
        }
        if (file == null) {
            throw new IllegalArgumentException("no file name specified");
        }
        this.origin = zone;
        this.fromMasterFile(new Master(file, this.origin));
    }

    public Zone(Name zone, Record ... records) throws IOException {
        if (zone == null) {
            throw new IllegalArgumentException("no zone name specified");
        }
        if (records == null) {
            throw new IllegalArgumentException("no records are specified");
        }
        this.origin = zone;
        for (Record r : records) {
            this.maybeAddRecord(r);
        }
        this.validate();
    }

    public Zone(ZoneTransferIn xfrin2) throws IOException, ZoneTransferException {
        if (xfrin2 == null) {
            throw new IllegalArgumentException("no xfrin specified");
        }
        this.fromXFR(xfrin2);
    }

    public Zone(Name zone, int dclass, String remote) throws IOException, ZoneTransferException {
        if (zone == null) {
            throw new IllegalArgumentException("no zone name specified");
        }
        DClass.check(dclass);
        ZoneTransferIn xfrin2 = ZoneTransferIn.newAXFR(zone, remote, null);
        xfrin2.setDClass(dclass);
        this.fromXFR(xfrin2);
    }

    private void fromMasterFile(Master m) throws IOException {
        try {
            Record r;
            while ((r = m.nextRecord()) != null) {
                this.maybeAddRecord(r);
            }
        }
        finally {
            m.close();
        }
        this.validate();
    }

    private void fromXFR(ZoneTransferIn xfrin2) throws IOException, ZoneTransferException {
        this.origin = xfrin2.getName();
        xfrin2.run();
        if (!xfrin2.isAXFR()) {
            throw new IllegalArgumentException("zones can only be created from AXFRs");
        }
        for (Record r : xfrin2.getAXFR()) {
            this.maybeAddRecord(r);
        }
        this.validate();
    }

    private void maybeAddRecord(Record r) throws IOException {
        int rtype = r.getType();
        Name name = r.getName();
        if (rtype == 6 && !name.equals(this.origin)) {
            throw new IOException("SOA owner " + name + " does not match zone origin " + this.origin);
        }
        if (name.subdomain(this.origin)) {
            this.addRecord(r);
        }
    }

    private void validate() throws IOException {
        this.originNode = this.exactName(this.origin);
        if (this.originNode == null) {
            throw new IOException(this.origin + ": no data specified");
        }
        RRset rrset = this.oneRRsetWithoutLock(this.originNode, 6);
        if (rrset == null || rrset.size() != 1) {
            throw new IOException(this.origin + ": exactly 1 SOA must be specified");
        }
        this.soaRecord = (SOARecord)rrset.first();
        this.nsRRset = this.oneRRsetWithoutLock(this.originNode, 2);
        if (this.nsRRset == null) {
            throw new IOException(this.origin + ": no NS set specified");
        }
    }

    @Override
    public Iterator<RRset> iterator() {
        return new ZoneIterator(false);
    }

    public Iterator<RRset> AXFR() {
        return new ZoneIterator(true);
    }

    public <T extends Record> void addRecord(T r) {
        if (r == null) {
            throw new IllegalArgumentException("r must not be null");
        }
        Name name = r.getName();
        int rtype = r.getRRsetType();
        int actualType = r.getType();
        if (rtype == 6 && !name.equals(this.origin)) {
            throw new IllegalArgumentException("SOA owner " + name + " does not match zone origin " + this.origin);
        }
        if (!name.subdomain(this.origin)) {
            throw new IllegalArgumentException("name " + name + " is absolute and not a subdomain of " + this.origin);
        }
        this.withWriteLock(() -> {
            RRset rrset = this.findRRsetWithoutLock(name, rtype);
            if (rrset == null) {
                rrset = new RRset(r);
                this.addRRsetWithoutLock(name, rrset);
            } else {
                if (actualType == 6) {
                    rrset.deleteRR(this.soaRecord);
                    this.soaRecord = (SOARecord)r;
                }
                rrset.addRR(r);
            }
        });
    }

    public void removeRecord(Record r) {
        if (r == null) {
            throw new IllegalArgumentException("r must not be null");
        }
        Name name = r.getName();
        int rtype = r.getRRsetType();
        if (r.getType() == 6) {
            throw new IllegalArgumentException("Cannot remove SOA record");
        }
        this.withWriteLock(() -> {
            RRset rrset = this.findRRsetWithoutLock(name, rtype);
            if (rrset == null) {
                return;
            }
            if (rtype == 2 && rrset.size() == 1) {
                throw new IllegalArgumentException("Cannot remove all NS");
            }
            if (rrset.size() + rrset.sigSize() > 1) {
                rrset.deleteRR(r);
            } else {
                this.removeRRsetWithoutLock(name, rtype);
            }
        });
    }

    public void addRRset(RRset rrset) {
        if (rrset == null) {
            throw new IllegalArgumentException("rrset must not be null");
        }
        Name name = rrset.getName();
        int type = rrset.getType();
        if (type == 6) {
            if (!name.equals(this.origin)) {
                throw new IllegalArgumentException("SOA owner " + name + " does not match zone origin " + this.origin);
            }
            if (rrset.size() != 1) {
                throw new IllegalArgumentException(this.origin + ": exactly 1 SOA must be specified");
            }
        }
        if (!name.subdomain(this.origin)) {
            throw new IllegalArgumentException("name " + name + " is absolute and not a subdomain of " + this.origin);
        }
        this.withWriteLock(() -> {
            this.addRRsetWithoutLock(name, rrset);
            if (type == 6) {
                this.soaRecord = (SOARecord)rrset.first();
            }
        });
    }

    public void removeRRset(Name name, int type) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Type.check(type);
        this.withWriteLock(() -> this.removeRRsetWithoutLock(name, type));
    }

    public RRset findExactMatch(Name name, int type) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Type.check(type);
        return this.withReadLock(() -> {
            RRset set = this.findRRsetWithoutLock(name, type);
            if (set == null) {
                return null;
            }
            return new RRset(set);
        });
    }

    public SetResponse findRecords(Name name, int type) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Type.check(type);
        if (!name.subdomain(this.origin)) {
            return SetResponse.ofType(SetResponseType.NXDOMAIN);
        }
        return this.withReadLock(() -> this.findRecordsWithoutLock(name, type));
    }

    private <T> T withReadLock(Supplier<T> callable) {
        this.readLock.lock();
        try {
            T t = callable.get();
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void withWriteLock(Runnable callable) {
        this.writeLock.lock();
        try {
            callable.run();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Object exactName(Name name) {
        return this.data.get(name);
    }

    private List<RRset> allRRsetsWithoutLock(Object types) {
        if (types instanceof List) {
            return (List)types;
        }
        return Collections.singletonList((RRset)types);
    }

    private RRset oneRRsetWithoutLock(Object types, int type) {
        if (type == 255) {
            throw new IllegalArgumentException("Cannot lookup an exact match for type ANY");
        }
        if (types instanceof List) {
            List list = (List)types;
            for (RRset set : list) {
                if (set.getType() != type) continue;
                return set;
            }
        } else {
            RRset set = (RRset)types;
            if (set.getType() == type) {
                return set;
            }
        }
        return null;
    }

    private RRset findRRsetWithoutLock(Name name, int type) {
        Object types = this.exactName(name);
        if (types == null) {
            return null;
        }
        return this.oneRRsetWithoutLock(types, type);
    }

    private void addRRsetWithoutLock(Name name, RRset rrset) {
        Object types;
        if (!this.hasWild && name.isWild()) {
            this.hasWild = true;
        }
        if ((types = this.data.get(name)) == null) {
            this.data.put(name, rrset);
            return;
        }
        int rtype = rrset.getType();
        if (types instanceof List) {
            List list = (List)types;
            for (int i = 0; i < list.size(); ++i) {
                RRset set = (RRset)list.get(i);
                if (set.getType() != rtype) continue;
                list.set(i, rrset);
                return;
            }
            list.add(rrset);
        } else {
            RRset set = (RRset)types;
            if (set.getType() == rtype) {
                this.data.put(name, rrset);
            } else {
                LinkedList<RRset> list = new LinkedList<RRset>();
                list.add(set);
                list.add(rrset);
                this.data.put(name, list);
            }
        }
    }

    private void removeRRsetWithoutLock(Name name, int type) {
        if (type == 6) {
            throw new IllegalArgumentException("Cannot remove SOA");
        }
        if (type == 2) {
            throw new IllegalArgumentException("Cannot remove all NS");
        }
        Object types = this.data.get(name);
        if (types == null) {
            return;
        }
        if (types instanceof List) {
            List list = (List)types;
            for (int i = 0; i < list.size(); ++i) {
                RRset set = (RRset)list.get(i);
                if (set.getType() != type) continue;
                list.remove(i);
                break;
            }
            if (list.isEmpty()) {
                this.data.remove(name);
            }
        } else {
            RRset set = (RRset)types;
            if (set.getType() != type) {
                return;
            }
            this.data.remove(name);
        }
    }

    private SetResponse findRecordsWithoutLock(Name name, int type) {
        int olabels;
        int labels = name.labels();
        for (int tlabels = olabels = this.origin.labels(); tlabels <= labels; ++tlabels) {
            RRset rrset;
            RRset ns;
            boolean isExact;
            boolean isOrigin = tlabels == olabels;
            boolean bl = isExact = tlabels == labels;
            Name tname = isOrigin ? this.origin : (isExact ? name : new Name(name, labels - tlabels));
            Object types = this.exactName(tname);
            if (types == null) continue;
            if (!isOrigin && (ns = this.oneRRsetWithoutLock(types, 2)) != null) {
                return SetResponse.ofType(SetResponseType.DELEGATION, ns);
            }
            if (isExact && type == 255) {
                SetResponse sr = SetResponse.ofType(SetResponseType.SUCCESSFUL);
                for (RRset set : this.allRRsetsWithoutLock(types)) {
                    sr.addRRset(set);
                }
                return sr;
            }
            if (isExact) {
                rrset = this.oneRRsetWithoutLock(types, type);
                if (rrset != null) {
                    return SetResponse.ofType(SetResponseType.SUCCESSFUL, rrset);
                }
                rrset = this.oneRRsetWithoutLock(types, 5);
                if (rrset != null) {
                    return SetResponse.ofType(SetResponseType.CNAME, rrset);
                }
            } else {
                rrset = this.oneRRsetWithoutLock(types, 39);
                if (rrset != null) {
                    return SetResponse.ofType(SetResponseType.DNAME, rrset);
                }
            }
            if (!isExact) continue;
            return SetResponse.ofType(SetResponseType.NXRRSET);
        }
        if (this.hasWild) {
            for (int i = 0; i < labels - olabels; ++i) {
                Name tname = name.wild(i + 1);
                Object types = this.exactName(tname);
                if (types == null) continue;
                if (type == 255) {
                    SetResponse sr = SetResponse.ofType(SetResponseType.SUCCESSFUL);
                    for (RRset set : this.allRRsetsWithoutLock(types)) {
                        sr.addRRset(this.expandSet(set, name));
                    }
                    return sr;
                }
                RRset rrset = this.oneRRsetWithoutLock(types, type);
                if (rrset == null) continue;
                return SetResponse.ofType(SetResponseType.SUCCESSFUL, this.expandSet(rrset, name));
            }
        }
        return SetResponse.ofType(SetResponseType.NXDOMAIN);
    }

    private RRset expandSet(RRset set, Name tname) {
        RRset expandedSet = new RRset();
        for (Record record : set.rrs(false)) {
            expandedSet.addRR(record.withName(tname));
        }
        for (RRSIGRecord rRSIGRecord : set.sigs()) {
            expandedSet.addRR(rRSIGRecord.withName(tname));
        }
        return expandedSet;
    }

    private void nodeToString(StringBuilder sb, Object node) {
        List<RRset> sets = this.allRRsetsWithoutLock(node);
        for (RRset rrset : sets) {
            rrset.rrs(false).forEach(r -> sb.append(r).append('\n'));
            rrset.sigs().forEach(r -> sb.append(r).append('\n'));
        }
    }

    public String toMasterFile() {
        StringBuilder sb = new StringBuilder();
        this.withReadLock(() -> {
            this.nodeToString(sb, this.originNode);
            for (Map.Entry<Name, Object> entry : this.data.entrySet()) {
                if (this.origin.equals(entry.getKey())) continue;
                this.nodeToString(sb, entry.getValue());
            }
            return null;
        });
        return sb.toString();
    }

    public String toString() {
        return this.toMasterFile();
    }

    @Generated
    public Name getOrigin() {
        return this.origin;
    }

    class ZoneIterator
    implements Iterator<RRset> {
        private final Iterator<Map.Entry<Name, Object>> zoneEntries;
        private List<RRset> current;
        private int index;
        private boolean wantLastSOA;
        private RRset returnedSet;
        private RRset soaSet;

        ZoneIterator(boolean axfr) {
            this.zoneEntries = Zone.this.data.entrySet().iterator();
            this.wantLastSOA = axfr;
            List originSets = (List)Zone.this.withReadLock(() -> new ArrayList(Zone.this.allRRsetsWithoutLock(Zone.this.originNode)));
            RRset[] sortedOriginSets = new RRset[originSets.size()];
            this.current = Arrays.asList(sortedOriginSets);
            int j = 2;
            for (int i = 0; i < originSets.size(); ++i) {
                RRset originSet = (RRset)originSets.get(i);
                int type = originSet.getType();
                if (type == 6) {
                    sortedOriginSets[0] = this.soaSet = new RRset(originSet);
                    continue;
                }
                if (type == 2) {
                    sortedOriginSets[1] = new RRset(originSet);
                    continue;
                }
                sortedOriginSets[j++] = new RRset(originSet);
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null || this.wantLastSOA;
        }

        @Override
        public RRset next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements");
            }
            if (this.current == null) {
                this.wantLastSOA = false;
                this.returnedSet = this.soaSet;
                return this.returnedSet;
            }
            this.returnedSet = new RRset(this.current.get(this.index++));
            if (this.index == this.current.size()) {
                this.current = null;
                while (this.zoneEntries.hasNext()) {
                    List sets;
                    Map.Entry<Name, Object> entry = this.zoneEntries.next();
                    if (entry.getKey().equals(Zone.this.origin) || (sets = (List)Zone.this.withReadLock(() -> new ArrayList(Zone.this.allRRsetsWithoutLock(entry.getValue())))).isEmpty()) continue;
                    this.current = sets;
                    this.index = 0;
                    break;
                }
            }
            return this.returnedSet;
        }

        @Override
        public void remove() {
            if (this.returnedSet == null) {
                throw new IllegalStateException("Not at an element");
            }
            Zone.this.withWriteLock(() -> Zone.this.removeRRsetWithoutLock(this.returnedSet.getName(), this.returnedSet.getType()));
        }
    }
}

