/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.function.FunctionEnv;

public abstract class AccumulatorExpr
implements Accumulator {
    private final Set<NodeValue> values;
    private long accCount = 0L;
    protected long errorCount = 0L;
    private final Expr expr;
    protected final boolean makeDistinct;

    protected AccumulatorExpr(Expr expr, boolean makeDistinct) {
        this.expr = expr;
        this.makeDistinct = makeDistinct;
        this.values = makeDistinct ? new HashSet() : null;
    }

    @Override
    public final void accumulate(Binding binding, FunctionEnv functionEnv) {
        NodeValue nv = ExprLib.evalOrNull(this.expr, binding, functionEnv);
        if (nv != null) {
            if (this.makeDistinct) {
                if (this.values.contains(nv)) {
                    return;
                }
                this.values.add(nv);
            }
            try {
                this.accumulate(nv, binding, functionEnv);
                ++this.accCount;
                return;
            }
            catch (ExprEvalException exprEvalException) {
                // empty catch block
            }
        }
        this.accumulateError(binding, functionEnv);
        ++this.errorCount;
    }

    @Override
    public NodeValue getValue() {
        if (this.errorCount == 0L) {
            return this.getAccValue();
        }
        return null;
    }

    protected long getAccCount() {
        return this.accCount;
    }

    protected abstract NodeValue getAccValue();

    protected abstract void accumulate(NodeValue var1, Binding var2, FunctionEnv var3);

    protected abstract void accumulateError(Binding var1, FunctionEnv var2);
}

