/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.main;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.system.progress.MonitorOutput;
import org.apache.jena.tdb2.loader.BulkLoaderException;
import org.apache.jena.tdb2.loader.base.BulkStartFinish;
import org.apache.jena.tdb2.loader.base.CoLib;
import org.apache.jena.tdb2.loader.main.DataBlock;
import org.apache.jena.tdb2.loader.main.Destination;
import org.apache.jena.tdb2.loader.main.LoaderConst;
import org.apache.jena.tdb2.loader.main.PhasedOps;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;

public class DataToTuples
implements BulkStartFinish {
    private long countTriples;
    private long countQuads;
    private final Destination<Tuple<NodeId>> dest3;
    private final Destination<Tuple<NodeId>> dest4;
    private final DatasetGraphTDB dsgtdb;
    private final NodeTable nodeTable;
    private List<Tuple<NodeId>> quads = null;
    private List<Tuple<NodeId>> triples = null;
    private final MonitorOutput output;
    private BlockingQueue<DataBlock> input;
    private Thread thread;
    private TransactionCoordinator coordinator;
    private Transaction transaction;
    private final Semaphore termination = new Semaphore(0);

    public DataToTuples(DatasetGraphTDB dsgtdb, Destination<Tuple<NodeId>> tuples3, Destination<Tuple<NodeId>> tuples4, MonitorOutput output) {
        this.dsgtdb = dsgtdb;
        this.dest3 = tuples3;
        this.dest4 = tuples4;
        this.input = new ArrayBlockingQueue<DataBlock>(10);
        this.nodeTable = dsgtdb.getQuadTable().getNodeTupleTable().getNodeTable();
        this.output = output;
        NodeTable nodeTable2 = dsgtdb.getTripleTable().getNodeTupleTable().getNodeTable();
        if (this.nodeTable != nodeTable2) {
            throw new BulkLoaderException("Different node tables");
        }
    }

    public Consumer<DataBlock> data() {
        return this::index;
    }

    private void index(DataBlock dataBlock) {
        try {
            this.input.put(dataBlock);
        }
        catch (InterruptedException e) {
            throw new BulkLoaderException("InterruptedException", e);
        }
    }

    @Override
    public void startBulk() {
        this.thread = new Thread(() -> this.action());
        this.thread.start();
    }

    @Override
    public void finishBulk() {
        PhasedOps.acquire(this.termination);
    }

    private void action() {
        this.coordinator = CoLib.newCoordinator();
        CoLib.add(this.coordinator, this.nodeTable);
        CoLib.start(this.coordinator);
        this.transaction = this.coordinator.begin(TxnType.WRITE);
        try {
            DataBlock data;
            while ((data = this.input.take()) != DataBlock.END) {
                ArrayList<Tuple<NodeId>> tuples;
                if (data.triples != null) {
                    tuples = new ArrayList<Tuple<NodeId>>(data.triples.size());
                    for (Triple t : data.triples) {
                        ++this.countTriples;
                        DataToTuples.accTuples(t, this.nodeTable, tuples);
                    }
                    this.dispatchTuples3(tuples);
                }
                if (data.quads == null) continue;
                tuples = new ArrayList(data.quads.size());
                for (Quad q : data.quads) {
                    ++this.countQuads;
                    DataToTuples.accTuples(q, this.nodeTable, tuples);
                }
                this.dispatchTuples4(tuples);
            }
            this.dispatchTuples3(LoaderConst.END_TUPLES);
            this.dispatchTuples4(LoaderConst.END_TUPLES);
            this.transaction.commit();
        }
        catch (Exception ex) {
            Log.error((Object)this, (String)"Exception during data loading", (Throwable)ex);
            this.transaction.abort();
        }
        this.transaction.end();
        CoLib.finish(this.coordinator);
        this.termination.release();
    }

    public long getCountTriples() {
        return this.countTriples;
    }

    public long getCountQuads() {
        return this.countQuads;
    }

    private void dispatchTuples3(List<Tuple<NodeId>> chunk) {
        this.dest3.deliver(chunk);
    }

    private void dispatchTuples4(List<Tuple<NodeId>> chunk) {
        this.dest4.deliver(chunk);
    }

    private static void accTuples(Triple triple, NodeTable nodeTable, List<Tuple<NodeId>> acc) {
        acc.add(DataToTuples.nodes(nodeTable, triple));
    }

    private static void accTuples(Quad quad, NodeTable nodeTable, List<Tuple<NodeId>> acc) {
        acc.add(DataToTuples.nodes(nodeTable, quad));
    }

    private List<Tuple<NodeId>> allocChunkTriples() {
        return new ArrayList<Tuple<NodeId>>(100000);
    }

    private List<Tuple<NodeId>> allocChunkQuads() {
        return new ArrayList<Tuple<NodeId>>(100000);
    }

    private static Tuple<NodeId> nodes(NodeTable nt, Triple triple) {
        NodeId s = DataToTuples.idForNode(nt, triple.getSubject());
        NodeId p = DataToTuples.idForNode(nt, triple.getPredicate());
        NodeId o = DataToTuples.idForNode(nt, triple.getObject());
        return TupleFactory.tuple((Object[])new NodeId[]{s, p, o});
    }

    private Function<List<Quad>, List<Tuple<NodeId>>> quadsToNodeIds(NodeTable nodeTable) {
        return quads -> {
            ArrayList<Tuple<NodeId>> x = new ArrayList<Tuple<NodeId>>(quads.size());
            for (Quad quad : quads) {
                x.add(DataToTuples.nodes(nodeTable, quad));
            }
            return x;
        };
    }

    private static Tuple<NodeId> nodes(NodeTable nt, Quad quad) {
        NodeId g = DataToTuples.idForNode(nt, quad.getGraph());
        NodeId s = DataToTuples.idForNode(nt, quad.getSubject());
        NodeId p = DataToTuples.idForNode(nt, quad.getPredicate());
        NodeId o = DataToTuples.idForNode(nt, quad.getObject());
        return TupleFactory.tuple((Object[])new NodeId[]{g, s, p, o});
    }

    private static final NodeId idForNode(NodeTable nodeTable, Node node) {
        return nodeTable.getAllocateNodeId(node);
    }
}

