/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package tdb2;

import arq.cmdline.ModLangOutput;
import org.apache.jena.tdb2.store.DatasetGraphSwitchable;
import org.apache.jena.tdb2.sys.DatabaseOps;
import tdb2.cmdline.CmdTDB;

public class tdbbackup extends CmdTDB {
    static ModLangOutput modLangOutput = new ModLangOutput();

    static public void main(String...argv) {
        CmdTDB.init();
        new tdbbackup(argv).mainRun();
    }

    protected tdbbackup(String[] argv) {
        super(argv);
        addModule(modLangOutput);
    }

    @Override
    protected String getSummary() {
        return getCommandName() + " : Backup a TDB dataset";
    }

    @Override
    protected void exec() {
        DatasetGraphSwitchable dsg = getDatabaseContainer();
        String fn = DatabaseOps.backup(dsg);
        System.out.println("Backup written to " + fn);
    }
}
