/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.util.Assert;

public class MinimumBoundingCircle {
    private Geometry input;
    private Coordinate[] extremalPts = null;
    private Coordinate centre = null;
    private double radius = 0.0;

    public MinimumBoundingCircle(Geometry geom) {
        this.input = geom;
    }

    public Geometry getCircle() {
        this.compute();
        if (this.centre == null) {
            return this.input.getFactory().createPolygon();
        }
        Point centrePoint = this.input.getFactory().createPoint(this.centre);
        if (this.radius == 0.0) {
            return centrePoint;
        }
        return centrePoint.buffer(this.radius);
    }

    public Geometry getMaximumDiameter() {
        this.compute();
        switch (this.extremalPts.length) {
            case 0: {
                return this.input.getFactory().createLineString();
            }
            case 1: {
                return this.input.getFactory().createPoint(this.centre);
            }
            case 2: {
                return this.input.getFactory().createLineString(new Coordinate[]{this.extremalPts[0], this.extremalPts[1]});
            }
        }
        Coordinate[] maxDiameter = MinimumBoundingCircle.farthestPoints(this.extremalPts);
        return this.input.getFactory().createLineString(maxDiameter);
    }

    public Geometry getFarthestPoints() {
        return this.getMaximumDiameter();
    }

    private static Coordinate[] farthestPoints(Coordinate[] pts) {
        double dist01 = pts[0].distance(pts[1]);
        double dist12 = pts[1].distance(pts[2]);
        double dist20 = pts[2].distance(pts[0]);
        if (dist01 >= dist12 && dist01 >= dist20) {
            return new Coordinate[]{pts[0], pts[1]};
        }
        if (dist12 >= dist01 && dist12 >= dist20) {
            return new Coordinate[]{pts[1], pts[2]};
        }
        return new Coordinate[]{pts[2], pts[0]};
    }

    public Geometry getDiameter() {
        this.compute();
        switch (this.extremalPts.length) {
            case 0: {
                return this.input.getFactory().createLineString();
            }
            case 1: {
                return this.input.getFactory().createPoint(this.centre);
            }
        }
        Coordinate p0 = this.extremalPts[0];
        Coordinate p1 = this.extremalPts[1];
        return this.input.getFactory().createLineString(new Coordinate[]{p0, p1});
    }

    public Coordinate[] getExtremalPoints() {
        this.compute();
        return this.extremalPts;
    }

    public Coordinate getCentre() {
        this.compute();
        return this.centre;
    }

    public double getRadius() {
        this.compute();
        return this.radius;
    }

    private void computeCentre() {
        switch (this.extremalPts.length) {
            case 0: {
                this.centre = null;
                break;
            }
            case 1: {
                this.centre = this.extremalPts[0];
                break;
            }
            case 2: {
                this.centre = new Coordinate((this.extremalPts[0].x + this.extremalPts[1].x) / 2.0, (this.extremalPts[0].y + this.extremalPts[1].y) / 2.0);
                break;
            }
            case 3: {
                this.centre = Triangle.circumcentre(this.extremalPts[0], this.extremalPts[1], this.extremalPts[2]);
            }
        }
    }

    private void compute() {
        if (this.extremalPts != null) {
            return;
        }
        this.computeCirclePoints();
        this.computeCentre();
        if (this.centre != null) {
            this.radius = this.centre.distance(this.extremalPts[0]);
        }
    }

    private void computeCirclePoints() {
        Coordinate[] hullPts;
        if (this.input.isEmpty()) {
            this.extremalPts = new Coordinate[0];
            return;
        }
        if (this.input.getNumPoints() == 1) {
            Coordinate[] pts = this.input.getCoordinates();
            this.extremalPts = new Coordinate[]{new Coordinate(pts[0])};
            return;
        }
        Geometry convexHull = this.input.convexHull();
        Coordinate[] pts = hullPts = convexHull.getCoordinates();
        if (hullPts[0].equals2D(hullPts[hullPts.length - 1])) {
            pts = new Coordinate[hullPts.length - 1];
            CoordinateArrays.copyDeep(hullPts, 0, pts, 0, hullPts.length - 1);
        }
        if (pts.length <= 2) {
            this.extremalPts = CoordinateArrays.copyDeep(pts);
            return;
        }
        Coordinate P = MinimumBoundingCircle.lowestPoint(pts);
        Coordinate Q = MinimumBoundingCircle.pointWitMinAngleWithX(pts, P);
        for (int i = 0; i < pts.length; ++i) {
            Coordinate R = MinimumBoundingCircle.pointWithMinAngleWithSegment(pts, P, Q);
            if (Angle.isObtuse(P, R, Q)) {
                this.extremalPts = new Coordinate[]{new Coordinate(P), new Coordinate(Q)};
                return;
            }
            if (Angle.isObtuse(R, P, Q)) {
                P = R;
                continue;
            }
            if (Angle.isObtuse(R, Q, P)) {
                Q = R;
                continue;
            }
            this.extremalPts = new Coordinate[]{new Coordinate(P), new Coordinate(Q), new Coordinate(R)};
            return;
        }
        Assert.shouldNeverReachHere("Logic failure in Minimum Bounding Circle algorithm!");
    }

    private static Coordinate lowestPoint(Coordinate[] pts) {
        Coordinate min2 = pts[0];
        for (int i = 1; i < pts.length; ++i) {
            if (!(pts[i].y < min2.y)) continue;
            min2 = pts[i];
        }
        return min2;
    }

    private static Coordinate pointWitMinAngleWithX(Coordinate[] pts, Coordinate P) {
        double minSin = Double.MAX_VALUE;
        Coordinate minAngPt = null;
        for (int i = 0; i < pts.length; ++i) {
            double len;
            double sin2;
            Coordinate p = pts[i];
            if (p == P) continue;
            double dx = p.x - P.x;
            double dy = p.y - P.y;
            if (dy < 0.0) {
                dy = -dy;
            }
            if (!((sin2 = dy / (len = Math.hypot(dx, dy))) < minSin)) continue;
            minSin = sin2;
            minAngPt = p;
        }
        return minAngPt;
    }

    private static Coordinate pointWithMinAngleWithSegment(Coordinate[] pts, Coordinate P, Coordinate Q) {
        double minAng = Double.MAX_VALUE;
        Coordinate minAngPt = null;
        for (int i = 0; i < pts.length; ++i) {
            double ang;
            Coordinate p = pts[i];
            if (p == P || p == Q || !((ang = Angle.angleBetween(P, p, Q)) < minAng)) continue;
            minAng = ang;
            minAngPt = p;
        }
        return minAngPt;
    }
}

