/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Comparator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class DifferenceEnumeration
implements SequenceIterator {
    private final SequenceIterator p1;
    private final SequenceIterator p2;
    private NodeInfo nextNode1 = null;
    private NodeInfo nextNode2 = null;
    private final Comparator<? super NodeInfo> comparer;

    public DifferenceEnumeration(SequenceIterator p1, SequenceIterator p2, Comparator<? super NodeInfo> comparer) throws XPathException {
        this.p1 = p1;
        this.p2 = p2;
        this.comparer = comparer;
        this.nextNode1 = this.nextNode(p1);
        this.nextNode2 = this.nextNode(p2);
    }

    private NodeInfo nextNode(SequenceIterator iter) {
        return (NodeInfo)iter.next();
    }

    @Override
    public NodeInfo next() {
        while (true) {
            if (this.nextNode1 == null) {
                this.p2.close();
                return null;
            }
            if (this.nextNode2 == null) {
                return this.deliver();
            }
            int c = this.comparer.compare(this.nextNode1, this.nextNode2);
            if (c < 0) {
                return this.deliver();
            }
            if (c > 0) {
                this.nextNode2 = this.nextNode(this.p2);
                if (this.nextNode2 != null) continue;
                return this.deliver();
            }
            this.nextNode2 = this.nextNode(this.p2);
            this.nextNode1 = this.nextNode(this.p1);
        }
    }

    private NodeInfo deliver() {
        NodeInfo current = this.nextNode1;
        this.nextNode1 = this.nextNode(this.p1);
        return current;
    }

    @Override
    public void close() {
        this.p1.close();
        this.p2.close();
    }

    @Override
    public void discharge() {
        this.p1.discharge();
        this.p2.discharge();
    }
}

