/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.function.TransformByFunction;

public abstract class CompareByFunction
extends TransformByFunction {
    protected abstract boolean sortsBefore(int var1);

    @Override
    protected <T> TransformByFunction.Aggregator<T> createAggregator(Adapter<T> runtime, int elementCount, T element, T elementValue) {
        return new ComparingAggregator<T>(runtime, element, elementValue);
    }

    @Override
    protected <T> T createNullValue(Adapter<T> runtime) {
        return runtime.createNull();
    }

    private static class Pair<U> {
        public final U element;
        public final U elementValue;

        public Pair(U element, U elementValue) {
            this.element = element;
            this.elementValue = elementValue;
        }
    }

    private class ComparingAggregator<V>
    extends TransformByFunction.Aggregator<V> {
        private Pair<V> current;

        public ComparingAggregator(Adapter<V> runtime, V initialElement, V initialValue) {
            super(runtime);
            this.current = new Pair<V>(initialElement, initialValue);
        }

        @Override
        protected void aggregate(V candidate, V candidateValue) {
            if (CompareByFunction.this.sortsBefore(this.runtime.compare(candidateValue, this.current.elementValue))) {
                this.current = new Pair<V>(candidate, candidateValue);
            }
        }

        @Override
        protected V result() {
            return (V)this.current.element;
        }
    }
}

