/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.GeometryKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.PathData;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TargetCollectorHelper;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\nJ\u0014\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\nJ\u001a\u0010\u0018\u001a\u00020\u000f2\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\nJ\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/TargetCollectorHelper;", "", "geomKind", "Lorg/jetbrains/letsPlot/core/plot/base/GeomKind;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "(Lorg/jetbrains/letsPlot/core/plot/base/GeomKind;Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;)V", "colorMarkerMapper", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "", "Lorg/jetbrains/letsPlot/commons/values/Color;", "targetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "addPath", "", "path", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/PathData;", "tooltipParams", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector$TooltipParams;", "addPaths", "paths", "addPolygons", "pathDataList", "addVariadicPaths", "reduce", "plot-base"})
@SourceDebugExtension(value={"SMAP\nTargetCollectorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetCollectorHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/TargetCollectorHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1549#2:77\n1620#2,3:78\n1360#2:81\n1446#2,5:82\n1855#2,2:87\n1#3:89\n*S KotlinDebug\n*F\n+ 1 TargetCollectorHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/TargetCollectorHelper\n*L\n34#1:77\n34#1:78,3\n48#1:81\n48#1:82,5\n54#1:87,2\n*E\n"})
public final class TargetCollectorHelper {
    @NotNull
    private final GeomContext ctx;
    @NotNull
    private final Function1<DataPointAesthetics, List<Color>> colorMarkerMapper;
    @NotNull
    private final GeomTargetCollector targetCollector;

    public TargetCollectorHelper(@NotNull GeomKind geomKind, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)geomKind), (String)"geomKind");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.ctx = ctx;
        this.colorMarkerMapper = HintColorUtil.INSTANCE.createColorMarkerMapper(geomKind, this.ctx);
        this.targetCollector = this.ctx.getTargetCollector();
    }

    public final void addPaths(@NotNull List<PathData> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        for (PathData path : paths) {
            PathData simplifiedPath = this.reduce(path);
            this.addPath(simplifiedPath, new GeomTargetCollector.TooltipParams(null, null, null, (List)this.colorMarkerMapper.invoke((Object)simplifiedPath.getAes()), 7, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addVariadicPaths(@NotNull List<? extends List<PathData>> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        for (List<PathData> list2 : paths) {
            void $this$flatMapTo$iv$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                PathData pathData = (PathData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.reduce((PathData)p0));
            }
            List simplifiedSubPaths = (List)destination$iv$iv;
            Map subPathAesIndex = new LinkedHashMap();
            for (PathData subPath : simplifiedSubPaths) {
                for (DataPointAesthetics p : subPath.getAesthetics()) {
                    subPathAesIndex.put(p.index(), subPath.getAes());
                }
            }
            Iterable $this$flatMap$iv = simplifiedSubPaths;
            boolean $i$f$flatMap = false;
            Iterable p = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                PathData p0 = (PathData)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = p0.getPoints();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List list22 = (List)destination$iv$iv2;
            PathData flattenPath = new PathData(list22);
            this.addPath(flattenPath, new GeomTargetCollector.TooltipParams(null, null, null, (Function1)new Function1<Integer, List<? extends Color>>(this, (Map<Integer, DataPointAesthetics>)subPathAesIndex){
                final /* synthetic */ TargetCollectorHelper this$0;
                final /* synthetic */ Map<Integer, DataPointAesthetics> $subPathAesIndex;
                {
                    this.this$0 = $receiver;
                    this.$subPathAesIndex = $subPathAesIndex;
                    super(1);
                }

                @NotNull
                public final List<Color> invoke(int i) {
                    Function1 function1 = TargetCollectorHelper.access$getColorMarkerMapper$p(this.this$0);
                    DataPointAesthetics dataPointAesthetics = this.$subPathAesIndex.get(i);
                    Intrinsics.checkNotNull((Object)dataPointAesthetics);
                    return (List)function1.invoke((Object)dataPointAesthetics);
                }
            }, 7, null));
        }
    }

    public final void addPolygons(@NotNull List<PathData> pathDataList) {
        Intrinsics.checkNotNullParameter(pathDataList, (String)"pathDataList");
        Iterable $this$forEach$iv = pathDataList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PathData pathData = (PathData)element$iv;
            boolean bl = false;
            this.targetCollector.addPolygon(pathData.getCoordinates(), pathData.getAes().index(), new GeomTargetCollector.TooltipParams(null, null, null, (List)this.colorMarkerMapper.invoke((Object)pathData.getAes()), 7, null), TipLayoutHint.Kind.CURSOR_TOOLTIP);
        }
    }

    private final void addPath(PathData path, GeomTargetCollector.TooltipParams tooltipParams) {
        TipLayoutHint.Kind kind;
        TipLayoutHint.Kind kind2 = kind = TipLayoutHint.Kind.VERTICAL_TOOLTIP;
        GeomTargetCollector.TooltipParams tooltipParams2 = tooltipParams;
        Function1 function1 = (Function1)new Function1<Integer, Integer>(path){
            final /* synthetic */ PathData $path;
            {
                this.$path = $path;
                super(1);
            }

            @NotNull
            public final Integer invoke(int i) {
                return this.$path.getAesthetics().get(i).index();
            }
        };
        List<DoubleVector> list2 = path.getCoordinates();
        GeomTargetCollector geomTargetCollector = this.targetCollector;
        boolean bl = false;
        boolean bl2 = this.ctx.getFlipped();
        TipLayoutHint.Kind kind3 = bl2 ? kind : null;
        if (kind3 == null) {
            kind3 = TipLayoutHint.Kind.HORIZONTAL_TOOLTIP;
        }
        geomTargetCollector.addPath(list2, (Function1<? super Integer, Integer>)function1, tooltipParams2, kind3);
    }

    private final PathData reduce(PathData path) {
        return new PathData(GeometryKt.reduce(path.getPoints(), (double)0.5, (Function2)reduce.1.INSTANCE));
    }

    public static final /* synthetic */ Function1 access$getColorMarkerMapper$p(TargetCollectorHelper $this) {
        return $this.colorMarkerMapper;
    }
}

