/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileDialoger {
    private static String lastJFCDirectory = null;
    private static JFileChooser jfc = new JFileChooser();
    private static final Logger LOG = LoggerFactory.getLogger(FileDialoger.class);

    private FileDialoger() {
    }

    public static JFileChooser promptToOpenFile() {
        return FileDialoger.promptToOpenFile((String)null);
    }

    public static JFileChooser promptToOpenFile(String existingFileName) {
        return FileDialoger.promptToOpenFile(new String[0], existingFileName);
    }

    public static JFileChooser promptToOpenFile(String existingFileName, boolean onlyDirectories) {
        return FileDialoger.promptToOpenFile(new String[0], existingFileName, onlyDirectories);
    }

    public static JFileChooser promptToOpenFile(String[] exts) {
        return FileDialoger.promptToOpenFile(exts, null);
    }

    public static JFileChooser promptToOpenFile(String[] exts, String existingFileName) {
        return FileDialoger.promptToOpenFile(exts, existingFileName, false);
    }

    public static JFileChooser promptToOpenFile(String[] exts, String existingFileName, boolean onlyDirectories) {
        return FileDialoger.promptToOpenFile(GuiPackage.getInstance().getMainFrame(), exts, existingFileName, onlyDirectories);
    }

    public static JFileChooser promptToOpenFile(Component parentComponent, String[] exts, String existingFileName, boolean onlyDirectories) {
        if (onlyDirectories) {
            jfc.setFileSelectionMode(1);
        } else {
            jfc.setFileSelectionMode(0);
        }
        FileDialoger.setCurrentDirOnJFC(existingFileName, lastJFCDirectory, System.getProperty("user.dir"));
        FileDialoger.clearFileFilters();
        if (exts != null && exts.length > 0) {
            JMeterFileFilter currentFilter = new JMeterFileFilter(exts);
            jfc.addChoosableFileFilter(currentFilter);
            jfc.setAcceptAllFileFilterUsed(true);
            jfc.setFileFilter(currentFilter);
        }
        int retVal = jfc.showOpenDialog(parentComponent);
        lastJFCDirectory = jfc.getCurrentDirectory().getAbsolutePath();
        if (retVal == 0) {
            return jfc;
        }
        return null;
    }

    private static void setCurrentDirOnJFC(String ... dirNames) {
        for (String dirName : dirNames) {
            File possibleDir;
            if (StringUtils.isBlank((CharSequence)dirName) || !(possibleDir = new File(dirName)).exists() || !possibleDir.canRead()) continue;
            jfc.setCurrentDirectory(possibleDir);
            return;
        }
        LOG.info("No valid initial directory found for: {}", Arrays.asList(dirNames));
        jfc.setCurrentDirectory(null);
    }

    private static void clearFileFilters() {
        FileFilter[] filters;
        for (FileFilter filter : filters = jfc.getChoosableFileFilters()) {
            jfc.removeChoosableFileFilter(filter);
        }
    }

    public static JFileChooser promptToSaveFile(String filename) {
        return FileDialoger.promptToSaveFile(filename, null);
    }

    public static JFileChooser promptToSaveFile(String filename, String[] extensions) {
        if (lastJFCDirectory == null) {
            String start2 = System.getProperty("user.dir", "");
            if (start2.length() > 0) {
                jfc = new JFileChooser(new File(start2));
            }
            lastJFCDirectory = jfc.getCurrentDirectory().getAbsolutePath();
        }
        String ext = ".jmx";
        if (filename != null) {
            jfc.setDialogTitle(filename);
            jfc.setSelectedFile(filename.lastIndexOf(File.separator) > 0 ? new File(filename) : new File(lastJFCDirectory, filename));
            int i = -1;
            i = filename.lastIndexOf(46);
            if (i > -1) {
                ext = filename.substring(i);
            }
        }
        FileDialoger.clearFileFilters();
        if (extensions != null) {
            jfc.addChoosableFileFilter(new JMeterFileFilter(extensions));
        } else {
            jfc.addChoosableFileFilter(new JMeterFileFilter(new String[]{ext}));
        }
        int retVal = jfc.showSaveDialog(GuiPackage.getInstance().getMainFrame());
        jfc.setDialogTitle(null);
        lastJFCDirectory = jfc.getCurrentDirectory().getAbsolutePath();
        if (retVal == 0) {
            return jfc;
        }
        return null;
    }

    public static String getLastJFCDirectory() {
        return lastJFCDirectory;
    }

    public static void setLastJFCDirectory(String lastJFCDirectory) {
        FileDialoger.lastJFCDirectory = lastJFCDirectory;
    }
}

