/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.jmeter.samplers.AbstractSampleSender;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoldSampleSender
extends AbstractSampleSender
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(HoldSampleSender.class);
    private static final long serialVersionUID = 241L;
    private final ConcurrentLinkedQueue<SampleEvent> sampleStore = new ConcurrentLinkedQueue();
    private final RemoteSampleListener listener;

    @Deprecated
    public HoldSampleSender() {
        log.warn("Constructor only intended for use in testing");
        this.listener = null;
    }

    HoldSampleSender(RemoteSampleListener listener) {
        this.listener = listener;
        log.warn("Using HoldSampleSender for this test run, ensure you have configured enough memory (-Xmx) for your test");
    }

    @Override
    public void testEnded(String host) {
        log.info("Test Ended on {}", (Object)host);
        try {
            for (SampleEvent se : this.sampleStore) {
                this.listener.sampleOccurred(se);
            }
            this.listener.testEnded(host);
            this.sampleStore.clear();
        }
        catch (Error | RuntimeException ex) {
            log.error("testEnded(host)", ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("testEnded(host)", (Throwable)ex);
        }
    }

    @Override
    public void sampleOccurred(SampleEvent e) {
        this.sampleStore.add(e);
    }

    protected Object readResolve() throws ObjectStreamException {
        log.warn("Using HoldSampleSender for this test run, ensure you have configured enough memory (-Xmx) for your test");
        return this;
    }
}

