/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.ContentType;
import com.amazonaws.services.kendra.model.DocumentAttribute;
import com.amazonaws.services.kendra.model.HierarchicalPrincipal;
import com.amazonaws.services.kendra.model.Principal;
import com.amazonaws.services.kendra.model.S3Path;
import com.amazonaws.services.kendra.model.transform.DocumentMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Document
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String title;
    private ByteBuffer blob;
    private S3Path s3Path;
    private List<DocumentAttribute> attributes;
    private List<Principal> accessControlList;
    private List<HierarchicalPrincipal> hierarchicalAccessControlList;
    private String contentType;
    private String accessControlConfigurationId;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Document withId(String id) {
        this.setId(id);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public Document withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setBlob(ByteBuffer blob) {
        this.blob = blob;
    }

    public ByteBuffer getBlob() {
        return this.blob;
    }

    public Document withBlob(ByteBuffer blob) {
        this.setBlob(blob);
        return this;
    }

    public void setS3Path(S3Path s3Path) {
        this.s3Path = s3Path;
    }

    public S3Path getS3Path() {
        return this.s3Path;
    }

    public Document withS3Path(S3Path s3Path) {
        this.setS3Path(s3Path);
        return this;
    }

    public List<DocumentAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<DocumentAttribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<DocumentAttribute>(attributes);
    }

    public Document withAttributes(DocumentAttribute ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<DocumentAttribute>(attributes.length));
        }
        for (DocumentAttribute ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public Document withAttributes(Collection<DocumentAttribute> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public List<Principal> getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(Collection<Principal> accessControlList) {
        if (accessControlList == null) {
            this.accessControlList = null;
            return;
        }
        this.accessControlList = new ArrayList<Principal>(accessControlList);
    }

    public Document withAccessControlList(Principal ... accessControlList) {
        if (this.accessControlList == null) {
            this.setAccessControlList(new ArrayList<Principal>(accessControlList.length));
        }
        for (Principal ele : accessControlList) {
            this.accessControlList.add(ele);
        }
        return this;
    }

    public Document withAccessControlList(Collection<Principal> accessControlList) {
        this.setAccessControlList(accessControlList);
        return this;
    }

    public List<HierarchicalPrincipal> getHierarchicalAccessControlList() {
        return this.hierarchicalAccessControlList;
    }

    public void setHierarchicalAccessControlList(Collection<HierarchicalPrincipal> hierarchicalAccessControlList) {
        if (hierarchicalAccessControlList == null) {
            this.hierarchicalAccessControlList = null;
            return;
        }
        this.hierarchicalAccessControlList = new ArrayList<HierarchicalPrincipal>(hierarchicalAccessControlList);
    }

    public Document withHierarchicalAccessControlList(HierarchicalPrincipal ... hierarchicalAccessControlList) {
        if (this.hierarchicalAccessControlList == null) {
            this.setHierarchicalAccessControlList(new ArrayList<HierarchicalPrincipal>(hierarchicalAccessControlList.length));
        }
        for (HierarchicalPrincipal ele : hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList.add(ele);
        }
        return this;
    }

    public Document withHierarchicalAccessControlList(Collection<HierarchicalPrincipal> hierarchicalAccessControlList) {
        this.setHierarchicalAccessControlList(hierarchicalAccessControlList);
        return this;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Document withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    public Document withContentType(ContentType contentType) {
        this.contentType = contentType.toString();
        return this;
    }

    public void setAccessControlConfigurationId(String accessControlConfigurationId) {
        this.accessControlConfigurationId = accessControlConfigurationId;
    }

    public String getAccessControlConfigurationId() {
        return this.accessControlConfigurationId;
    }

    public Document withAccessControlConfigurationId(String accessControlConfigurationId) {
        this.setAccessControlConfigurationId(accessControlConfigurationId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getBlob() != null) {
            sb.append("Blob: ").append(this.getBlob()).append(",");
        }
        if (this.getS3Path() != null) {
            sb.append("S3Path: ").append(this.getS3Path()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getAccessControlList() != null) {
            sb.append("AccessControlList: ").append(this.getAccessControlList()).append(",");
        }
        if (this.getHierarchicalAccessControlList() != null) {
            sb.append("HierarchicalAccessControlList: ").append(this.getHierarchicalAccessControlList()).append(",");
        }
        if (this.getContentType() != null) {
            sb.append("ContentType: ").append(this.getContentType()).append(",");
        }
        if (this.getAccessControlConfigurationId() != null) {
            sb.append("AccessControlConfigurationId: ").append(this.getAccessControlConfigurationId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Document)) {
            return false;
        }
        Document other = (Document)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getBlob() == null ^ this.getBlob() == null) {
            return false;
        }
        if (other.getBlob() != null && !other.getBlob().equals(this.getBlob())) {
            return false;
        }
        if (other.getS3Path() == null ^ this.getS3Path() == null) {
            return false;
        }
        if (other.getS3Path() != null && !other.getS3Path().equals(this.getS3Path())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getAccessControlList() == null ^ this.getAccessControlList() == null) {
            return false;
        }
        if (other.getAccessControlList() != null && !other.getAccessControlList().equals(this.getAccessControlList())) {
            return false;
        }
        if (other.getHierarchicalAccessControlList() == null ^ this.getHierarchicalAccessControlList() == null) {
            return false;
        }
        if (other.getHierarchicalAccessControlList() != null && !other.getHierarchicalAccessControlList().equals(this.getHierarchicalAccessControlList())) {
            return false;
        }
        if (other.getContentType() == null ^ this.getContentType() == null) {
            return false;
        }
        if (other.getContentType() != null && !other.getContentType().equals(this.getContentType())) {
            return false;
        }
        if (other.getAccessControlConfigurationId() == null ^ this.getAccessControlConfigurationId() == null) {
            return false;
        }
        return other.getAccessControlConfigurationId() == null || other.getAccessControlConfigurationId().equals(this.getAccessControlConfigurationId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getBlob() == null ? 0 : this.getBlob().hashCode());
        hashCode = 31 * hashCode + (this.getS3Path() == null ? 0 : this.getS3Path().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getAccessControlList() == null ? 0 : this.getAccessControlList().hashCode());
        hashCode = 31 * hashCode + (this.getHierarchicalAccessControlList() == null ? 0 : this.getHierarchicalAccessControlList().hashCode());
        hashCode = 31 * hashCode + (this.getContentType() == null ? 0 : this.getContentType().hashCode());
        hashCode = 31 * hashCode + (this.getAccessControlConfigurationId() == null ? 0 : this.getAccessControlConfigurationId().hashCode());
        return hashCode;
    }

    public Document clone() {
        try {
            return (Document)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

