/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.http.response.MethodNotAllowed;
import org.apache.juneau.http.response.NotFound;
import org.apache.juneau.http.response.PreconditionFailed;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.RestSession;

public class RestOperations {
    private final Map<String, List<RestOpContext>> map;
    private RestOpContext[] list;

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public RestOperations(Builder builder) {
        LinkedHashMap<String, List<RestOpContext>> m = CollectionUtils.map();
        for (Map.Entry<String, TreeSet<RestOpContext>> e : builder.map.entrySet()) {
            m.put(e.getKey(), CollectionUtils.listFrom(e.getValue()));
        }
        this.map = m;
        this.list = CollectionUtils.array(builder.set, RestOpContext.class);
    }

    public RestOpContext findOperation(RestSession session) throws MethodNotAllowed, PreconditionFailed, NotFound {
        int mrc;
        String m = session.getMethod();
        int rc = 0;
        if (this.map.containsKey(m)) {
            for (RestOpContext oc : this.map.get(m)) {
                mrc = oc.match(session);
                if (mrc == 2) {
                    return oc;
                }
                rc = Math.max(rc, mrc);
            }
        }
        if (this.map.containsKey("*")) {
            for (RestOpContext oc : this.map.get("*")) {
                mrc = oc.match(session);
                if (mrc == 2) {
                    return oc;
                }
                rc = Math.max(rc, mrc);
            }
        }
        if (rc == 0) {
            for (RestOpContext oc : this.list) {
                int orc;
                if (oc.getPathPattern().endsWith("/*") || (orc = oc.match(session)) != 2) continue;
                throw new MethodNotAllowed();
            }
        }
        if (rc == 1) {
            throw new PreconditionFailed("Method ''{0}'' not found on resource on path ''{1}'' with matching matcher.", new Object[]{m, session.getPathInfo()});
        }
        throw new NotFound("Java method matching path ''{0}'' not found on resource ''{1}''.", new Object[]{session.getPathInfo(), ClassUtils.className(session.getResource())});
    }

    public List<RestOpContext> getOpContexts() {
        return CollectionUtils.ulist(this.list);
    }

    @FluentSetters
    public static class Builder
    extends BeanBuilder<RestOperations> {
        TreeMap<String, TreeSet<RestOpContext>> map = new TreeMap();
        Set<RestOpContext> set = CollectionUtils.set(new RestOpContext[0]);

        protected Builder(BeanStore beanStore) {
            super(RestOperations.class, beanStore);
        }

        @Override
        protected RestOperations buildDefault() {
            return new RestOperations(this);
        }

        public Builder add(RestOpContext value) {
            return this.add(value.getHttpMethod(), value);
        }

        public Builder add(String httpMethodName, RestOpContext value) {
            if (!this.map.containsKey(httpMethodName = httpMethodName.toUpperCase())) {
                this.map.put(httpMethodName, new TreeSet());
            }
            this.map.get(httpMethodName).add(value);
            this.set.add(value);
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }
    }

    public final class Void
    extends RestOperations {
        public Void(Builder builder) throws Exception {
            super(builder);
        }
    }
}

