/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.Arrays;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.metrics.stats.WindowedSum;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.QuorumState;
import org.apache.kafka.raft.ReplicaKey;
import org.apache.kafka.raft.internals.TimeRatio;

public class KafkaRaftMetrics
implements AutoCloseable {
    private final Metrics metrics;
    private volatile OffsetAndEpoch logEndOffset;
    private volatile int numUnknownVoterConnections;
    private volatile OptionalLong electionStartMs;
    private volatile OptionalLong pollStartMs;
    private final MetricName currentLeaderIdMetricName;
    private final MetricName currentVotedIdMetricName;
    private final MetricName currentVotedDirectoryIdMetricName;
    private final MetricName currentEpochMetricName;
    private final MetricName currentStateMetricName;
    private final MetricName highWatermarkMetricName;
    private final MetricName logEndOffsetMetricName;
    private final MetricName logEndEpochMetricName;
    private final MetricName numUnknownVoterConnectionsMetricName;
    private final Sensor commitTimeSensor;
    private final Sensor electionTimeSensor;
    private final Sensor fetchRecordsSensor;
    private final Sensor appendRecordsSensor;
    private final Sensor pollDurationSensor;

    public KafkaRaftMetrics(Metrics metrics, String metricGrpPrefix, QuorumState state) {
        this.metrics = metrics;
        String metricGroupName = metricGrpPrefix + "-metrics";
        this.pollStartMs = OptionalLong.empty();
        this.electionStartMs = OptionalLong.empty();
        this.numUnknownVoterConnections = 0;
        this.logEndOffset = new OffsetAndEpoch(0L, 0);
        this.currentStateMetricName = metrics.metricName("current-state", metricGroupName, "The current state of this member; possible values are leader, candidate, voted, follower, unattached, observer");
        Gauge stateProvider = (mConfig, currentTimeMs) -> {
            if (state.isLeader()) {
                return "leader";
            }
            if (state.isCandidate()) {
                return "candidate";
            }
            if (state.isUnattachedAndVoted()) {
                return "voted";
            }
            if (state.isFollower()) {
                if (state.isObserver()) {
                    return "observer";
                }
                return "follower";
            }
            return "unattached";
        };
        metrics.addMetric(this.currentStateMetricName, null, (MetricValueProvider)stateProvider);
        this.currentLeaderIdMetricName = metrics.metricName("current-leader", metricGroupName, "The current quorum leader's id; -1 indicates unknown");
        metrics.addMetric(this.currentLeaderIdMetricName, (mConfig, currentTimeMs) -> state.leaderId().orElse(-1));
        this.currentVotedIdMetricName = metrics.metricName("current-vote", metricGroupName, "The current voted id; -1 indicates not voted for anyone");
        metrics.addMetric(this.currentVotedIdMetricName, (mConfig, currentTimeMs) -> {
            if (state.isLeader() || state.isCandidate()) {
                return state.localIdOrThrow();
            }
            return state.maybeUnattachedState().flatMap(votedState -> votedState.votedKey().map(ReplicaKey::id)).orElse(-1).intValue();
        });
        this.currentVotedDirectoryIdMetricName = metrics.metricName("current-vote-directory-id", metricGroupName, String.format("The current voted directory id; %s indicates not voted for a directory id", Uuid.ZERO_UUID));
        Gauge votedDirectoryIdProvider = (mConfig, currentTimestamp) -> {
            if (state.isLeader() || state.isCandidate()) {
                return state.localDirectoryId().toString();
            }
            return state.maybeUnattachedState().flatMap(votedState -> votedState.votedKey().flatMap(ReplicaKey::directoryId)).orElse(Uuid.ZERO_UUID).toString();
        };
        metrics.addMetric(this.currentVotedDirectoryIdMetricName, null, (MetricValueProvider)votedDirectoryIdProvider);
        this.currentEpochMetricName = metrics.metricName("current-epoch", metricGroupName, "The current quorum epoch.");
        metrics.addMetric(this.currentEpochMetricName, (mConfig, currentTimeMs) -> state.epoch());
        this.highWatermarkMetricName = metrics.metricName("high-watermark", metricGroupName, "The high watermark maintained on this member; -1 if it is unknown");
        metrics.addMetric(this.highWatermarkMetricName, (mConfig, currentTimeMs) -> state.highWatermark().map(LogOffsetMetadata::offset).orElse(-1L).longValue());
        this.logEndOffsetMetricName = metrics.metricName("log-end-offset", metricGroupName, "The current raft log end offset.");
        metrics.addMetric(this.logEndOffsetMetricName, (mConfig, currentTimeMs) -> this.logEndOffset.offset());
        this.logEndEpochMetricName = metrics.metricName("log-end-epoch", metricGroupName, "The current raft log end epoch.");
        metrics.addMetric(this.logEndEpochMetricName, (mConfig, currentTimeMs) -> this.logEndOffset.epoch());
        this.numUnknownVoterConnectionsMetricName = metrics.metricName("number-unknown-voter-connections", metricGroupName, "Number of unknown voters whose connection information is not cached; would never be larger than quorum-size.");
        metrics.addMetric(this.numUnknownVoterConnectionsMetricName, (mConfig, currentTimeMs) -> this.numUnknownVoterConnections);
        this.commitTimeSensor = metrics.sensor("commit-latency");
        this.commitTimeSensor.add(metrics.metricName("commit-latency-avg", metricGroupName, "The average time in milliseconds to commit an entry in the raft log."), (MeasurableStat)new Avg());
        this.commitTimeSensor.add(metrics.metricName("commit-latency-max", metricGroupName, "The maximum time in milliseconds to commit an entry in the raft log."), (MeasurableStat)new Max());
        this.electionTimeSensor = metrics.sensor("election-latency");
        this.electionTimeSensor.add(metrics.metricName("election-latency-avg", metricGroupName, "The average time in milliseconds spent on electing a new leader."), (MeasurableStat)new Avg());
        this.electionTimeSensor.add(metrics.metricName("election-latency-max", metricGroupName, "The maximum time in milliseconds spent on electing a new leader."), (MeasurableStat)new Max());
        this.fetchRecordsSensor = metrics.sensor("fetch-records");
        this.fetchRecordsSensor.add(metrics.metricName("fetch-records-rate", metricGroupName, "The average number of records fetched from the leader of the raft quorum."), (MeasurableStat)new Rate(TimeUnit.SECONDS, (SampledStat)new WindowedSum()));
        this.appendRecordsSensor = metrics.sensor("append-records");
        this.appendRecordsSensor.add(metrics.metricName("append-records-rate", metricGroupName, "The average number of records appended per sec as the leader of the raft quorum."), (MeasurableStat)new Rate(TimeUnit.SECONDS, (SampledStat)new WindowedSum()));
        this.pollDurationSensor = metrics.sensor("poll-idle-ratio");
        this.pollDurationSensor.add(metrics.metricName("poll-idle-ratio-avg", metricGroupName, "The ratio of time the Raft IO thread is idle as opposed to doing work (e.g. handling requests or replicating from the leader)"), (MeasurableStat)new TimeRatio(1.0));
    }

    public void updatePollStart(long currentTimeMs) {
        this.pollStartMs = OptionalLong.of(currentTimeMs);
    }

    public void updatePollEnd(long currentTimeMs) {
        if (this.pollStartMs.isPresent()) {
            long pollDurationMs = Math.max(currentTimeMs - this.pollStartMs.getAsLong(), 0L);
            this.pollDurationSensor.record((double)pollDurationMs);
            this.pollStartMs = OptionalLong.empty();
        }
    }

    public void updateLogEnd(OffsetAndEpoch logEndOffset) {
        this.logEndOffset = logEndOffset;
    }

    public void updateNumUnknownVoterConnections(int numUnknownVoterConnections) {
        this.numUnknownVoterConnections = numUnknownVoterConnections;
    }

    public void updateAppendRecords(long numRecords) {
        this.appendRecordsSensor.record((double)numRecords);
    }

    public void updateFetchedRecords(long numRecords) {
        this.fetchRecordsSensor.record((double)numRecords);
    }

    public void updateCommitLatency(double latencyMs, long currentTimeMs) {
        this.commitTimeSensor.record(latencyMs, currentTimeMs);
    }

    public void updateElectionStartMs(long currentTimeMs) {
        this.electionStartMs = OptionalLong.of(currentTimeMs);
    }

    public void maybeUpdateElectionLatency(long currentTimeMs) {
        if (this.electionStartMs.isPresent()) {
            this.electionTimeSensor.record((double)(currentTimeMs - this.electionStartMs.getAsLong()), currentTimeMs);
            this.electionStartMs = OptionalLong.empty();
        }
    }

    @Override
    public void close() {
        Arrays.asList(this.currentLeaderIdMetricName, this.currentVotedIdMetricName, this.currentVotedDirectoryIdMetricName, this.currentEpochMetricName, this.currentStateMetricName, this.highWatermarkMetricName, this.logEndOffsetMetricName, this.logEndEpochMetricName, this.numUnknownVoterConnectionsMetricName).forEach(arg_0 -> ((Metrics)this.metrics).removeMetric(arg_0));
        Arrays.asList(this.commitTimeSensor.name(), this.electionTimeSensor.name(), this.fetchRecordsSensor.name(), this.appendRecordsSensor.name(), this.pollDurationSensor.name()).forEach(arg_0 -> ((Metrics)this.metrics).removeSensor(arg_0));
    }
}

