/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionAware;
import org.apache.sshd.server.shell.InvertedShell;

public class InvertedShellWrapper
extends AbstractLoggingBean
implements Command,
ServerSessionAware {
    private final InvertedShell shell;
    private final Executor executor;
    private int bufferSize;
    private Duration pumpSleepTime;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private OutputStream shellIn;
    private InputStream shellOut;
    private InputStream shellErr;
    private ExitCallback callback;
    private boolean shutdownExecutor;

    public InvertedShellWrapper(InvertedShell shell) {
        this(shell, CoreModuleProperties.BUFFER_SIZE.getRequiredDefault());
    }

    public InvertedShellWrapper(InvertedShell shell, int bufferSize) {
        this(shell, null, true, bufferSize);
    }

    public InvertedShellWrapper(InvertedShell shell, Executor executor, boolean shutdownExecutor, int bufferSize) {
        this.shell = Objects.requireNonNull(shell, "No shell");
        this.executor = executor == null ? ThreadUtils.newSingleThreadExecutor("shell[0x" + Integer.toHexString(shell.hashCode()) + "]") : executor;
        ValidateUtils.checkTrue(bufferSize > 8, "Copy buffer size too small: %d", bufferSize);
        this.bufferSize = bufferSize;
        this.pumpSleepTime = CoreModuleProperties.PUMP_SLEEP_TIME.getRequiredDefault();
        this.shutdownExecutor = executor == null || shutdownExecutor;
    }

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    @Override
    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    @Override
    public void setSession(ServerSession session) {
        this.bufferSize = CoreModuleProperties.BUFFER_SIZE.getRequired(session);
        this.pumpSleepTime = CoreModuleProperties.PUMP_SLEEP_TIME.getRequired(session);
        ValidateUtils.checkTrue(GenericUtils.isPositive(this.pumpSleepTime), "Invalid " + CoreModuleProperties.PUMP_SLEEP_TIME + ": %d", (Object)this.pumpSleepTime);
        this.shell.setSession(session);
    }

    @Override
    public synchronized void start(ChannelSession channel, Environment env) throws IOException {
        this.shell.start(channel, env);
        this.shellIn = this.shell.getInputStream();
        this.shellOut = this.shell.getOutputStream();
        this.shellErr = this.shell.getErrorStream();
        this.executor.execute(this::pumpStreams);
    }

    @Override
    public synchronized void destroy(ChannelSession channel) throws Exception {
        Throwable err = null;
        try {
            this.shell.destroy(channel);
        }
        catch (Throwable e) {
            this.warn("destroy({}) failed ({}) to destroy shell: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
            err = ExceptionUtils.accumulateException(err, e);
        }
        if (this.shutdownExecutor && this.executor instanceof ExecutorService) {
            try {
                ((ExecutorService)this.executor).shutdown();
            }
            catch (Exception e) {
                this.warn("destroy({}) failed ({}) to shut down executor: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
                err = ExceptionUtils.accumulateException(err, e);
            }
        }
        if (err != null) {
            if (err instanceof Exception) {
                throw (Exception)err;
            }
            throw new RuntimeSshException(err);
        }
    }

    protected void pumpStreams() {
        try {
            byte[] buffer = new byte[this.bufferSize];
            while (true) {
                if (this.pumpStream(this.in, this.shellIn, buffer) || this.pumpStream(this.shellOut, this.out, buffer) || this.pumpStream(this.shellErr, this.err, buffer)) {
                    continue;
                }
                if (!this.shell.isAlive() && this.in.available() <= 0 && this.shellOut.available() <= 0 && this.shellErr.available() <= 0) {
                    this.callback.onExit(this.shell.exitValue());
                    return;
                }
                Thread.sleep(this.pumpSleepTime.toMillis());
            }
        }
        catch (Throwable e) {
            boolean debugEnabled = this.log.isDebugEnabled();
            try {
                this.shell.destroy(this.shell.getServerChannelSession());
            }
            catch (Throwable err) {
                this.warn("pumpStreams({}) failed ({}) to destroy shell: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
            }
            int exitValue = this.shell.exitValue();
            if (debugEnabled) {
                this.log.debug(e.getClass().getSimpleName() + " while pumping the streams (exit=" + exitValue + "): " + e.getMessage(), e);
            }
            this.callback.onExit(exitValue, e.getClass().getSimpleName());
            return;
        }
    }

    protected boolean pumpStream(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int available = in.available();
        if (available > 0) {
            int len = in.read(buffer);
            if (len > 0) {
                out.write(buffer, 0, len);
                out.flush();
                return true;
            }
        } else if (available == -1) {
            out.close();
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.shell;
    }
}

