/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.utf8properties;

import aQute.lib.io.IO;
import aQute.lib.io.NonClosingInputStream;
import aQute.lib.io.NonClosingReader;
import aQute.lib.utf8properties.PropertiesParser;
import aQute.service.reporter.Reporter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UTF8Properties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final List<ThreadLocal<CharsetDecoder>> decoders;
    private static final Pattern HERE_PATTERN;

    public UTF8Properties(Properties p) {
        super(p);
    }

    public UTF8Properties(File file, String[] syntaxHeaders) throws Exception {
        this(file, null, syntaxHeaders);
    }

    public UTF8Properties(File file) throws Exception {
        this(file, null, null);
    }

    public UTF8Properties(File file, Reporter reporter, String[] syntaxHeaders) throws Exception {
        this.load(file, reporter, UTF8Properties.fromArray(syntaxHeaders));
    }

    public UTF8Properties(File file, Reporter reporter) throws Exception {
        this.load(file, reporter, (Collection<String>)null);
    }

    public UTF8Properties() {
    }

    private static Collection<String> fromArray(String[] array) {
        return array != null ? Arrays.asList(array) : null;
    }

    public void load(InputStream in, File file, Reporter reporter, String[] syntaxHeaders) throws IOException {
        this.load(in, file, reporter, UTF8Properties.fromArray(syntaxHeaders));
    }

    public void load(InputStream in, File file, Reporter reporter, Collection<String> syntaxHeaders) throws IOException {
        String source = this.decode(IO.read(in));
        this.load(source, file, reporter, syntaxHeaders);
    }

    public void load(InputStream in, File file, Reporter reporter) throws IOException {
        this.load(in, file, reporter, (Collection<String>)null);
    }

    public void load(String source, File file, Reporter reporter) throws IOException {
        this.load(source, file, reporter, (Collection<String>)null);
    }

    public void load(String source, File file, Reporter reporter, String[] syntaxHeaders) throws IOException {
        this.load(source, file, reporter, UTF8Properties.fromArray(syntaxHeaders));
    }

    public void load(String source, File file, Reporter reporter, Collection<String> syntaxHeaders) throws IOException {
        PropertiesParser parser = new PropertiesParser(source, file == null ? null : file.getAbsolutePath(), reporter, this, syntaxHeaders);
        parser.parse();
    }

    public void load(File file, Reporter reporter, String[] syntaxHeaders) throws Exception {
        this.load(file, reporter, UTF8Properties.fromArray(syntaxHeaders));
    }

    public void load(File file, Reporter reporter, Collection<String> syntaxHeaders) throws Exception {
        String source = this.decode(IO.read(file));
        this.load(source, file, reporter, syntaxHeaders);
    }

    public void load(File file, Reporter reporter) throws Exception {
        this.load(file, reporter, (Collection<String>)null);
    }

    @Override
    public synchronized void load(InputStream in) throws IOException {
        this.load((InputStream)new NonClosingInputStream(in), null, null, (Collection<String>)null);
    }

    @Override
    public synchronized void load(Reader r) throws IOException {
        String source = IO.collect(new NonClosingReader(r));
        this.load(source, null, null, (Collection<String>)null);
    }

    private String decode(byte[] buffer) {
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        CharBuffer cb = CharBuffer.allocate(buffer.length * 4);
        for (ThreadLocal<CharsetDecoder> tl : decoders) {
            boolean success;
            CharsetDecoder decoder = tl.get();
            boolean bl = success = !decoder.decode(bb, cb, true).isError();
            if (success) {
                decoder.flush(cb);
            }
            decoder.reset();
            if (success) {
                return cb.flip().toString();
            }
            bb.rewind();
            cb.clear();
        }
        return new String(buffer);
    }

    @Override
    public void store(OutputStream out, String msg) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        super.store(sw, null);
        String[] lines = sw.toString().split("\n\r?");
        byte[] newline = "\n".getBytes(StandardCharsets.UTF_8);
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            out.write(line.getBytes(StandardCharsets.UTF_8));
            out.write(newline);
        }
    }

    @Override
    public void store(Writer out, String msg) throws IOException {
        String[] lines;
        CharArrayWriter sw = new CharArrayWriter();
        super.store(sw, null);
        for (String line : lines = sw.toString().split("\n\r?")) {
            if (line.startsWith("#")) continue;
            out.write(line);
            out.write(10);
        }
    }

    public void store(File out) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        super.store(sw, null);
        IO.store((Object)sw.toString(), out);
    }

    public void store(OutputStream out) throws IOException {
        this.store(out, null);
    }

    public UTF8Properties replaceAll(String pattern, String replacement) {
        return this.replaceAll(Pattern.compile(pattern), replacement);
    }

    private UTF8Properties replaceAll(Pattern regex, String replacement) {
        UTF8Properties result = new UTF8Properties(this.defaults);
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            value = regex.matcher(value).replaceAll(replacement);
            result.put(key, value);
        }
        return result;
    }

    public UTF8Properties replaceHere(File file) {
        String here;
        String string = here = file == null ? "." : IO.absolutePath(file);
        if (here.endsWith("/")) {
            here = here + ".";
        }
        return this.replaceAll(HERE_PATTERN, Matcher.quoteReplacement(here));
    }

    static {
        ThreadLocal[] threadLocalArray = new ThreadLocal[2];
        threadLocalArray[0] = ThreadLocal.withInitial(StandardCharsets.UTF_8::newDecoder);
        threadLocalArray[1] = ThreadLocal.withInitial(StandardCharsets.ISO_8859_1::newDecoder);
        decoders = Collections.unmodifiableList(Arrays.asList(threadLocalArray));
        HERE_PATTERN = Pattern.compile("${.}", 16);
    }
}

