/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHBaseSnapshot;
import com.cloudera.api.swagger.model.ApiHBaseSnapshotError;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Detailed information about an HBase snapshot command.")
public class ApiHBaseSnapshotResult {
    @SerializedName(value="processedTableCount")
    private BigDecimal processedTableCount = null;
    @SerializedName(value="processedTables")
    private List<String> processedTables = null;
    @SerializedName(value="unprocessedTableCount")
    private BigDecimal unprocessedTableCount = null;
    @SerializedName(value="unprocessedTables")
    private List<String> unprocessedTables = null;
    @SerializedName(value="createdSnapshotCount")
    private BigDecimal createdSnapshotCount = null;
    @SerializedName(value="createdSnapshots")
    private List<ApiHBaseSnapshot> createdSnapshots = null;
    @SerializedName(value="deletedSnapshotCount")
    private BigDecimal deletedSnapshotCount = null;
    @SerializedName(value="deletedSnapshots")
    private List<ApiHBaseSnapshot> deletedSnapshots = null;
    @SerializedName(value="creationErrorCount")
    private BigDecimal creationErrorCount = null;
    @SerializedName(value="creationErrors")
    private List<ApiHBaseSnapshotError> creationErrors = null;
    @SerializedName(value="deletionErrorCount")
    private BigDecimal deletionErrorCount = null;
    @SerializedName(value="deletionErrors")
    private List<ApiHBaseSnapshotError> deletionErrors = null;

    public ApiHBaseSnapshotResult processedTableCount(BigDecimal processedTableCount) {
        this.processedTableCount = processedTableCount;
        return this;
    }

    @Schema(description="Number of processed tables.")
    public BigDecimal getProcessedTableCount() {
        return this.processedTableCount;
    }

    public void setProcessedTableCount(BigDecimal processedTableCount) {
        this.processedTableCount = processedTableCount;
    }

    public ApiHBaseSnapshotResult processedTables(List<String> processedTables) {
        this.processedTables = processedTables;
        return this;
    }

    public ApiHBaseSnapshotResult addProcessedTablesItem(String processedTablesItem) {
        if (this.processedTables == null) {
            this.processedTables = new ArrayList<String>();
        }
        this.processedTables.add(processedTablesItem);
        return this;
    }

    @Schema(description="The list of processed tables. <p/> This is only available in the full view.")
    public List<String> getProcessedTables() {
        return this.processedTables;
    }

    public void setProcessedTables(List<String> processedTables) {
        this.processedTables = processedTables;
    }

    public ApiHBaseSnapshotResult unprocessedTableCount(BigDecimal unprocessedTableCount) {
        this.unprocessedTableCount = unprocessedTableCount;
        return this;
    }

    @Schema(description="Number of unprocessed tables.")
    public BigDecimal getUnprocessedTableCount() {
        return this.unprocessedTableCount;
    }

    public void setUnprocessedTableCount(BigDecimal unprocessedTableCount) {
        this.unprocessedTableCount = unprocessedTableCount;
    }

    public ApiHBaseSnapshotResult unprocessedTables(List<String> unprocessedTables) {
        this.unprocessedTables = unprocessedTables;
        return this;
    }

    public ApiHBaseSnapshotResult addUnprocessedTablesItem(String unprocessedTablesItem) {
        if (this.unprocessedTables == null) {
            this.unprocessedTables = new ArrayList<String>();
        }
        this.unprocessedTables.add(unprocessedTablesItem);
        return this;
    }

    @Schema(description="The list of unprocessed tables. Note that tables that are currently being processed will also be included in this list. <p/> This is only available in the full view.")
    public List<String> getUnprocessedTables() {
        return this.unprocessedTables;
    }

    public void setUnprocessedTables(List<String> unprocessedTables) {
        this.unprocessedTables = unprocessedTables;
    }

    public ApiHBaseSnapshotResult createdSnapshotCount(BigDecimal createdSnapshotCount) {
        this.createdSnapshotCount = createdSnapshotCount;
        return this;
    }

    @Schema(description="Number of snapshots created.")
    public BigDecimal getCreatedSnapshotCount() {
        return this.createdSnapshotCount;
    }

    public void setCreatedSnapshotCount(BigDecimal createdSnapshotCount) {
        this.createdSnapshotCount = createdSnapshotCount;
    }

    public ApiHBaseSnapshotResult createdSnapshots(List<ApiHBaseSnapshot> createdSnapshots) {
        this.createdSnapshots = createdSnapshots;
        return this;
    }

    public ApiHBaseSnapshotResult addCreatedSnapshotsItem(ApiHBaseSnapshot createdSnapshotsItem) {
        if (this.createdSnapshots == null) {
            this.createdSnapshots = new ArrayList<ApiHBaseSnapshot>();
        }
        this.createdSnapshots.add(createdSnapshotsItem);
        return this;
    }

    @Schema(description="List of snapshots created. <p/> This is only available in the full view.")
    public List<ApiHBaseSnapshot> getCreatedSnapshots() {
        return this.createdSnapshots;
    }

    public void setCreatedSnapshots(List<ApiHBaseSnapshot> createdSnapshots) {
        this.createdSnapshots = createdSnapshots;
    }

    public ApiHBaseSnapshotResult deletedSnapshotCount(BigDecimal deletedSnapshotCount) {
        this.deletedSnapshotCount = deletedSnapshotCount;
        return this;
    }

    @Schema(description="Number of snapshots deleted.")
    public BigDecimal getDeletedSnapshotCount() {
        return this.deletedSnapshotCount;
    }

    public void setDeletedSnapshotCount(BigDecimal deletedSnapshotCount) {
        this.deletedSnapshotCount = deletedSnapshotCount;
    }

    public ApiHBaseSnapshotResult deletedSnapshots(List<ApiHBaseSnapshot> deletedSnapshots) {
        this.deletedSnapshots = deletedSnapshots;
        return this;
    }

    public ApiHBaseSnapshotResult addDeletedSnapshotsItem(ApiHBaseSnapshot deletedSnapshotsItem) {
        if (this.deletedSnapshots == null) {
            this.deletedSnapshots = new ArrayList<ApiHBaseSnapshot>();
        }
        this.deletedSnapshots.add(deletedSnapshotsItem);
        return this;
    }

    @Schema(description="List of snapshots deleted. <p/> This is only available in the full view.")
    public List<ApiHBaseSnapshot> getDeletedSnapshots() {
        return this.deletedSnapshots;
    }

    public void setDeletedSnapshots(List<ApiHBaseSnapshot> deletedSnapshots) {
        this.deletedSnapshots = deletedSnapshots;
    }

    public ApiHBaseSnapshotResult creationErrorCount(BigDecimal creationErrorCount) {
        this.creationErrorCount = creationErrorCount;
        return this;
    }

    @Schema(description="Number of errors detected when creating snapshots.")
    public BigDecimal getCreationErrorCount() {
        return this.creationErrorCount;
    }

    public void setCreationErrorCount(BigDecimal creationErrorCount) {
        this.creationErrorCount = creationErrorCount;
    }

    public ApiHBaseSnapshotResult creationErrors(List<ApiHBaseSnapshotError> creationErrors) {
        this.creationErrors = creationErrors;
        return this;
    }

    public ApiHBaseSnapshotResult addCreationErrorsItem(ApiHBaseSnapshotError creationErrorsItem) {
        if (this.creationErrors == null) {
            this.creationErrors = new ArrayList<ApiHBaseSnapshotError>();
        }
        this.creationErrors.add(creationErrorsItem);
        return this;
    }

    @Schema(description="List of errors encountered when creating snapshots. <p/> This is only available in the full view.")
    public List<ApiHBaseSnapshotError> getCreationErrors() {
        return this.creationErrors;
    }

    public void setCreationErrors(List<ApiHBaseSnapshotError> creationErrors) {
        this.creationErrors = creationErrors;
    }

    public ApiHBaseSnapshotResult deletionErrorCount(BigDecimal deletionErrorCount) {
        this.deletionErrorCount = deletionErrorCount;
        return this;
    }

    @Schema(description="Number of errors detected when deleting snapshots.")
    public BigDecimal getDeletionErrorCount() {
        return this.deletionErrorCount;
    }

    public void setDeletionErrorCount(BigDecimal deletionErrorCount) {
        this.deletionErrorCount = deletionErrorCount;
    }

    public ApiHBaseSnapshotResult deletionErrors(List<ApiHBaseSnapshotError> deletionErrors) {
        this.deletionErrors = deletionErrors;
        return this;
    }

    public ApiHBaseSnapshotResult addDeletionErrorsItem(ApiHBaseSnapshotError deletionErrorsItem) {
        if (this.deletionErrors == null) {
            this.deletionErrors = new ArrayList<ApiHBaseSnapshotError>();
        }
        this.deletionErrors.add(deletionErrorsItem);
        return this;
    }

    @Schema(description="List of errors encountered when deleting snapshots. <p/> This is only available in the full view.")
    public List<ApiHBaseSnapshotError> getDeletionErrors() {
        return this.deletionErrors;
    }

    public void setDeletionErrors(List<ApiHBaseSnapshotError> deletionErrors) {
        this.deletionErrors = deletionErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHBaseSnapshotResult apiHBaseSnapshotResult = (ApiHBaseSnapshotResult)o;
        return Objects.equals(this.processedTableCount, apiHBaseSnapshotResult.processedTableCount) && Objects.equals(this.processedTables, apiHBaseSnapshotResult.processedTables) && Objects.equals(this.unprocessedTableCount, apiHBaseSnapshotResult.unprocessedTableCount) && Objects.equals(this.unprocessedTables, apiHBaseSnapshotResult.unprocessedTables) && Objects.equals(this.createdSnapshotCount, apiHBaseSnapshotResult.createdSnapshotCount) && Objects.equals(this.createdSnapshots, apiHBaseSnapshotResult.createdSnapshots) && Objects.equals(this.deletedSnapshotCount, apiHBaseSnapshotResult.deletedSnapshotCount) && Objects.equals(this.deletedSnapshots, apiHBaseSnapshotResult.deletedSnapshots) && Objects.equals(this.creationErrorCount, apiHBaseSnapshotResult.creationErrorCount) && Objects.equals(this.creationErrors, apiHBaseSnapshotResult.creationErrors) && Objects.equals(this.deletionErrorCount, apiHBaseSnapshotResult.deletionErrorCount) && Objects.equals(this.deletionErrors, apiHBaseSnapshotResult.deletionErrors);
    }

    public int hashCode() {
        return Objects.hash(this.processedTableCount, this.processedTables, this.unprocessedTableCount, this.unprocessedTables, this.createdSnapshotCount, this.createdSnapshots, this.deletedSnapshotCount, this.deletedSnapshots, this.creationErrorCount, this.creationErrors, this.deletionErrorCount, this.deletionErrors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHBaseSnapshotResult {\n");
        sb.append("    processedTableCount: ").append(this.toIndentedString(this.processedTableCount)).append("\n");
        sb.append("    processedTables: ").append(this.toIndentedString(this.processedTables)).append("\n");
        sb.append("    unprocessedTableCount: ").append(this.toIndentedString(this.unprocessedTableCount)).append("\n");
        sb.append("    unprocessedTables: ").append(this.toIndentedString(this.unprocessedTables)).append("\n");
        sb.append("    createdSnapshotCount: ").append(this.toIndentedString(this.createdSnapshotCount)).append("\n");
        sb.append("    createdSnapshots: ").append(this.toIndentedString(this.createdSnapshots)).append("\n");
        sb.append("    deletedSnapshotCount: ").append(this.toIndentedString(this.deletedSnapshotCount)).append("\n");
        sb.append("    deletedSnapshots: ").append(this.toIndentedString(this.deletedSnapshots)).append("\n");
        sb.append("    creationErrorCount: ").append(this.toIndentedString(this.creationErrorCount)).append("\n");
        sb.append("    creationErrors: ").append(this.toIndentedString(this.creationErrors)).append("\n");
        sb.append("    deletionErrorCount: ").append(this.toIndentedString(this.deletionErrorCount)).append("\n");
        sb.append("    deletionErrors: ").append(this.toIndentedString(this.deletionErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

