/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.knoxtoken;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.token.TokenUtils;

@Singleton
@Path(value="knoxtoken/api/v1")
public class JWKSResource {
    public static final String JWKS_PATH = "/jwks.json";
    static final String RESOURCE_PATH = "knoxtoken/api/v1";
    private static final String TOKEN_SIG_ALG = "knox.token.sigalg";
    @Context
    HttpServletRequest request;
    @Context
    ServletContext context;
    private KeystoreService keystoreService;
    private String signatureAlgorithm;

    @PostConstruct
    public void init() throws AliasServiceException {
        GatewayServices services = (GatewayServices)this.context.getAttribute("org.apache.knox.gateway.gateway.services");
        this.keystoreService = (KeystoreService)services.getService(ServiceType.KEYSTORE_SERVICE);
        String configuredSigAlg = this.context.getInitParameter(TOKEN_SIG_ALG);
        GatewayConfig config = (GatewayConfig)this.context.getAttribute("org.apache.knox.gateway.config");
        this.signatureAlgorithm = TokenUtils.getSignatureAlgorithm((String)configuredSigAlg, (AliasService)((AliasService)services.getService(ServiceType.ALIAS_SERVICE)), (String)config.getSigningKeystoreName());
    }

    @GET
    @Path(value="/jwks.json")
    @Produces(value={"application/json"})
    public Response getJwksResponse() {
        return this.getJwks(null);
    }

    private Response getJwks(String keystore) {
        JWKSet jwks;
        try {
            RSAPublicKey rsa = this.getPublicKey(keystore);
            if (rsa == null) {
                return Response.ok().entity((Object)new JWKSet().toJSONObject().toString()).build();
            }
            String kid = TokenUtils.getThumbprint((RSAPublicKey)rsa, (String)"SHA-256");
            RSAKey.Builder builder = new RSAKey.Builder(rsa).keyUse(KeyUse.SIGNATURE).algorithm((Algorithm)new JWSAlgorithm(this.signatureAlgorithm)).keyID(kid);
            jwks = new JWKSet((JWK)builder.build());
        }
        catch (JOSEException | KeyStoreException e) {
            return Response.status((int)500).entity((Object)("{\n  \"error\": \"" + e.toString() + "\"\n}\n")).build();
        }
        catch (KeystoreServiceException e) {
            return Response.status((int)500).entity((Object)("{\n  \"error\": \"keystore " + keystore + " could not be found.\"\n}\n")).build();
        }
        return Response.ok().entity((Object)jwks.toString()).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected RSAPublicKey getPublicKey(String keystore) throws KeystoreServiceException, KeyStoreException {
        KeyStore ks = this.keystoreService.getSigningKeystore(keystore);
        Certificate cert = ks.getCertificate(this.getSigningKeyAlias());
        return cert != null ? (RSAPublicKey)cert.getPublicKey() : null;
    }

    private String getSigningKeyAlias() {
        GatewayConfig config = (GatewayConfig)this.context.getAttribute("org.apache.knox.gateway.config");
        String alias = config.getSigningKeyAlias();
        return alias == null ? "gateway-identity" : alias;
    }
}

