/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.ServerSocket;
import java.util.Base64;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.security.sasl.AuthenticationException;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.cli.Handle$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.KyuubiTHttpFrontendService$;
import org.apache.kyuubi.server.http.ThriftHttpServlet;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter$;
import org.apache.kyuubi.service.Serverable;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.service.ServiceUtils$;
import org.apache.kyuubi.service.TFrontendService;
import org.apache.kyuubi.service.TFrontendService$;
import org.apache.kyuubi.session.KyuubiSessionImpl;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TCLIService;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.THandleIdentifier;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TOpenSessionReq;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TOpenSessionResp;
import org.apache.kyuubi.shaded.thrift.TProcessor;
import org.apache.kyuubi.shaded.thrift.protocol.TBinaryProtocol;
import org.apache.kyuubi.shaded.thrift.protocol.TProtocolFactory;
import org.apache.kyuubi.util.NamedThreadFactory;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.MapLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001\u0002\u000f\u001e\u0005\u0019B\u0001\"\f\u0001\u0003\u0006\u0004%\tE\f\u0005\te\u0001\u0011\t\u0011)A\u0005_!)1\u0007\u0001C\u0001i!A\u0001\b\u0001EC\u0002\u0013E\u0013\b\u0003\u0005L\u0001!\u0015\r\u0011\"\u0015M\u0011!\u0001\u0006\u0001#b\u0001\n#b\u0005\u0002C)\u0001\u0011\u000b\u0007I\u0011\u000b*\t\u000fy\u0001\u0001\u0019!C\u00057\"9a\r\u0001a\u0001\n\u00139\u0007BB7\u0001A\u0003&A\fC\u0004o\u0001\t\u0007I\u0011B8\t\rU\u0004\u0001\u0015!\u0003q\u0011\u00151\b\u0001\"\u0015x\u0011%\t\t\u0001\u0001EC\u0002\u0013%A\nC\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018!9\u0011Q\b\u0001\u0005B\u0005}\u0002bBA!\u0001\u0011E\u0013q\b\u0005\b\u0003\u0007\u0002A\u0011KA#\u0011%\ti\u0005\u0001b\u0001\n\u0003\ny\u0005\u0003\u0005\u0002Z\u0001\u0001\u000b\u0011BA)\u0011\u001d\tY\u0006\u0001C\u0005\u0003;Bq!a\u0019\u0001\t\u0003\t)\u0007C\u0004\u0002x\u0001!\t&!\u001f\t\u000f\u0005m\u0004\u0001\"\u0015\u0002~!9\u0011q\u0013\u0001\u0005R\u0005e\u0005bBAR\u0001\u0011%\u0011Q\u0015\u0002\u001b\u0017f,XOY5U\u0011R$\bO\u0012:p]R,g\u000eZ*feZL7-\u001a\u0006\u0003=}\taa]3sm\u0016\u0014(B\u0001\u0011\"\u0003\u0019Y\u00170^;cS*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0014\u0011\u0005!ZS\"A\u0015\u000b\u0005)z\u0012aB:feZL7-Z\u0005\u0003Y%\u0012\u0001\u0003\u0016$s_:$XM\u001c3TKJ4\u0018nY3\u0002\u0015M,'O^3sC\ndW-F\u00010!\tA\u0003'\u0003\u00022S\tQ1+\u001a:wKJ\f'\r\\3\u0002\u0017M,'O^3sC\ndW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005U:\u0004C\u0001\u001c\u0001\u001b\u0005i\u0002\"B\u0017\u0004\u0001\u0004y\u0013AC:feZ,'\u000fS8tiV\t!\bE\u0002<}\u0001k\u0011\u0001\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\b\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0005CeB\u0001\"G!\t\u0019E(D\u0001E\u0015\t)U%\u0001\u0004=e>|GOP\u0005\u0003\u000fr\na\u0001\u0015:fI\u00164\u0017BA%K\u0005\u0019\u0019FO]5oO*\u0011q\tP\u0001\ba>\u0014HOT;n+\u0005i\u0005CA\u001eO\u0013\tyEHA\u0002J]R\f!\"Y2uk\u0006d\u0007k\u001c:u\u00031\u0019XM\u001d<feN{7m[3u+\u0005\u0019\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\rqW\r\u001e\u0006\u00021\u0006!!.\u0019<b\u0013\tQVK\u0001\u0007TKJ4XM]*pG.,G/F\u0001]!\rYd(\u0018\t\u0003=\u0012l\u0011a\u0018\u0006\u0003=\u0001T!!\u00192\u0002\u000b),G\u000f^=\u000b\u0005\r\u001c\u0013aB3dY&\u00048/Z\u0005\u0003K~\u0013aaU3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR\u0011\u0001n\u001b\t\u0003w%L!A\u001b\u001f\u0003\tUs\u0017\u000e\u001e\u0005\bY&\t\t\u00111\u0001]\u0003\rAH%M\u0001\bg\u0016\u0014h/\u001a:!\u0003I\t\u0005\u000b\u0015'J\u0007\u0006#\u0016j\u0014(`)\"\u0013\u0016J\u0012+\u0016\u0003A\u0004\"!\u001d;\u000e\u0003IT!a],\u0002\t1\fgnZ\u0005\u0003\u0013J\f1#\u0011)Q\u0019&\u001b\u0015\tV%P\u001d~#\u0006JU%G)\u0002\n!\u0002[1e_>\u00048i\u001c8g+\u0005A\bCA=\u007f\u001b\u0005Q(BA>}\u0003\u0011\u0019wN\u001c4\u000b\u0005u\f\u0013A\u00025bI>|\u0007/\u0003\u0002\u0000u\ni1i\u001c8gS\u001e,(/\u0019;j_:\f\u0001\u0003Z3gCVdGOR3uG\"\u001c\u0016N_3\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0002i\u0003\u000fAaa_\bA\u0002\u0005%\u0001\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=q$\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003'\tiA\u0001\u0006LsV,(-[\"p]\u001a\f1b\u00149f]N+7o]5p]R!\u0011\u0011DA\u001a!\u0011\tY\"a\f\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\ta\u0001\u001e5sS\u001a$(\u0002BA\u0012\u0003K\t1A\u001d9d\u0015\rQ\u0013q\u0005\u0006\u0005\u0003S\tY#\u0001\u0003iSZ,'bAA\u0017?\u000511\u000f[1eK\u0012LA!!\r\u0002\u001e\t\u0001Bk\u00149f]N+7o]5p]J+7\u000f\u001d\u0005\b\u0003k\u0001\u0002\u0019AA\u001c\u0003\r\u0011X-\u001d\t\u0005\u00037\tI$\u0003\u0003\u0002<\u0005u!a\u0004+Pa\u0016t7+Z:tS>t'+Z9\u0002\u0007I,h\u000eF\u0001i\u0003)\u0019Ho\u001c9TKJ4XM]\u0001\tSN\u001cVM\u001d<feR\u0011\u0011q\t\t\u0004w\u0005%\u0013bAA&y\t9!i\\8mK\u0006t\u0017\u0001\u00053jg\u000e|g/\u001a:z'\u0016\u0014h/[2f+\t\t\t\u0006\u0005\u0003<}\u0005M\u0003c\u0001\u0015\u0002V%\u0019\u0011qK\u0015\u0003\u000fM+'O^5dK\u0006\tB-[:d_Z,'/_*feZL7-\u001a\u0011\u0002\u0017\u001d,G\u000f\u0013;uaB\u000bG\u000f\u001b\u000b\u0004\u0001\u0006}\u0003BBA1-\u0001\u0007\u0001)\u0001\u0005iiR\u0004\b+\u0019;i\u0003Q\u0019wN\\:ue\u0006Lg\u000e\u0013;ua6+G\u000f[8egR\u0019\u0001.a\u001a\t\u000f\u0005%t\u00031\u0001\u0002l\u0005Q1\r\u001e=IC:$G.\u001a:\u0011\t\u00055\u00141O\u0007\u0003\u0003_R1!!\u001da\u0003\u001d\u0019XM\u001d<mKRLA!!\u001e\u0002p\t)2+\u001a:wY\u0016$8i\u001c8uKb$\b*\u00198eY\u0016\u0014\u0018\u0001D4fi&\u0003\u0018\t\u001a3sKN\u001cX#\u0001!\u0002\u0019\u001d,G\u000f\u0015:pqf,6/\u001a:\u0015\u000f\u0001\u000by(a$\u0002\u0014\"9\u0011\u0011Q\rA\u0002\u0005\r\u0015aC:fgNLwN\\\"p]\u001a\u0004b!!\"\u0002\f\u0002\u0003UBAAD\u0015\r\tIiV\u0001\u0005kRLG.\u0003\u0003\u0002\u000e\u0006\u001d%aA'ba\"1\u0011\u0011S\rA\u0002\u0001\u000b\u0011\"\u001b9BI\u0012\u0014Xm]:\t\r\u0005U\u0015\u00041\u0001A\u0003!\u0011X-\u00197Vg\u0016\u0014\u0018!G4fiJ+\u0017\r\\+tKJ\fe\u000eZ*fgNLwN\\+tKJ$B!a'\u0002\"B)1(!(A\u0001&\u0019\u0011q\u0014\u001f\u0003\rQ+\b\u000f\\33\u0011\u001d\t)D\u0007a\u0001\u0003o\tAbZ3u'\"|'\u000f\u001e(b[\u0016$2\u0001QAT\u0011\u0019\tIk\u0007a\u0001\u0001\u0006AQo]3s\u001d\u0006lW\r")
public final class KyuubiTHttpFrontendService
extends TFrontendService {
    private Option<String> serverHost;
    private int portNum;
    private int actualPort;
    private ServerSocket serverSocket;
    private int defaultFetchSize;
    private final Serverable serverable;
    private Option<Server> server;
    private final String APPLICATION_THRIFT;
    private final Option<Service> discoveryService;
    private volatile byte bitmap$0;

    public Serverable serverable() {
        return this.serverable;
    }

    private Option<String> serverHost$lzycompute() {
        KyuubiTHttpFrontendService kyuubiTHttpFrontendService = this;
        synchronized (kyuubiTHttpFrontendService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serverHost = (Option)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_BIND_HOST());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serverHost;
    }

    public Option<String> serverHost() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.serverHost$lzycompute();
        }
        return this.serverHost;
    }

    private int portNum$lzycompute() {
        KyuubiTHttpFrontendService kyuubiTHttpFrontendService = this;
        synchronized (kyuubiTHttpFrontendService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.portNum = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_BIND_PORT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.portNum;
    }

    public int portNum() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.portNum$lzycompute();
        }
        return this.portNum;
    }

    private int actualPort$lzycompute() {
        KyuubiTHttpFrontendService kyuubiTHttpFrontendService = this;
        synchronized (kyuubiTHttpFrontendService) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.actualPort = this.portNum();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.actualPort;
    }

    public int actualPort() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.actualPort$lzycompute();
        }
        return this.actualPort;
    }

    private ServerSocket serverSocket$lzycompute() {
        KyuubiTHttpFrontendService kyuubiTHttpFrontendService = this;
        synchronized (kyuubiTHttpFrontendService) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.serverSocket = null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.serverSocket;
    }

    public ServerSocket serverSocket() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.serverSocket$lzycompute();
        }
        return this.serverSocket;
    }

    private Option<Server> server() {
        return this.server;
    }

    private void server_$eq(Option<Server> x$1) {
        this.server = x$1;
    }

    private String APPLICATION_THRIFT() {
        return this.APPLICATION_THRIFT;
    }

    public Configuration hadoopConf() {
        return KyuubiServer$.MODULE$.getHadoopConf();
    }

    private int defaultFetchSize$lzycompute() {
        KyuubiTHttpFrontendService kyuubiTHttpFrontendService = this;
        synchronized (kyuubiTHttpFrontendService) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.defaultFetchSize = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.KYUUBI_SERVER_THRIFT_RESULTSET_DEFAULT_FETCH_SIZE()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.defaultFetchSize;
    }

    private int defaultFetchSize() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.defaultFetchSize$lzycompute();
        }
        return this.defaultFetchSize;
    }

    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        if (this.authFactory().kerberosEnabled() && this.authFactory().effectivePlainAuthType().isEmpty()) {
            throw new AuthenticationException("Kerberos is not supported for Thrift HTTP mode");
        }
        try {
            ServerConnector serverConnector;
            String schemeName;
            int minThreads = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_MIN_WORKER_THREADS()));
            int maxThreads = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_MAX_WORKER_THREADS()));
            long keepAliveTime = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_WORKER_KEEPALIVE_TIME()));
            ThreadPoolExecutor executor = new ThreadPoolExecutor(minThreads, maxThreads, keepAliveTime, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory(new StringBuilder(16).append(this.getName()).append("HttpHandler-Pool").toString(), false));
            ExecutorThreadPool threadPool = new ExecutorThreadPool(executor);
            this.server_$eq((Option<Server>)new Some((Object)new Server((ThreadPool)threadPool)));
            HttpConfiguration httpConf = new HttpConfiguration();
            int requestHeaderSize = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_REQUEST_HEADER_SIZE()));
            int responseHeaderSize = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_RESPONSE_HEADER_SIZE()));
            boolean jettySendVersionEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_JETTY_SEND_VERSION_ENABLED()));
            httpConf.setRequestHeaderSize(requestHeaderSize);
            httpConf.setResponseHeaderSize(responseHeaderSize);
            httpConf.setSendServerVersion(jettySendVersionEnabled);
            HttpConnectionFactory connectionFactory = new HttpConnectionFactory(httpConf);
            boolean useSsl = BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_USE_SSL()));
            String string = schemeName = useSsl ? "https" : "http";
            if (useSsl) {
                Option keyStorePath = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PATH());
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(61).append(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PATH().key()).append(" Not configured for SSL connection, please set the key with: ").append(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PATH().doc()).toString());
                }
                Option keyStorePassword = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PASSWORD());
                if (keyStorePassword.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(61).append(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PASSWORD().key()).append(" Not configured for SSL connection. please set the key with: ").append(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PASSWORD().doc()).toString());
                }
                SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                Seq excludedProtocols = (Seq)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_PROTOCOL_BLACKLIST());
                Seq excludeCipherSuites = (Seq)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_EXCLUDE_CIPHER_SUITES());
                Option keyStoreType = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_TYPE());
                Option keyStoreAlgorithm = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_ALGORITHM());
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Thrift HTTP Server SSL: adding excluded protocols: ").append(String.join((CharSequence)",", (CharSequence[])excludedProtocols.toArray(ClassTag$.MODULE$.apply(String.class)))).toString());
                sslContextFactory.addExcludeProtocols((String[])excludedProtocols.toArray(ClassTag$.MODULE$.apply(String.class)));
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Thrift HTTP Server SSL: SslContextFactory.getExcludeProtocols = ").append(String.join((CharSequence)",", sslContextFactory.getExcludeProtocols())).toString());
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Thrift HTTP Server SSL: setting excluded cipher Suites: ").append(String.join((CharSequence)",", (CharSequence[])excludeCipherSuites.toArray(ClassTag$.MODULE$.apply(String.class)))).toString());
                sslContextFactory.setExcludeCipherSuites((String[])excludeCipherSuites.toArray(ClassTag$.MODULE$.apply(String.class)));
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Thrift HTTP Server SSL: SslContextFactory.getExcludeCipherSuites = ").append(String.join((CharSequence)",", sslContextFactory.getExcludeCipherSuites())).toString());
                sslContextFactory.setKeyStorePath((String)keyStorePath.get());
                sslContextFactory.setKeyStorePassword((String)keyStorePassword.get());
                keyStoreType.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    sslContextFactory.setKeyStoreType(x$1);
                    return BoxedUnit.UNIT;
                });
                keyStoreAlgorithm.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    sslContextFactory.setKeyManagerFactoryAlgorithm(x$1);
                    return BoxedUnit.UNIT;
                });
                serverConnector = new ServerConnector((Server)this.server().get(), (SslContextFactory)sslContextFactory, new ConnectionFactory[]{connectionFactory});
            } else {
                serverConnector = new ServerConnector((Server)this.server().get(), new ConnectionFactory[]{connectionFactory});
            }
            ServerConnector connector = serverConnector;
            connector.setPort(this.portNum());
            connector.setReuseAddress(!SystemUtils.IS_OS_WINDOWS);
            long maxIdleTime = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_MAX_IDLE_TIME()));
            connector.setIdleTimeout(maxIdleTime);
            connector.setAcceptQueueSize(maxThreads);
            this.server().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.addConnector((Connector)connector);
                return BoxedUnit.UNIT;
            });
            TCLIService.Processor processor = new TCLIService.Processor((TCLIService.Iface)this);
            TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
            ThriftHttpServlet servlet = new ThriftHttpServlet((TProcessor)processor, (TProtocolFactory)protocolFactory, this.authFactory(), conf);
            servlet.init();
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            context.addEventListener((EventListener)new ServletContextListener(null){

                public void contextInitialized(ServletContextEvent servletContextEvent) {
                    MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                        $anon$1.$anonfun$contextInitialized$1(ms);
                        return BoxedUnit.UNIT;
                    });
                }

                public void contextDestroyed(ServletContextEvent servletContextEvent) {
                    MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                        $anon$1.$anonfun$contextDestroyed$1(ms);
                        return BoxedUnit.UNIT;
                    });
                }

                public static final /* synthetic */ void $anonfun$contextInitialized$1(MetricsSystem ms) {
                    ms.incCount(MetricsConstants$.MODULE$.THRIFT_HTTP_CONN_TOTAL());
                    ms.incCount(MetricsConstants$.MODULE$.THRIFT_HTTP_CONN_OPEN());
                }

                public static final /* synthetic */ void $anonfun$contextDestroyed$1(MetricsSystem ms) {
                    ms.decCount(MetricsConstants$.MODULE$.THRIFT_HTTP_CONN_OPEN());
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$contextInitialized$1$adapted(org.apache.kyuubi.metrics.MetricsSystem ), $anonfun$contextDestroyed$1$adapted(org.apache.kyuubi.metrics.MetricsSystem )}, serializedLambda);
                }
            });
            String httpPath = this.getHttpPath((String)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_PATH()));
            if (BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_COMPRESSION_ENABLED()))) {
                GzipHandler gzipHandler = new GzipHandler();
                gzipHandler.setHandler((Handler)context);
                gzipHandler.addIncludedMethods(new String[]{HttpMethod.POST.asString()});
                gzipHandler.addIncludedMimeTypes(new String[]{this.APPLICATION_THRIFT()});
                this.server().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.setHandler((Handler)gzipHandler);
                    return BoxedUnit.UNIT;
                });
            } else {
                this.server().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.setHandler((Handler)context);
                    return BoxedUnit.UNIT;
                });
            }
            context.addServlet(new ServletHolder((Servlet)servlet), httpPath);
            this.constrainHttpMethods(context);
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Started ").append(this.getClass().getSimpleName()).append(" in ").append(schemeName).append(" mode on port ").append(this.portNum()).append(" ").append("path=").append(httpPath).append(" with ").append(minThreads).append(" ... ").append(maxThreads).append(" threads").toString());
        }
        catch (Throwable e) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.incCount(MetricsConstants$.MODULE$.THRIFT_HTTP_CONN_FAIL());
                return BoxedUnit.UNIT;
            });
            this.error((Function0 & Serializable & scala.Serializable)() -> e);
            throw new KyuubiException(new StringBuilder(43).append("Failed to initialize frontend service on ").append(this.serverAddr()).append(":").append(this.portNum()).append(".").toString(), e);
        }
        super.initialize(conf);
    }

    public TOpenSessionResp OpenSession(TOpenSessionReq req) {
        this.debug((Function0 & Serializable & scala.Serializable)() -> req.toString());
        this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Client protocol version: ").append(req.getClient_protocol()).toString());
        TOpenSessionResp resp = new TOpenSessionResp();
        try {
            SessionHandle sessionHandle = this.getSessionHandle(req, resp);
            HashMap<String, String> respConfiguration = new HashMap<String, String>();
            Operation launchEngineOp = ((KyuubiSessionImpl)this.be().sessionManager().getSession(sessionHandle)).launchEngineOp();
            THandleIdentifier opHandleIdentifier = Handle$.MODULE$.toTHandleIdentifier(launchEngineOp.getHandle().identifier());
            respConfiguration.put("kyuubi.session.engine.launch.handle.guid", Base64.getEncoder().encodeToString(opHandleIdentifier.getGuid()));
            respConfiguration.put("kyuubi.session.engine.launch.handle.secret", Base64.getEncoder().encodeToString(opHandleIdentifier.getSecret()));
            respConfiguration.put("kyuubi.session.engine.launch.support.result", Boolean.toString(true));
            respConfiguration.put("hive.server2.thrift.resultset.default.fetch.size", Integer.toString(this.defaultFetchSize()));
            resp.setSessionHandle(sessionHandle.toTSessionHandle());
            resp.setConfiguration(respConfiguration);
            resp.setStatus(TFrontendService$.MODULE$.OK_STATUS());
            Option$.MODULE$.apply(TFrontendService$.MODULE$.CURRENT_SERVER_CONTEXT().get()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.setSessionHandle(sessionHandle);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            this.error((Function0 & Serializable & scala.Serializable)() -> "Error opening session: ", e);
            resp.setStatus(KyuubiSQLException$.MODULE$.toTStatus(e, true));
        }
        return resp;
    }

    public void run() {
        try {
            if (this.isServer()) {
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Starting and exposing JDBC connection at: jdbc:hive2://").append(this.connectionUrl()).append("/").toString());
            }
            this.server().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.start();
                return BoxedUnit.UNIT;
            });
        }
        catch (InterruptedException interruptedException) {
            this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append(this.getName()).append(" is interrupted").toString());
        }
        catch (Throwable t) {
            this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Error starting ").append(this.getName()).toString(), t);
            System.exit(-1);
        }
    }

    public void stopServer() {
        this.server().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.stop();
            return BoxedUnit.UNIT;
        });
        this.server_$eq((Option<Server>)None$.MODULE$);
    }

    public boolean isServer() {
        return true;
    }

    public Option<Service> discoveryService() {
        return this.discoveryService;
    }

    private String getHttpPath(String httpPath) {
        block7: {
            block6: {
                if (httpPath == null) break block6;
                String string = httpPath;
                String string2 = "";
                if (string != null ? !string.equals(string2) : string2 != null) break block7;
            }
            return "/*";
        }
        if (!httpPath.startsWith("/")) {
            return new StringBuilder(1).append("/").append(httpPath).toString();
        }
        if (httpPath.endsWith("/")) {
            return new StringBuilder(1).append(httpPath).append("*").toString();
        }
        if (!httpPath.endsWith("/*")) {
            return new StringBuilder(2).append(httpPath).append("/*").toString();
        }
        return httpPath;
    }

    public void constrainHttpMethods(ServletContextHandler ctxHandler) {
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(true);
        ConstraintMapping cmt = new ConstraintMapping();
        cmt.setConstraint(constraint);
        cmt.setMethod("TRACE");
        cmt.setPathSpec("/*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        ConstraintMapping cmo = new ConstraintMapping();
        cmo.setConstraint(constraint);
        cmo.setMethod("OPTIONS");
        cmo.setPathSpec("/*");
        securityHandler.setConstraintMappings((ConstraintMapping[])((Object[])new ConstraintMapping[]{cmt, cmo}));
        ctxHandler.setSecurityHandler((SecurityHandler)securityHandler);
    }

    public String getIpAddress() {
        return (String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserProxyHeaderIpAddress()).getOrElse((Function0 & Serializable & scala.Serializable)() -> AuthenticationFilter$.MODULE$.getUserIpAddress());
    }

    public String getProxyUser(Map<String, String> sessionConf, String ipAddress, String realUser) {
        Option option = Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getProxyUserName());
        if (option instanceof Some) {
            Some some = (Some)option;
            String proxyUser = (String)some.value();
            scala.collection.immutable.Map proxyUserConf = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiConf$.MODULE$.PROXY_USER().key()), (Object)proxyUser)}));
            return super.getProxyUser((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sessionConf).asScala()).$plus$plus((GenTraversableOnce)proxyUserConf)).asJava(), ipAddress, realUser);
        }
        if (None$.MODULE$.equals(option)) {
            return super.getProxyUser(sessionConf, ipAddress, realUser);
        }
        throw new MatchError((Object)option);
    }

    public Tuple2<String, String> getRealUserAndSessionUser(TOpenSessionReq req) {
        String realUser = this.getShortName((String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> req.getUsername()));
        String ipAddress = AuthenticationFilter$.MODULE$.getUserIpAddress();
        String sessionUser = req.getConfiguration() == null ? realUser : this.getProxyUser(req.getConfiguration(), ipAddress, realUser);
        this.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Client's real user: ").append(realUser).append(", session user: ").append(sessionUser).toString());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)realUser), (Object)sessionUser);
    }

    private String getShortName(String userName) {
        String ret;
        block0: {
            ret = null;
            if (userName == null) break block0;
            int indexOfDomainMatch = ServiceUtils$.MODULE$.indexOfDomainMatch(userName);
            ret = indexOfDomainMatch <= 0 ? userName : userName.substring(0, indexOfDomainMatch);
        }
        return ret;
    }

    public KyuubiTHttpFrontendService(Serverable serverable) {
        this.serverable = serverable;
        super("KyuubiTHttpFrontendService");
        this.server = None$.MODULE$;
        this.APPLICATION_THRIFT = "application/x-thrift";
        this.discoveryService = None$.MODULE$;
    }
}

