/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import java.io.Serializable;
import java.net.ConnectException;
import java.util.Base64;
import org.apache.hive.service.rpc.thrift.TGetInfoType;
import org.apache.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.client.KyuubiSyncThriftClient;
import org.apache.kyuubi.client.KyuubiSyncThriftClient$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.EngineRef;
import org.apache.kyuubi.engine.KyuubiApplicationManager$;
import org.apache.kyuubi.events.EventBus$;
import org.apache.kyuubi.events.KyuubiEvent;
import org.apache.kyuubi.events.KyuubiSessionEvent;
import org.apache.kyuubi.events.KyuubiSessionEvent$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.service.authentication.InternalSecurityAccessor$;
import org.apache.kyuubi.session.KyuubiSession;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.session.package$;
import org.apache.kyuubi.sql.parser.server.KyuubiParser;
import org.apache.kyuubi.sql.plan.KyuubiTreeNode;
import org.apache.kyuubi.sql.plan.command.RunnableCommand;
import org.apache.kyuubi.util.SignUtils$;
import org.apache.thrift.transport.TTransportException;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tug\u0001\u0002!B\u0001)C\u0011b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015/\t\u0013}\u0003!\u0011!Q\u0001\n\u0001l\u0007\"\u00038\u0001\u0005\u0003\u0005\u000b\u0011\u00021p\u0011%\u0001\bA!A!\u0002\u0013\u0001\u0017\u000fC\u0005s\u0001\t\u0005\t\u0015!\u0003tm\"Iq\u000f\u0001B\u0001B\u0003%\u0001p\u001f\u0005\ty\u0002\u0011\t\u0011)A\u0005{\"Q\u0011q\u0001\u0001\u0003\u0002\u0003\u0006I!!\u0003\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!I\u0011\u0011\u0007\u0001C\u0002\u0013\u0005\u00131\u0007\u0005\t\u0003'\u0002\u0001\u0015!\u0003\u00026!Q\u0011Q\u000b\u0001C\u0002\u0013\u00051)a\u0016\t\u000f\u0005e\u0003\u0001)A\u0005g\"Q\u00111\f\u0001\t\u0006\u0004%I!!\u0018\t\u0015\u0005}\u0003\u0001#b\u0001\n\u0003\t\t\u0007\u0003\u0006\u0002n\u0001\u0011\r\u0011\"\u0001D\u0003_B\u0001\"! \u0001A\u0003%\u0011\u0011\u000f\u0005\u000b\u0003\u007f\u0002\u0001R1A\u0005\n\u0005u\u0003\"CAA\u0001\t\u0007I\u0011BAB\u0011!\t\t\n\u0001Q\u0001\n\u0005\u0015\u0005bBAJ\u0001\u0011\u0005\u0013Q\u0013\u0005\b\u0003?\u0003A\u0011IAQ\u0011-\tI\u000b\u0001a\u0001\u0002\u0004%I!a+\t\u0017\u0005e\u0006\u00011AA\u0002\u0013%\u00111\u0018\u0005\f\u0003\u0003\u0004\u0001\u0019!A!B\u0013\ti\u000bC\u0004\u00024\u0002!\t!a+\t\u0017\u0005-\u0007\u00011AA\u0002\u0013%\u0011Q\u001a\u0005\f\u0003+\u0004\u0001\u0019!a\u0001\n\u0013\t9\u000eC\u0006\u0002\\\u0002\u0001\r\u0011!Q!\n\u0005=\u0007\"CAp\u0001\u0001\u0007I\u0011BAq\u0011%\t9\u0010\u0001a\u0001\n\u0013\tI\u0010\u0003\u0005\u0002~\u0002\u0001\u000b\u0015BAr\u0011\u001d\u0011\t\u0001\u0001C!\u0003CC\u0001Ba\u0001\u0001\t\u0003\u0019%Q\u0001\u0005\u000b\u00053\u0001\u0011\u0013!C\u0001\u0007\nm\u0001b\u0002B\u0019\u0001\u0011E#1\u0007\u0005\n\u0005{\u0001\u0001\u0019!C\u0005\u0005\u007fA\u0011Ba\u0012\u0001\u0001\u0004%IA!\u0013\t\u0011\t5\u0003\u0001)Q\u0005\u0005\u0003BqA!\u0015\u0001\t\u0013\t\t\u000bC\u0004\u0003T\u0001!IA!\u0016\t\u000f\t]\u0003\u0001\"\u0011\u0002\"\"9!\u0011\f\u0001\u0005B\tm\u0003b\u0002B7\u0001\u0011\u0005#q\u000e\u0005\f\u0005\u000f\u0003\u0001\u0019!a\u0001\n\u0013\u0011I\tC\u0006\u0003\f\u0002\u0001\r\u00111A\u0005\n\t5\u0005b\u0003BI\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u0003C\u0011B!&\u0001\u0005\u0004%IA!#\t\u0011\t]\u0005\u0001)A\u0005\u0005\u0003C\u0011B!'\u0001\u0005\u0004%IAa\u0010\t\u0011\tm\u0005\u0001)A\u0005\u0005\u0003B\u0011B!(\u0001\u0005\u0004%IAa(\t\u0011\t\u001d\u0006\u0001)A\u0005\u0005CC\u0011B!+\u0001\u0001\u0004%IAa(\t\u0013\t-\u0006\u00011A\u0005\n\t5\u0006\u0002\u0003BY\u0001\u0001\u0006KA!)\t\u000f\tU\u0006\u0001\"\u0001\u00038\"i!\u0011\u0018\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002^5DaBa/\u0001!\u0003\r\t\u0011!C\u0005\u0003C\u0013i\fC\u0007\u0003@\u0002\u0001\n1!A\u0001\n\u0013\u0011\tm\u001f\u0005\u000e\u0005\u0013\u0004\u0001\u0013aA\u0001\u0002\u0013%\u0011QL8\t\u001b\t-\u0007\u0001%A\u0002\u0002\u0003%IA!4]\u00119\u0011y\r\u0001I\u0001\u0004\u0003\u0005I\u0011\u0002Bi\u00057\u0014\u0011cS=vk\nL7+Z:tS>t\u0017*\u001c9m\u0015\t\u00115)A\u0004tKN\u001c\u0018n\u001c8\u000b\u0005\u0011+\u0015AB6zkV\u0014\u0017N\u0003\u0002G\u000f\u00061\u0011\r]1dQ\u0016T\u0011\u0001S\u0001\u0004_J<7\u0001A\n\u0003\u0001-\u0003\"\u0001T'\u000e\u0003\u0005K!AT!\u0003\u001b-KX/\u001e2j'\u0016\u001c8/[8o\u0003!\u0001(o\u001c;pG>d\u0007CA)[\u001b\u0005\u0011&BA*U\u0003\u0019!\bN]5gi*\u0011QKV\u0001\u0004eB\u001c'BA,Y\u0003\u001d\u0019XM\u001d<jG\u0016T!!W#\u0002\t!Lg/Z\u0005\u00037J\u0013\u0001\u0003\u0016)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\n\u0005=k\u0016B\u00010B\u0005=\t%m\u001d;sC\u000e$8+Z:tS>t\u0017\u0001B;tKJ\u0004\"!\u00196\u000f\u0005\tD\u0007CA2g\u001b\u0005!'BA3J\u0003\u0019a$o\\8u})\tq-A\u0003tG\u0006d\u0017-\u0003\u0002jM\u00061\u0001K]3eK\u001aL!a\u001b7\u0003\rM#(/\u001b8h\u0015\tIg-\u0003\u0002`;\u0006A\u0001/Y:to>\u0014H-\u0003\u0002o;\u0006I\u0011\u000e]!eIJ,7o]\u0005\u0003av\u000bAaY8oMB!\u0011\r\u001e1a\u0013\t)HNA\u0002NCBL!A]/\u0002\u001dM,7o]5p]6\u000bg.Y4feB\u0011A*_\u0005\u0003u\u0006\u0013AcS=vk\nL7+Z:tS>tW*\u00198bO\u0016\u0014\u0018BA<^\u0003-\u0019Xm]:j_:\u001cuN\u001c4\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\taQ\u0001\u0007G>tg-[4\n\u0007\u0005\u0015qP\u0001\u0006LsV,(-[\"p]\u001a\fa\u0001]1sg\u0016\u0014\b\u0003BA\u0006\u0003/i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\t\u0005\u001d\u00111\u0003\u0006\u0004\u0003+\u0019\u0015aA:rY&!\u0011\u0011DA\u0007\u00051Y\u00150^;cSB\u000b'o]3s\u0003\u0019a\u0014N\\5u}Q\u0011\u0012qDA\u0011\u0003G\t)#a\n\u0002*\u0005-\u0012QFA\u0018!\ta\u0005\u0001C\u0003P\u0013\u0001\u0007\u0001\u000bC\u0003`\u0013\u0001\u0007\u0001\rC\u0003o\u0013\u0001\u0007\u0001\rC\u0003q\u0013\u0001\u0007\u0001\rC\u0003s\u0013\u0001\u00071\u000fC\u0003x\u0013\u0001\u0007\u0001\u0010C\u0003}\u0013\u0001\u0007Q\u0010C\u0004\u0002\b%\u0001\r!!\u0003\u0002\u0017M,7o]5p]RK\b/Z\u000b\u0003\u0003k\u0001B!a\u000e\u0002N9!\u0011\u0011HA%\u001d\u0011\tY$a\u0012\u000f\t\u0005u\u0012Q\t\b\u0005\u0003\u007f\t\u0019ED\u0002d\u0003\u0003J\u0011\u0001S\u0005\u0003\r\u001eK!\u0001R#\n\u0005\t\u001b\u0015bAA&\u0003\u0006Y1+Z:tS>tG+\u001f9f\u0013\u0011\ty%!\u0015\u0003\u0017M+7o]5p]RK\b/\u001a\u0006\u0004\u0003\u0017\n\u0015\u0001D:fgNLwN\u001c+za\u0016\u0004\u0013!D8qi&l\u0017N_3e\u0007>tg-F\u0001t\u00039y\u0007\u000f^5nSj,GmQ8oM\u0002\n\u0011#\u001a8hS:,7I]3eK:$\u0018.\u00197t+\u0005\u0001\u0017AB3oO&tW-\u0006\u0002\u0002dA!\u0011QMA5\u001b\t\t9GC\u0002\u0002`\rKA!a\u001b\u0002h\tIQI\\4j]\u0016\u0014VMZ\u0001\u000fY\u0006,hn\u00195F]\u001eLg.Z(q+\t\t\t\b\u0005\u0003\u0002t\u0005eTBAA;\u0015\r\t9hQ\u0001\n_B,'/\u0019;j_:LA!a\u001f\u0002v\tIq\n]3sCRLwN\\\u0001\u0010Y\u0006,hn\u00195F]\u001eLg.Z(qA\u0005)2/Z:tS>tWk]3s'&<gNQ1tKZ\"\u0014\u0001D:fgNLwN\\#wK:$XCAAC!\u0011\t9)!$\u000e\u0005\u0005%%bAAF\u0007\u00061QM^3oiNLA!a$\u0002\n\n\u00112*_;vE&\u001cVm]:j_:,e/\u001a8u\u00035\u0019Xm]:j_:,e/\u001a8uA\u0005yq-\u001a;TKN\u001c\u0018n\u001c8Fm\u0016tG/\u0006\u0002\u0002\u0018B1\u0011\u0011TAN\u0003\u000bk\u0011AZ\u0005\u0004\u0003;3'AB(qi&|g.\u0001\u000edQ\u0016\u001c7nU3tg&|g.Q2dKN\u001c\b+\u0019;i+JK5\u000f\u0006\u0002\u0002$B!\u0011\u0011TAS\u0013\r\t9K\u001a\u0002\u0005+:LG/A\u0004`G2LWM\u001c;\u0016\u0005\u00055\u0006\u0003BAX\u0003kk!!!-\u000b\u0007\u0005M6)\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003o\u000b\tL\u0001\fLsV,(-[*z]\u000e$\u0006N]5gi\u000ec\u0017.\u001a8u\u0003-y6\r\\5f]R|F%Z9\u0015\t\u0005\r\u0016Q\u0018\u0005\n\u0003\u007fC\u0012\u0011!a\u0001\u0003[\u000b1\u0001\u001f\u00132\u0003!y6\r\\5f]R\u0004\u0003fA\r\u0002FB!\u0011\u0011TAd\u0013\r\tIM\u001a\u0002\tm>d\u0017\r^5mK\u0006!r,\u001a8hS:,7+Z:tS>t\u0007*\u00198eY\u0016,\"!a4\u0011\u00071\u000b\t.C\u0002\u0002T\u0006\u0013QbU3tg&|g\u000eS1oI2,\u0017\u0001G0f]\u001eLg.Z*fgNLwN\u001c%b]\u0012dWm\u0018\u0013fcR!\u00111UAm\u0011%\ty\fHA\u0001\u0002\u0004\ty-A\u000b`K:<\u0017N\\3TKN\u001c\u0018n\u001c8IC:$G.\u001a\u0011)\u0007u\t)-\u0001\tpa\u0016t7+Z:tS>tWI\u001d:peV\u0011\u00111\u001d\t\u0007\u00033\u000bY*!:\u0011\t\u0005\u001d\u0018\u0011\u001f\b\u0005\u0003S\fiOD\u0002d\u0003WL\u0011aZ\u0005\u0004\u0003_4\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003g\f)PA\u0005UQJ|w/\u00192mK*\u0019\u0011q\u001e4\u0002)=\u0004XM\\*fgNLwN\\#se>\u0014x\fJ3r)\u0011\t\u0019+a?\t\u0013\u0005}v$!AA\u0002\u0005\r\u0018!E8qK:\u001cVm]:j_:,%O]8sA!\u001a\u0001%!2\u0002\t=\u0004XM\\\u0001\u0012_B,g.\u00128hS:,7+Z:tS>tG\u0003BAR\u0005\u000fA\u0011B!\u0003#!\u0003\u0005\rAa\u0003\u0002\u001d\u0015DHO]1F]\u001eLg.\u001a'pOB1\u0011\u0011TAN\u0005\u001b\u0001BAa\u0004\u0003\u00165\u0011!\u0011\u0003\u0006\u0005\u0005'\t)(A\u0002m_\u001eLAAa\u0006\u0003\u0012\taq\n]3sCRLwN\u001c'pO\u0006Yr\u000e]3o\u000b:<\u0017N\\3TKN\u001c\u0018n\u001c8%I\u00164\u0017-\u001e7uIE*\"A!\b+\t\t-!qD\u0016\u0003\u0005C\u0001BAa\t\u0003.5\u0011!Q\u0005\u0006\u0005\u0005O\u0011I#A\u0005v]\u000eDWmY6fI*\u0019!1\u00064\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00030\t\u0015\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006a!/\u001e8Pa\u0016\u0014\u0018\r^5p]R!!Q\u0007B\u001e!\u0011\t\u0019Ha\u000e\n\t\te\u0012Q\u000f\u0002\u0010\u001fB,'/\u0019;j_:D\u0015M\u001c3mK\"9\u0011q\u000f\u0013A\u0002\u0005E\u0014AD3oO&tW\rT1v]\u000eDW\rZ\u000b\u0003\u0005\u0003\u0002B!!'\u0003D%\u0019!Q\t4\u0003\u000f\t{w\u000e\\3b]\u0006\u0011RM\\4j]\u0016d\u0015-\u001e8dQ\u0016$w\fJ3r)\u0011\t\u0019Ka\u0013\t\u0013\u0005}f%!AA\u0002\t\u0005\u0013aD3oO&tW\rT1v]\u000eDW\r\u001a\u0011)\u0007\u001d\n)-A\u000bxC&$hi\u001c:F]\u001eLg.\u001a'bk:\u001c\u0007.\u001a3\u0002-I,g.Z<F]\u001eLg.Z\"sK\u0012,g\u000e^5bYN$\u0012\u0001Y\u0001\u0006G2|7/Z\u0001\bO\u0016$\u0018J\u001c4p)\u0011\u0011iFa\u0019\u0011\u0007E\u0013y&C\u0002\u0003bI\u0013Q\u0002V$fi&sgm\u001c,bYV,\u0007b\u0002B3W\u0001\u0007!qM\u0001\tS:4w\u000eV=qKB\u0019\u0011K!\u001b\n\u0007\t-$K\u0001\u0007U\u000f\u0016$\u0018J\u001c4p)f\u0004X-\u0001\tfq\u0016\u001cW\u000f^3Ti\u0006$X-\\3oiRQ!Q\u0007B9\u0005k\u0012IH! \t\r\tMD\u00061\u0001a\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0003\u0004\u0003x1\u0002\ra]\u0001\fG>tgm\u0014<fe2\f\u0017\u0010C\u0004\u0003|1\u0002\rA!\u0011\u0002\u0011I,h.Q:z]\u000eDqAa -\u0001\u0004\u0011\t)\u0001\u0007rk\u0016\u0014\u0018\u0010V5nK>,H\u000f\u0005\u0003\u0002\u001a\n\r\u0015b\u0001BCM\n!Aj\u001c8h\u0003=)gnZ5oK2\u000b7\u000f^!mSZ,WC\u0001BA\u0003M)gnZ5oK2\u000b7\u000f^!mSZ,w\fJ3r)\u0011\t\u0019Ka$\t\u0013\u0005}f&!AA\u0002\t\u0005\u0015\u0001E3oO&tW\rT1ti\u0006c\u0017N^3!Q\ry\u0013QY\u0001\u0013K:<\u0017N\\3BY&4X\rV5nK>,H/A\nf]\u001eLg.Z!mSZ,G+[7f_V$\b%A\tbY&4X\r\u0015:pE\u0016,e.\u00192mK\u0012\f!#\u00197jm\u0016\u0004&o\u001c2f\u000b:\f'\r\\3eA\u00059RM\\4j]\u0016\fE.\u001b<f\u001b\u0006Dh)Y5m\u0007>,h\u000e^\u000b\u0003\u0005C\u0003B!!'\u0003$&\u0019!Q\u00154\u0003\u0007%sG/\u0001\rf]\u001eLg.Z!mSZ,W*\u0019=GC&d7i\\;oi\u0002\nA#\u001a8hS:,\u0017\t\\5wK\u001a\u000b\u0017\u000e\\\"pk:$\u0018\u0001G3oO&tW-\u00117jm\u00164\u0015-\u001b7D_VtGo\u0018\u0013fcR!\u00111\u0015BX\u0011%\tylNA\u0001\u0002\u0004\u0011\t+A\u000bf]\u001eLg.Z!mSZ,g)Y5m\u0007>,h\u000e\u001e\u0011)\u0007a\n)-\u0001\u000edQ\u0016\u001c7.\u00128hS:,7i\u001c8oK\u000e$\u0018n\u001c8BY&4X\r\u0006\u0002\u0003B\u0005Q1/\u001e9fe\u0012*8/\u001a:\u0002\u0015M,\b/\u001a:%_B,g.C\u0002\u0003\u0002u\u000bAc];qKJ$3/Z:tS>tW*\u00198bO\u0016\u0014XC\u0001Bb!\ra%QY\u0005\u0004\u0005\u000f\f%AD*fgNLwN\\'b]\u0006<WM]\u0001\u000fgV\u0004XM\u001d\u0013qCN\u001cxo\u001c:e\u00039\u0019X\u000f]3sIA\u0014x\u000e^8d_2,\u0012\u0001U\u0001\u0017gV\u0004XM\u001d\u0013fq\u0016\u001cW\u000f^3Ti\u0006$X-\\3oiRQ!Q\u0007Bj\u0005+\u00149N!7\t\r\tMt\b1\u0001a\u0011\u0019\u00119h\u0010a\u0001g\"9!1P A\u0002\t\u0005\u0003b\u0002B@\u007f\u0001\u0007!\u0011Q\u0005\u0004\u0005[j\u0006")
public class KyuubiSessionImpl
extends KyuubiSession {
    private String engineCredentials;
    private EngineRef engine;
    private String sessionUserSignBase64;
    private final KyuubiConf sessionConf;
    private final KyuubiParser parser;
    private final Enumeration.Value sessionType;
    private final scala.collection.immutable.Map<String, String> optimizedConf;
    private final Operation launchEngineOp;
    private final KyuubiSessionEvent sessionEvent;
    private volatile KyuubiSyncThriftClient _client;
    private volatile SessionHandle _engineSessionHandle;
    private volatile Option<Throwable> openSessionError;
    private volatile boolean engineLaunched;
    private volatile long engineLastAlive;
    private final long engineAliveTimeout;
    private final boolean aliveProbeEnabled;
    private final int engineAliveMaxFailCount;
    private volatile int engineAliveFailCount;
    private volatile byte bitmap$0;

    private /* synthetic */ String super$user() {
        return super.user();
    }

    private /* synthetic */ void super$open() {
        super.open();
    }

    private /* synthetic */ SessionManager super$sessionManager() {
        return super.sessionManager();
    }

    private /* synthetic */ String super$password() {
        return super.password();
    }

    private /* synthetic */ TProtocolVersion super$protocol() {
        return super.protocol();
    }

    private /* synthetic */ OperationHandle super$executeStatement(String statement, scala.collection.immutable.Map confOverlay, boolean runAsync, long queryTimeout) {
        return super.executeStatement(statement, confOverlay, runAsync, queryTimeout);
    }

    @Override
    public Enumeration.Value sessionType() {
        return this.sessionType;
    }

    public scala.collection.immutable.Map<String, String> optimizedConf() {
        return this.optimizedConf;
    }

    private String engineCredentials$lzycompute() {
        KyuubiSessionImpl kyuubiSessionImpl = this;
        synchronized (kyuubiSessionImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.engineCredentials = this.renewEngineCredentials();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.engineCredentials;
    }

    private String engineCredentials() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.engineCredentials$lzycompute();
        }
        return this.engineCredentials;
    }

    private EngineRef engine$lzycompute() {
        KyuubiSessionImpl kyuubiSessionImpl = this;
        synchronized (kyuubiSessionImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.engine = new EngineRef(this.sessionConf, super.user(), ((KyuubiSessionManager)super.sessionManager()).groupProvider(), this.handle().identifier().toString(), ((KyuubiSessionManager)super.sessionManager()).applicationManager(), ((KyuubiSessionManager)super.sessionManager()).engineStartupProcessSemaphore());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.engine;
    }

    public EngineRef engine() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.engine$lzycompute();
        }
        return this.engine;
    }

    public Operation launchEngineOp() {
        return this.launchEngineOp;
    }

    private String sessionUserSignBase64$lzycompute() {
        KyuubiSessionImpl kyuubiSessionImpl = this;
        synchronized (kyuubiSessionImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.sessionUserSignBase64 = SignUtils$.MODULE$.signWithPrivateKey(super.user(), ((KyuubiSessionManager)super.sessionManager()).signingPrivateKey(), SignUtils$.MODULE$.signWithPrivateKey$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.sessionUserSignBase64;
    }

    private String sessionUserSignBase64() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.sessionUserSignBase64$lzycompute();
        }
        return this.sessionUserSignBase64;
    }

    private KyuubiSessionEvent sessionEvent() {
        return this.sessionEvent;
    }

    @Override
    public Option<KyuubiSessionEvent> getSessionEvent() {
        return Option$.MODULE$.apply((Object)this.sessionEvent());
    }

    @Override
    public void checkSessionAccessPathURIs() {
        KyuubiApplicationManager$.MODULE$.checkApplicationAccessPaths((String)this.sessionConf.get(KyuubiConf$.MODULE$.ENGINE_TYPE()), (scala.collection.immutable.Map<String, String>)this.sessionConf.getAll(), ((KyuubiSessionManager)super.sessionManager()).getConf());
    }

    private KyuubiSyncThriftClient _client() {
        return this._client;
    }

    private void _client_$eq(KyuubiSyncThriftClient x$1) {
        this._client = x$1;
    }

    public KyuubiSyncThriftClient client() {
        return this._client();
    }

    private SessionHandle _engineSessionHandle() {
        return this._engineSessionHandle;
    }

    private void _engineSessionHandle_$eq(SessionHandle x$1) {
        this._engineSessionHandle = x$1;
    }

    private Option<Throwable> openSessionError() {
        return this.openSessionError;
    }

    private void openSessionError_$eq(Option<Throwable> x$1) {
        this.openSessionError = x$1;
    }

    public void open() {
        this.handleSessionException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.traceMetricsOnOpen();
            this.checkSessionAccessPathURIs();
            this.super$open();
            this.runOperation(this.launchEngineOp());
            this.engineLastAlive_$eq(System.currentTimeMillis());
        });
    }

    public void openEngineSession(Option<OperationLog> extraEngineLog) {
        this.handleSessionException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DiscoveryClientProvider$.MODULE$.withDiscoveryClient($this.sessionConf, (Function1 & Serializable & scala.Serializable)discoveryClient -> {
            KyuubiSessionImpl.$anonfun$openEngineSession$2(this, extraEngineLog, discoveryClient);
            return BoxedUnit.UNIT;
        }));
    }

    public Option<OperationLog> openEngineSession$default$1() {
        return None$.MODULE$;
    }

    public OperationHandle runOperation(Operation operation) {
        block2: {
            Operation operation2 = operation;
            Operation operation3 = this.launchEngineOp();
            if (!(operation2 == null ? operation3 != null : !operation2.equals(operation3))) break block2;
            try {
                this.waitForEngineLaunched();
            }
            catch (Throwable t) {
                operation.close();
                throw t;
            }
            this.sessionEvent().totalOperations_$eq(this.sessionEvent().totalOperations() + 1);
        }
        return super.runOperation(operation);
    }

    private boolean engineLaunched() {
        return this.engineLaunched;
    }

    private void engineLaunched_$eq(boolean x$1) {
        this.engineLaunched = x$1;
    }

    private void waitForEngineLaunched() {
        if (!this.engineLaunched()) {
            Option$.MODULE$.apply((Object)this.launchEngineOp()).foreach((Function1 & Serializable & scala.Serializable)op -> {
                KyuubiSessionImpl.$anonfun$waitForEngineLaunched$1(this, op);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private String renewEngineCredentials() {
        String string;
        try {
            string = ((KyuubiSessionManager)super.sessionManager()).credentialsManager().renewCredentials(this.engine().appUser());
        }
        catch (Exception e) {
            this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Failed to renew engine credentials for ").append(this.handle()).toString(), e);
            string = "";
        }
        return string;
    }

    public void close() {
        super.close();
        ((KyuubiSessionManager)super.sessionManager()).credentialsManager().removeSessionCredentialsEpoch(this.handle().identifier().toString());
        try {
            if (this._client() != null) {
                this._client().closeSession();
            }
        }
        finally {
            this.openSessionError().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                KyuubiSessionImpl.$anonfun$close$1(this, x$3);
                return BoxedUnit.UNIT;
            });
            this.sessionEvent().endTime_$eq(System.currentTimeMillis());
            EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
            this.traceMetricsOnClose();
        }
    }

    public TGetInfoValue getInfo(TGetInfoType infoType) {
        String string = (String)this.sessionConf.get(KyuubiConf$.MODULE$.SERVER_INFO_PROVIDER());
        if ("SERVER".equals(string)) {
            return super.getInfo(infoType);
        }
        if ("ENGINE".equals(string)) {
            return (TGetInfoValue)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
                this.waitForEngineLaunched();
                return this.client().getInfo(infoType).getInfoValue();
            });
        }
        throw new IllegalArgumentException(new StringBuilder(29).append("Unknown server info provider ").append(string).toString());
    }

    public OperationHandle executeStatement(String statement, scala.collection.immutable.Map<String, String> confOverlay, boolean runAsync, long queryTimeout) {
        return (OperationHandle)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
            KyuubiTreeNode kyuubiNode = $this.parser.parsePlan(statement);
            KyuubiTreeNode kyuubiTreeNode = kyuubiNode;
            if (kyuubiTreeNode instanceof RunnableCommand) {
                RunnableCommand runnableCommand = (RunnableCommand)kyuubiTreeNode;
                Operation operation = ((KyuubiSessionManager)this.super$sessionManager()).operationManager().newExecuteOnServerOperation(this, runAsync, runnableCommand);
                return this.runOperation(operation);
            }
            return this.super$executeStatement(statement, confOverlay, runAsync, queryTimeout);
        });
    }

    private long engineLastAlive() {
        return this.engineLastAlive;
    }

    private void engineLastAlive_$eq(long x$1) {
        this.engineLastAlive = x$1;
    }

    private long engineAliveTimeout() {
        return this.engineAliveTimeout;
    }

    private boolean aliveProbeEnabled() {
        return this.aliveProbeEnabled;
    }

    private int engineAliveMaxFailCount() {
        return this.engineAliveMaxFailCount;
    }

    private int engineAliveFailCount() {
        return this.engineAliveFailCount;
    }

    private void engineAliveFailCount_$eq(int x$1) {
        this.engineAliveFailCount = x$1;
    }

    public boolean checkEngineConnectionAlive() {
        boolean bl;
        block5: {
            try {
                if (Option$.MODULE$.apply((Object)this.client()).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.engineConnectionClosed()))) {
                    return false;
                }
                if (!this.aliveProbeEnabled()) {
                    return true;
                }
                this.getInfo(TGetInfoType.CLI_DBMS_VER);
                this.engineLastAlive_$eq(System.currentTimeMillis());
                this.engineAliveFailCount_$eq(0);
                bl = true;
            }
            catch (Throwable e) {
                long now = System.currentTimeMillis();
                this.engineAliveFailCount_$eq(this.engineAliveFailCount() + 1);
                if (now - this.engineLastAlive() > this.engineAliveTimeout() && this.engineAliveFailCount() >= this.engineAliveMaxFailCount()) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(229).append("The engineRef[").append(this.engine().getEngineRefId()).append("] is marked as not alive ").append("due to a lack of recent successful alive probes. ").append("The time since last successful probe: ").append(now - this.engineLastAlive()).append(" ms exceeds the timeout of ").append(this.engineAliveTimeout()).append(" ms. ").append("The engine has failed ").append(this.engineAliveFailCount()).append(" times, ").append("surpassing the maximum failure count of ").append(this.engineAliveMaxFailCount()).append(".").toString());
                    bl = false;
                    break block5;
                }
                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("The engineRef[").append(this.engine().getEngineRefId()).append("] alive probe fails, ").append(now - this.engineLastAlive()).append(" ms exceeds timeout ").append(this.engineAliveTimeout()).append(" ms, ").append("and has failed ").append(this.engineAliveFailCount()).append(" times.").toString(), e);
                bl = true;
            }
        }
        return bl;
    }

    private final void deregisterEngine$1(DiscoveryClient discoveryClient$1, String host$1, int port$1) {
        try {
            this.engine().deregister(discoveryClient$1, (Tuple2<String, Object>)new Tuple2((Object)host$1, (Object)BoxesRunTime.boxToInteger((int)port$1)));
        }
        catch (Throwable e) {
            this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Error on de-registering engine [").append(this.engine().engineSpace()).append(" ").append(host$1).append(":").append(port$1).append("]").toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$openEngineSession$4(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openEngineSession$10(KyuubiSessionImpl $this, String e) {
        $this.sessionEvent().engineId_$eq(e);
    }

    public static final /* synthetic */ void $anonfun$openEngineSession$2(KyuubiSessionImpl $this, Option extraEngineLog$1, DiscoveryClient discoveryClient) {
        scala.collection.immutable.Map openEngineSessionConf = $this.optimizedConf().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.handle"), (Object)$this.handle().identifier().toString())})));
        if (new StringOps(Predef$.MODULE$.augmentString($this.engineCredentials())).nonEmpty()) {
            $this.sessionConf.set("kyuubi.engine.credentials", $this.engineCredentials());
            openEngineSessionConf = openEngineSessionConf.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.engine.credentials"), (Object)$this.engineCredentials())})));
        }
        if (BoxesRunTime.unboxToBoolean((Object)$this.sessionConf.get(KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED()))) {
            openEngineSessionConf = openEngineSessionConf.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED().key()), (Object)$this.sessionConf.get(KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED()).toString())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.sign.publickey"), (Object)Base64.getEncoder().encodeToString(((KyuubiSessionManager)$this.super$sessionManager()).signingPublicKey().getEncoded()))).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.user.sign"), (Object)$this.sessionUserSignBase64()));
        }
        int maxAttempts = BoxesRunTime.unboxToInt((Object)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_OPEN_MAX_ATTEMPTS()));
        long retryWait = BoxesRunTime.unboxToLong((Object)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_OPEN_RETRY_WAIT()));
        Enumeration.Value openOnFailure = KyuubiConf.EngineOpenOnFailure$.MODULE$.withName((String)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_OPEN_ON_FAILURE()));
        IntRef attempt = IntRef.create((int)0);
        boolean shouldRetry = true;
        while (attempt.elem <= maxAttempts && shouldRetry) {
            Tuple2<String, Object> tuple2 = $this.engine().getOrCreate(discoveryClient, (Option<OperationLog>)extraEngineLog$1);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String host = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
            String host2 = (String)tuple22._1();
            int port2 = tuple22._2$mcI$sp();
            try {
                try {
                    String passwd = BoxesRunTime.unboxToBoolean((Object)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_SECURITY_ENABLED())) ? InternalSecurityAccessor$.MODULE$.get().issueToken() : (String)Option$.MODULE$.apply((Object)$this.super$password()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionImpl.$anonfun$openEngineSession$4(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
                    $this._client_$eq(KyuubiSyncThriftClient$.MODULE$.createClient($this.super$user(), passwd, host2, port2, $this.sessionConf));
                    $this._engineSessionHandle_$eq($this._client().openSession($this.super$protocol(), $this.super$user(), passwd, (scala.collection.immutable.Map<String, String>)openEngineSessionConf));
                    $this.logSessionInfo(new StringBuilder(33).append("Connected to engine [").append(host2).append(":").append(port2).append("]/[").append($this.client().engineId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("]").append(" with ").append($this._engineSessionHandle()).append("]").toString());
                    shouldRetry = false;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof TTransportException) {
                        TTransportException tTransportException = (TTransportException)throwable2;
                        if (attempt.elem < maxAttempts && tTransportException.getCause() instanceof ConnectException && tTransportException.getCause().getMessage().contains("Connection refused")) {
                            $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Failed to open [").append($this.engine().defaultEngineName()).append(" ").append(host2).append(":").append(port2).append("] after").append(" ").append(attempt$1.elem).append("/").append(maxAttempts).append(" times, retrying").toString(), tTransportException.getCause());
                            Thread.sleep(retryWait);
                            Enumeration.Value value = openOnFailure;
                            Enumeration.Value value2 = KyuubiConf.EngineOpenOnFailure$.MODULE$.DEREGISTER_IMMEDIATELY();
                            Enumeration.Value value3 = value;
                            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                                $this.deregisterEngine$1(discoveryClient, host2, port2);
                            }
                            shouldRetry = true;
                            continue;
                        }
                    }
                    if (throwable2 != null) {
                        boolean bl;
                        Throwable throwable3 = throwable2;
                        $this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Opening engine [").append($this.engine().defaultEngineName()).append(" ").append(host2).append(":").append(port2).append("]").append(" for ").append($this.super$user()).append(" session failed").toString(), throwable3);
                        $this.openSessionError_$eq((Option<Throwable>)new Some((Object)throwable3));
                        Enumeration.Value value = openOnFailure;
                        Enumeration.Value value4 = KyuubiConf.EngineOpenOnFailure$.MODULE$.DEREGISTER_IMMEDIATELY();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            bl = true;
                        } else {
                            Enumeration.Value value6 = KyuubiConf.EngineOpenOnFailure$.MODULE$.DEREGISTER_AFTER_RETRY();
                            Enumeration.Value value7 = value;
                            bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
                        }
                        if (bl) {
                            $this.deregisterEngine$1(discoveryClient, host2, port2);
                        }
                        throw throwable3;
                    }
                    throw throwable;
                }
            }
            finally {
                ++attempt.elem;
                if (!shouldRetry || $this._client() == null) continue;
                try {
                    $this._client().closeSession();
                }
                catch (Throwable e2) {
                    $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Error on closing broken client of engine ").append("[").append($this.engine().defaultEngineName()).append(" ").append(host2).append(":").append(port2).append("]").toString(), e2);
                }
            }
        }
        $this.sessionEvent().openedTime_$eq(System.currentTimeMillis());
        $this.sessionEvent().remoteSessionId_$eq($this._engineSessionHandle().identifier().toString());
        $this._client().engineId().foreach((Function1 & Serializable & scala.Serializable)e -> {
            KyuubiSessionImpl.$anonfun$openEngineSession$10($this, e);
            return BoxedUnit.UNIT;
        });
        EventBus$.MODULE$.post((KyuubiEvent)$this.sessionEvent());
    }

    public static final /* synthetic */ void $anonfun$waitForEngineLaunched$1(KyuubiSessionImpl $this, Operation op) {
        long waitingStartTime = System.currentTimeMillis();
        $this.logSessionInfo("Starting to wait the launch engine operation finished");
        op.getBackgroundHandle().get();
        long elapsedTime = System.currentTimeMillis() - waitingStartTime;
        $this.logSessionInfo(new StringBuilder(42).append("Engine has been launched, elapsed time: ").append(elapsedTime / 1000L).append(" s").toString());
        if ($this._engineSessionHandle() == null) {
            KyuubiSQLException ex = (KyuubiSQLException)op.getStatus().exception().getOrElse((Function0 & Serializable & scala.Serializable)() -> KyuubiSQLException$.MODULE$.apply(new StringBuilder(28).append("Failed to launch engine for ").append($this.handle()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4()));
            throw ex;
        }
        $this.engineLaunched_$eq(true);
    }

    public static final /* synthetic */ void $anonfun$close$1(KyuubiSessionImpl $this, Throwable x$3) {
        if ($this.engine() != null) {
            $this.engine().close();
            return;
        }
    }

    public KyuubiSessionImpl(TProtocolVersion protocol, String user, String password, String ipAddress, scala.collection.immutable.Map<String, String> conf, KyuubiSessionManager sessionManager, KyuubiConf sessionConf, KyuubiParser parser) {
        scala.collection.immutable.Map map;
        this.sessionConf = sessionConf;
        this.parser = parser;
        super(protocol, user, password, ipAddress, conf, sessionManager);
        this.sessionType = SessionType$.MODULE$.INTERACTIVE();
        java.util.Map confOverlay = ((KyuubiSessionManager)super.sessionManager()).sessionConfAdvisor().getConfOverlay(super.user(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.normalizedConf()).asJava());
        if (confOverlay != null) {
            map = this.normalizedConf().$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(confOverlay).asScala());
        } else {
            this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("the server plugin return null value for user: ").append(this.super$user()).append(", ignore it").toString());
            map = this.normalizedConf();
        }
        this.optimizedConf = map;
        this.optimizedConf().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String string2 = package$.MODULE$.USE_CATALOG();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String string4 = package$.MODULE$.USE_DATABASE();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return $this.sessionConf.set(key, value);
            }
            throw new MatchError((Object)tuple2);
        });
        this.launchEngineOp = ((KyuubiSessionManager)super.sessionManager()).operationManager().newLaunchEngineOperation(this, BoxesRunTime.unboxToBoolean((Object)sessionConf.get(KyuubiConf$.MODULE$.SESSION_ENGINE_LAUNCH_ASYNC())));
        this.sessionEvent = KyuubiSessionEvent$.MODULE$.apply(this);
        EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
        this.openSessionError = None$.MODULE$;
        this.engineLaunched = false;
        this.engineAliveTimeout = BoxesRunTime.unboxToLong((Object)sessionConf.get(KyuubiConf$.MODULE$.ENGINE_ALIVE_TIMEOUT()));
        this.aliveProbeEnabled = BoxesRunTime.unboxToBoolean((Object)sessionConf.get(KyuubiConf$.MODULE$.ENGINE_ALIVE_PROBE_ENABLED()));
        this.engineAliveMaxFailCount = BoxesRunTime.unboxToInt((Object)sessionConf.get(KyuubiConf$.MODULE$.ENGINE_ALIVE_MAX_FAILURES()));
        this.engineAliveFailCount = 0;
    }
}

