/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.grpc.grpclb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.kyuubi.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;
import org.apache.kyuubi.shade.com.google.common.base.Stopwatch;
import org.apache.kyuubi.shade.io.grpc.Attributes;
import org.apache.kyuubi.shade.io.grpc.ChannelLogger;
import org.apache.kyuubi.shade.io.grpc.Context;
import org.apache.kyuubi.shade.io.grpc.EquivalentAddressGroup;
import org.apache.kyuubi.shade.io.grpc.LoadBalancer;
import org.apache.kyuubi.shade.io.grpc.Status;
import org.apache.kyuubi.shade.io.grpc.grpclb.GrpclbConfig;
import org.apache.kyuubi.shade.io.grpc.grpclb.GrpclbConstants;
import org.apache.kyuubi.shade.io.grpc.grpclb.GrpclbState;
import org.apache.kyuubi.shade.io.grpc.grpclb.SubchannelPool;
import org.apache.kyuubi.shade.io.grpc.internal.BackoffPolicy;
import org.apache.kyuubi.shade.io.grpc.internal.TimeProvider;

class GrpclbLoadBalancer
extends LoadBalancer {
    private static final GrpclbConfig DEFAULT_CONFIG = GrpclbConfig.create(GrpclbState.Mode.ROUND_ROBIN);
    private final LoadBalancer.Helper helper;
    private final Context context;
    private final TimeProvider time;
    private final Stopwatch stopwatch;
    private final SubchannelPool subchannelPool;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private GrpclbConfig config = DEFAULT_CONFIG;
    @Nullable
    private GrpclbState grpclbState;

    GrpclbLoadBalancer(LoadBalancer.Helper helper, Context context, SubchannelPool subchannelPool, TimeProvider time, Stopwatch stopwatch, BackoffPolicy.Provider backoffPolicyProvider) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.context = Preconditions.checkNotNull(context, "context");
        this.time = Preconditions.checkNotNull(time, "time provider");
        this.stopwatch = Preconditions.checkNotNull(stopwatch, "stopwatch");
        this.backoffPolicyProvider = Preconditions.checkNotNull(backoffPolicyProvider, "backoffPolicyProvider");
        this.subchannelPool = Preconditions.checkNotNull(subchannelPool, "subchannelPool");
        this.recreateStates();
        Preconditions.checkNotNull(this.grpclbState, "grpclbState");
    }

    @Override
    public boolean acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        Attributes attributes = resolvedAddresses.getAttributes();
        List<EquivalentAddressGroup> newLbAddresses = attributes.get(GrpclbConstants.ATTR_LB_ADDRS);
        if (newLbAddresses == null) {
            newLbAddresses = Collections.emptyList();
        }
        if (newLbAddresses.isEmpty() && resolvedAddresses.getAddresses().isEmpty()) {
            this.handleNameResolutionError(Status.UNAVAILABLE.withDescription("No backend or balancer addresses found"));
            return false;
        }
        ArrayList<EquivalentAddressGroup> overrideAuthorityLbAddresses = new ArrayList<EquivalentAddressGroup>(newLbAddresses.size());
        for (EquivalentAddressGroup lbAddr : newLbAddresses) {
            String lbAddrAuthority = lbAddr.getAttributes().get(GrpclbConstants.ATTR_LB_ADDR_AUTHORITY);
            if (lbAddrAuthority == null) {
                throw new AssertionError((Object)("This is a bug: LB address " + lbAddr + " does not have an authority."));
            }
            Attributes attrs = lbAddr.getAttributes().toBuilder().set(EquivalentAddressGroup.ATTR_AUTHORITY_OVERRIDE, lbAddrAuthority).build();
            overrideAuthorityLbAddresses.add(new EquivalentAddressGroup(lbAddr.getAddresses(), attrs));
        }
        List<EquivalentAddressGroup> newBackendServers = Collections.unmodifiableList(resolvedAddresses.getAddresses());
        GrpclbConfig newConfig = (GrpclbConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        if (newConfig == null) {
            newConfig = DEFAULT_CONFIG;
        }
        if (!this.config.equals(newConfig)) {
            this.config = newConfig;
            this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.INFO, "Config: " + newConfig);
            this.recreateStates();
        }
        this.grpclbState.handleAddresses(Collections.unmodifiableList(overrideAuthorityLbAddresses), newBackendServers);
        return true;
    }

    @Override
    public void requestConnection() {
        if (this.grpclbState != null) {
            this.grpclbState.requestConnection();
        }
    }

    private void resetStates() {
        if (this.grpclbState != null) {
            this.grpclbState.shutdown();
            this.grpclbState = null;
        }
    }

    private void recreateStates() {
        this.resetStates();
        Preconditions.checkState(this.grpclbState == null, "Should've been cleared");
        this.grpclbState = new GrpclbState(this.config, this.helper, this.context, this.subchannelPool, this.time, this.stopwatch, this.backoffPolicyProvider);
    }

    @Override
    public void shutdown() {
        this.resetStates();
    }

    @Override
    public void handleNameResolutionError(Status error) {
        if (this.grpclbState != null) {
            this.grpclbState.propagateError(error);
        }
    }

    @Override
    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    @Nullable
    @VisibleForTesting
    GrpclbState getGrpclbState() {
        return this.grpclbState;
    }
}

