/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.net.impl;

import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kyuubi.shade.io.netty.bootstrap.ServerBootstrap;
import org.apache.kyuubi.shade.io.netty.buffer.PooledByteBufAllocator;
import org.apache.kyuubi.shade.io.netty.channel.Channel;
import org.apache.kyuubi.shade.io.netty.channel.ChannelFuture;
import org.apache.kyuubi.shade.io.netty.channel.ChannelOption;
import org.apache.kyuubi.shade.io.netty.channel.EventLoop;
import org.apache.kyuubi.shade.io.netty.util.concurrent.GenericFutureListener;
import org.apache.kyuubi.shade.io.vertx.core.Closeable;
import org.apache.kyuubi.shade.io.vertx.core.Context;
import org.apache.kyuubi.shade.io.vertx.core.Future;
import org.apache.kyuubi.shade.io.vertx.core.Handler;
import org.apache.kyuubi.shade.io.vertx.core.Promise;
import org.apache.kyuubi.shade.io.vertx.core.buffer.impl.PartialPooledByteBufAllocator;
import org.apache.kyuubi.shade.io.vertx.core.impl.ContextInternal;
import org.apache.kyuubi.shade.io.vertx.core.impl.VertxInternal;
import org.apache.kyuubi.shade.io.vertx.core.impl.future.PromiseInternal;
import org.apache.kyuubi.shade.io.vertx.core.impl.logging.Logger;
import org.apache.kyuubi.shade.io.vertx.core.impl.logging.LoggerFactory;
import org.apache.kyuubi.shade.io.vertx.core.net.NetServerOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.SocketAddress;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.AsyncResolveConnectHelper;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.NetServerImpl;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.SSLHelper;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.ServerChannelLoadBalancer;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.ServerID;
import org.apache.kyuubi.shade.io.vertx.core.spi.metrics.MetricsProvider;
import org.apache.kyuubi.shade.io.vertx.core.spi.metrics.TCPMetrics;

public abstract class TCPServerBase
implements Closeable,
MetricsProvider {
    private static final Logger log = LoggerFactory.getLogger(NetServerImpl.class);
    protected final Context creatingContext;
    protected final VertxInternal vertx;
    protected final NetServerOptions options;
    private EventLoop eventLoop;
    private Handler<Channel> worker;
    private volatile boolean listening;
    private ContextInternal listenContext;
    private TCPServerBase actualServer;
    private SSLHelper sslHelper;
    private ServerChannelLoadBalancer channelBalancer;
    private org.apache.kyuubi.shade.io.netty.util.concurrent.Future<Channel> bindFuture;
    private Set<TCPServerBase> servers;
    private TCPMetrics<?> metrics;
    private volatile int actualPort;

    public TCPServerBase(VertxInternal vertx, NetServerOptions options) {
        this.vertx = vertx;
        this.options = new NetServerOptions(options);
        this.creatingContext = vertx.getContext();
    }

    public int actualPort() {
        TCPServerBase server = this.actualServer;
        return server != null ? server.actualPort : this.actualPort;
    }

    protected abstract Handler<Channel> childHandler(ContextInternal var1, SocketAddress var2, SSLHelper var3);

    protected SSLHelper createSSLHelper() {
        return new SSLHelper(this.options, this.options.getKeyCertOptions(), this.options.getTrustOptions());
    }

    public synchronized SSLHelper sslHelper() {
        return this.sslHelper;
    }

    public Future<TCPServerBase> bind(SocketAddress address) {
        ContextInternal listenContext = this.vertx.getOrCreateContext();
        org.apache.kyuubi.shade.io.netty.util.concurrent.Future<Channel> bindFuture = this.listen(address, listenContext);
        PromiseInternal promise = listenContext.promise();
        bindFuture.addListener(res -> {
            if (res.isSuccess()) {
                promise.complete(this);
            } else {
                promise.fail(res.cause());
            }
        });
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized org.apache.kyuubi.shade.io.netty.util.concurrent.Future<Channel> listen(SocketAddress localAddress, ContextInternal context) {
        Map<ServerID, ?> sharedNetServers;
        if (this.listening) {
            throw new IllegalStateException("Listen already called");
        }
        this.listenContext = context;
        this.listening = true;
        this.eventLoop = context.nettyEventLoop();
        Map<ServerID, ?> map = sharedNetServers = this.vertx.sharedTCPServers(this.getClass());
        synchronized (map) {
            SocketAddress bindAddress;
            boolean shared;
            TCPServerBase main;
            ServerID id;
            String hostOrPath;
            this.actualPort = localAddress.port();
            String string = hostOrPath = localAddress.isInetSocket() ? localAddress.host() : localAddress.path();
            if (this.actualPort > 0 || localAddress.isDomainSocket()) {
                id = new ServerID(this.actualPort, hostOrPath);
                main = (TCPServerBase)sharedNetServers.get(id);
                shared = true;
                bindAddress = localAddress;
            } else if (this.actualPort < 0) {
                id = new ServerID(this.actualPort, hostOrPath + "/" + -this.actualPort);
                main = (TCPServerBase)sharedNetServers.get(id);
                shared = true;
                bindAddress = SocketAddress.inetSocketAddress(0, localAddress.host());
            } else {
                id = new ServerID(this.actualPort, hostOrPath);
                main = null;
                shared = false;
                bindAddress = localAddress;
            }
            if (main == null) {
                try {
                    this.sslHelper = this.createSSLHelper();
                    this.sslHelper.validate(this.vertx);
                    this.worker = this.childHandler(this.listenContext, localAddress, this.sslHelper);
                    this.servers = new HashSet<TCPServerBase>();
                    this.servers.add(this);
                    this.channelBalancer = new ServerChannelLoadBalancer(this.vertx.getAcceptorEventLoopGroup().next());
                    this.channelBalancer.addWorker(this.eventLoop, this.worker);
                    ServerBootstrap bootstrap = new ServerBootstrap();
                    bootstrap.group(this.vertx.getAcceptorEventLoopGroup(), this.channelBalancer.workers());
                    if (this.sslHelper.isSSL()) {
                        bootstrap.childOption(ChannelOption.ALLOCATOR, PartialPooledByteBufAllocator.INSTANCE);
                    } else {
                        bootstrap.childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
                    }
                    bootstrap.childHandler(this.channelBalancer);
                    this.applyConnectionOptions(localAddress.isDomainSocket(), bootstrap);
                    this.bindFuture = AsyncResolveConnectHelper.doBind(this.vertx, bindAddress, bootstrap);
                    this.bindFuture.addListener(res -> {
                        if (res.isSuccess()) {
                            Channel ch = (Channel)res.getNow();
                            log.trace("Net server listening on " + hostOrPath + ":" + ch.localAddress());
                            if (shared) {
                                ch.closeFuture().addListener(channelFuture -> {
                                    Map map = sharedNetServers;
                                    synchronized (map) {
                                        sharedNetServers.remove(id);
                                    }
                                });
                            }
                            if (bindAddress.isInetSocket()) {
                                this.actualPort = ((InetSocketAddress)ch.localAddress()).getPort();
                            }
                            this.listenContext.addCloseHook(this);
                            this.metrics = this.createMetrics(localAddress);
                        } else {
                            if (shared) {
                                Map map = sharedNetServers;
                                synchronized (map) {
                                    sharedNetServers.remove(id);
                                }
                            }
                            this.listening = false;
                        }
                    });
                }
                catch (Throwable t) {
                    this.listening = false;
                    return this.vertx.getAcceptorEventLoopGroup().next().newFailedFuture(t);
                }
                if (shared) {
                    sharedNetServers.put(id, this);
                }
                this.actualServer = this;
            } else {
                this.actualServer = main;
                this.metrics = main.metrics;
                this.sslHelper = main.sslHelper;
                this.worker = this.childHandler(this.listenContext, localAddress, this.sslHelper);
                this.actualServer.servers.add(this);
                this.actualServer.channelBalancer.addWorker(this.eventLoop, this.worker);
                this.listenContext.addCloseHook(this);
            }
        }
        return this.actualServer.bindFuture;
    }

    public boolean isListening() {
        return this.listening;
    }

    protected TCPMetrics<?> createMetrics(SocketAddress localAddress) {
        return null;
    }

    private void applyConnectionOptions(boolean domainSocket, ServerBootstrap bootstrap) {
        this.vertx.transport().configure(this.options, domainSocket, bootstrap);
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public synchronized TCPMetrics<?> getMetrics() {
        return this.actualServer != null ? this.actualServer.metrics : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(Promise<Void> completion) {
        Map<ServerID, ?> servers;
        if (!this.listening) {
            completion.complete();
            return;
        }
        this.listening = false;
        this.listenContext.removeCloseHook(this);
        Map<ServerID, ?> map = servers = this.vertx.sharedTCPServers(this.getClass());
        synchronized (map) {
            ServerChannelLoadBalancer balancer = this.actualServer.channelBalancer;
            balancer.removeWorker(this.eventLoop, this.worker);
            if (balancer.hasHandlers()) {
                completion.complete();
            } else {
                this.actualServer.actualClose(completion);
            }
        }
    }

    private void actualClose(Promise<Void> done) {
        this.channelBalancer.close();
        this.bindFuture.addListener(fut -> {
            if (fut.isSuccess()) {
                Channel channel = (Channel)fut.getNow();
                ChannelFuture a = channel.close();
                if (this.metrics != null) {
                    a.addListener((GenericFutureListener<? extends org.apache.kyuubi.shade.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<org.apache.kyuubi.shade.io.netty.util.concurrent.Future>)cg -> this.metrics.close()));
                }
                a.addListener((PromiseInternal)done);
            } else {
                done.complete();
            }
        });
    }

    public abstract Future<Void> close();
}

