/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.kyuubi.Utils$;
import org.apache.spark.SparkConf;
import org.apache.spark.api.python.Py4JServer;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef;
import scala.Predef$;

public final class KyuubiPythonGatewayServer$
implements Logging {
    public static final KyuubiPythonGatewayServer$ MODULE$ = new KyuubiPythonGatewayServer$();
    private static final String CONNECTION_FILE_PATH;
    private static Py4JServer gatewayServer;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        CONNECTION_FILE_PATH = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2())), "/connection.info");
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String CONNECTION_FILE_PATH() {
        return CONNECTION_FILE_PATH;
    }

    private Py4JServer gatewayServer() {
        return gatewayServer;
    }

    private void gatewayServer_$eq(Py4JServer x$1) {
        gatewayServer = x$1;
    }

    public synchronized void start() {
        block2: {
            SparkConf sparkConf = new SparkConf();
            this.gatewayServer_$eq(new Py4JServer(sparkConf));
            this.gatewayServer().start();
            int boundPort = this.gatewayServer().getListeningPort();
            if (boundPort == -1) {
                this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append(MODULE$.gatewayServer().server().getClass()).append(" failed to bind; exiting").toString());
                System.exit(1);
            } else {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Started PythonGatewayServer on port ").append(boundPort).toString());
            }
            File connectionInfoPath = new File(this.CONNECTION_FILE_PATH());
            File tmpPath = Files.createTempFile(connectionInfoPath.getParentFile().toPath(), "connection", ".info", new FileAttribute[0]).toFile();
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(tmpPath));
            dos.writeInt(boundPort);
            byte[] secretBytes = this.gatewayServer().secret().getBytes(StandardCharsets.UTF_8);
            dos.writeInt(secretBytes.length);
            dos.write(secretBytes, 0, secretBytes.length);
            dos.close();
            if (tmpPath.renameTo(connectionInfoPath)) break block2;
            this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Unable to write connection information to ").append(connectionInfoPath).append(".").toString());
            System.exit(1);
        }
    }

    public synchronized void shutdown() {
        block0: {
            if (this.gatewayServer() == null) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "shutting down the python gateway server.");
            this.gatewayServer().shutdown();
        }
    }

    private KyuubiPythonGatewayServer$() {
    }
}

