/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.net.impl.pool;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.pool.Executor;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.pool.Task;

public class SemaphoreExecutor<S>
implements Executor<S> {
    private final Lock lock = new ReentrantLock();
    private final S state;

    public SemaphoreExecutor(S state) {
        this.state = state;
    }

    @Override
    public void submit(Executor.Action<S> action) {
        this.lock.lock();
        Task post2 = null;
        try {
            post2 = action.execute(this.state);
        }
        finally {
            this.lock.unlock();
            while (post2 != null) {
                post2.run();
                post2 = post2.next();
            }
        }
    }
}

