/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.apache.kyuubi.jdbc.hive.JdbcColumnAttributes;
import org.apache.kyuubi.jdbc.hive.KyuubiResultSetMetaData;
import org.apache.kyuubi.jdbc.hive.KyuubiSQLException;
import org.apache.kyuubi.jdbc.hive.adapter.SQLResultSet;
import org.apache.kyuubi.jdbc.hive.common.HiveIntervalDayTime;
import org.apache.kyuubi.jdbc.hive.common.HiveIntervalYearMonth;
import org.apache.kyuubi.jdbc.hive.common.TimestampTZUtil;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTableSchema;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeId;

public abstract class KyuubiBaseResultSet
implements SQLResultSet {
    protected Statement statement = null;
    protected SQLWarning warningChain = null;
    protected boolean wasNull = false;
    protected Object[] row;
    protected List<String> columnNames;
    protected List<String> normalizedColumnNames;
    protected List<TTypeId> columnTypes;
    protected List<JdbcColumnAttributes> columnAttributes;
    private TTableSchema schema;

    @Override
    public int findColumn(String columnName) throws SQLException {
        int columnIndex = 0;
        if (columnName != null) {
            String lcColumnName = columnName.toLowerCase();
            for (String normalizedColumnName : this.normalizedColumnNames) {
                String name;
                ++columnIndex;
                int idx = normalizedColumnName.lastIndexOf(46);
                String string = name = idx == -1 ? normalizedColumnName : normalizedColumnName.substring(1 + idx);
                if (!name.equals(lcColumnName) && !normalizedColumnName.equals(lcColumnName)) continue;
                return columnIndex;
            }
        }
        throw new KyuubiSQLException("Could not find " + columnName + " in " + this.normalizedColumnNames);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object val = this.getObject(columnIndex);
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        throw new KyuubiSQLException("Illegal conversion to BigDecimal from column " + columnIndex + " [" + val + "]");
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        MathContext mc = new MathContext(scale);
        return this.getBigDecimal(columnIndex).round(mc);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof InputStream) {
            return (InputStream)obj;
        }
        if (obj instanceof byte[]) {
            byte[] byteArray = (byte[])obj;
            return new ByteArrayInputStream(byteArray);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
        }
        throw new KyuubiSQLException("Illegal conversion to binary stream from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        if (obj instanceof String) {
            return !"0".equals(obj);
        }
        throw new KyuubiSQLException("Illegal conversion to boolean from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        throw new KyuubiSQLException("Illegal conversion to byte from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof String) {
            try {
                return Date.valueOf((String)obj);
            }
            catch (Exception e) {
                throw new KyuubiSQLException("Illegal conversion to Date from column " + columnIndex + " [" + obj + "]", e);
            }
        }
        throw new KyuubiSQLException("Illegal conversion to Date from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date value = this.getDate(columnIndex);
        if (value == null) {
            return null;
        }
        try {
            return this.parseDate(value, cal);
        }
        catch (IllegalArgumentException e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to date: " + e, e);
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    private Date parseDate(Date value, Calendar cal) {
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.setTime(value);
        return new Date(cal.getTimeInMillis());
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof String) {
            try {
                return Double.parseDouble((String)obj);
            }
            catch (Exception e) {
                throw new KyuubiSQLException("Illegal conversion to double from column " + columnIndex + " [" + obj + "]", e);
            }
        }
        throw new KyuubiSQLException("Illegal conversion to double from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        if (obj instanceof String) {
            try {
                return Float.parseFloat((String)obj);
            }
            catch (Exception e) {
                throw new KyuubiSQLException("Illegal conversion to float from column " + columnIndex + " [" + obj + "]", e);
            }
        }
        throw new KyuubiSQLException("Illegal conversion to float from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (Exception e) {
                throw new KyuubiSQLException("Illegal conversion to int from column " + columnIndex + " [" + obj + "]", e);
            }
        }
        throw new KyuubiSQLException("Illegal conversion to int from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            try {
                return Long.parseLong((String)obj);
            }
            catch (Exception e) {
                throw new KyuubiSQLException("Illegal conversion to long from column " + columnIndex + " [" + obj + "]", e);
            }
        }
        throw new KyuubiSQLException("Illegal conversion to long from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new KyuubiResultSetMetaData(this.columnNames, this.columnTypes, this.columnAttributes);
    }

    private Object getColumnValue(int columnIndex) throws SQLException {
        if (this.row == null) {
            throw new KyuubiSQLException("No row found");
        }
        if (this.row.length == 0) {
            throw new KyuubiSQLException("RowSet does not contain any columns");
        }
        if (columnIndex <= 0 || columnIndex > this.row.length) {
            throw new KyuubiSQLException("Invalid columnIndex: " + columnIndex);
        }
        TTypeId columnType = this.columnTypes.get(columnIndex - 1);
        Object value = this.row[columnIndex - 1];
        try {
            Object evaluated = this.evaluate(columnType, value);
            this.wasNull = evaluated == null;
            return evaluated;
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Failed to evaluate " + columnType + " [" + value + "]", e);
        }
    }

    private Object evaluate(TTypeId columnType, Object value) {
        if (value == null) {
            return null;
        }
        switch (columnType) {
            case BINARY_TYPE: {
                if (value instanceof String) {
                    return ((String)value).getBytes(StandardCharsets.UTF_8);
                }
                return value;
            }
            case TIMESTAMP_TYPE: {
                return Timestamp.valueOf((String)value);
            }
            case TIMESTAMPLOCALTZ_TYPE: {
                return TimestampTZUtil.parse((String)value);
            }
            case DECIMAL_TYPE: {
                return new BigDecimal((String)value);
            }
            case DATE_TYPE: {
                return Date.valueOf((String)value);
            }
            case INTERVAL_YEAR_MONTH_TYPE: {
                return HiveIntervalYearMonth.valueOf((String)value);
            }
            case INTERVAL_DAY_TIME_TYPE: {
                return HiveIntervalDayTime.valueOf((String)value);
            }
            case ARRAY_TYPE: 
            case MAP_TYPE: 
            case STRUCT_TYPE: {
                return value;
            }
        }
        return value;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getColumnValue(columnIndex);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            try {
                return Short.parseShort((String)obj);
            }
            catch (Exception e) {
                throw new KyuubiSQLException("Illegal conversion to int from column " + columnIndex + " [" + obj + "]", e);
            }
        }
        throw new KyuubiSQLException("Illegal conversion to int from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object value = this.getColumnValue(columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return new String((byte[])value, StandardCharsets.UTF_8);
        }
        return value.toString();
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        if (obj instanceof String) {
            try {
                return Timestamp.valueOf((String)obj);
            }
            catch (Exception e) {
                throw new KyuubiSQLException("Illegal conversion to int from column " + columnIndex + " [" + obj + "]", e);
            }
        }
        throw new KyuubiSQLException("Illegal conversion to int from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp value = this.getTimestamp(columnIndex);
        if (value == null) {
            return null;
        }
        try {
            return this.parseTimestamp(value, cal);
        }
        catch (IllegalArgumentException e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to timestamp: " + e, e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    private Timestamp parseTimestamp(Timestamp timestamp, Calendar cal) {
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        long v = timestamp.getTime();
        cal.setTimeInMillis(v);
        timestamp = new Timestamp(cal.getTime().getTime());
        return timestamp;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Time) {
            return (Time)obj;
        }
        if (obj instanceof String) {
            return Time.valueOf((String)obj);
        }
        throw new KyuubiSQLException("Illegal conversion");
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time value = this.getTime(columnIndex);
        if (value == null) {
            return null;
        }
        try {
            return this.parseTime(value, cal);
        }
        catch (IllegalArgumentException e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to time: " + e, e);
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    private Time parseTime(Time date, Calendar cal) {
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        long v = date.getTime();
        cal.setTimeInMillis(v);
        date = new Time(cal.getTime().getTime());
        return date;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    protected void setSchema(TTableSchema schema) {
        this.schema = schema;
    }

    protected TTableSchema getSchema() {
        return this.schema;
    }
}

