/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.net;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import org.apache.kyuubi.shade.io.vertx.core.json.JsonArray;
import org.apache.kyuubi.shade.io.vertx.core.json.JsonObject;
import org.apache.kyuubi.shade.io.vertx.core.json.impl.JsonUtil;
import org.apache.kyuubi.shade.io.vertx.core.net.ClientOptionsBase;
import org.apache.kyuubi.shade.io.vertx.core.net.ProxyOptions;

public class ClientOptionsBaseConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, ClientOptionsBase obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "connectTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setConnectTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "localAddress": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setLocalAddress((String)member.getValue());
                    break;
                }
                case "metricsName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMetricsName((String)member.getValue());
                    break;
                }
                case "nonProxyHosts": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setNonProxyHosts(list);
                    break;
                }
                case "proxyOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setProxyOptions(new ProxyOptions((JsonObject)member.getValue()));
                    break;
                }
                case "trustAll": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTrustAll((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(ClientOptionsBase obj, JsonObject json) {
        ClientOptionsBaseConverter.toJson(obj, json.getMap());
    }

    static void toJson(ClientOptionsBase obj, Map<String, Object> json) {
        json.put("connectTimeout", obj.getConnectTimeout());
        if (obj.getLocalAddress() != null) {
            json.put("localAddress", obj.getLocalAddress());
        }
        if (obj.getMetricsName() != null) {
            json.put("metricsName", obj.getMetricsName());
        }
        if (obj.getNonProxyHosts() != null) {
            JsonArray array = new JsonArray();
            obj.getNonProxyHosts().forEach(item -> array.add(item));
            json.put("nonProxyHosts", array);
        }
        if (obj.getProxyOptions() != null) {
            json.put("proxyOptions", obj.getProxyOptions().toJson());
        }
        json.put("trustAll", obj.isTrustAll());
    }
}

