/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.async.logger;

import org.apache.logging.log4j.async.logger.AsyncLoggerConfigExceptionHandler;
import org.apache.logging.log4j.async.logger.AsyncLoggerExceptionHandler;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.kit.env.Log4jProperty;
import org.apache.logging.log4j.status.StatusLogger;
import org.jspecify.annotations.Nullable;

@Log4jProperty(name="async.logger")
public record AsyncLoggerProperties(@Nullable Class<? extends AsyncLoggerConfigExceptionHandler> configExceptionHandler, @Nullable Class<? extends AsyncLoggerExceptionHandler> exceptionHandler, RingBufferProperties ringBuffer, @Log4jProperty(defaultValue="true") boolean synchronizeEnqueueWhenQueueFull, WaitStrategyProperties waitStrategy) {

    public record RingBufferProperties(@Log4jProperty(defaultValue="4096") int size) {
        private static final int RING_BUFFER_MIN_SIZE = 128;

        public RingBufferProperties(@Log4jProperty(defaultValue="4096") int size) {
            this.size = size = RingBufferProperties.validateRingBufferSize(size);
        }

        private static int validateRingBufferSize(int size) {
            if (size < 128) {
                StatusLogger.getLogger().warn("Invalid RingBuffer size {}, using minimum size {}.", (Object)size, (Object)128);
                return 128;
            }
            int roundedSize = Integers.ceilingNextPowerOfTwo((int)size);
            if (size != roundedSize) {
                StatusLogger.getLogger().warn("Invalid RingBuffer size {}, using rounded size {}.", (Object)size, (Object)roundedSize);
            }
            return roundedSize;
        }
    }

    public record WaitStrategyProperties(@Log4jProperty(defaultValue="200") int retries, @Log4jProperty(defaultValue="100") long sleepTimeNs, @Log4jProperty(defaultValue="10") int timeout, @Log4jProperty(defaultValue="TIMEOUT") String type) {
    }
}

