/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import aQute.bnd.annotation.spi.ServiceConsumer;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.LoggerContextAwarePostProcessor;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.URIConfigurationFactory;
import org.apache.logging.log4j.core.impl.CoreProperties;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.ExecutorServices;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.kit.env.internal.ContextualEnvironmentPropertySource;
import org.apache.logging.log4j.kit.env.internal.ContextualJavaPropsPropertySource;
import org.apache.logging.log4j.kit.env.support.CompositePropertyEnvironment;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.plugins.di.InstanceFactory;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.di.spi.ConfigurableInstanceFactoryPostProcessor;
import org.apache.logging.log4j.plugins.di.spi.InstancePostProcessor;
import org.apache.logging.log4j.plugins.util.OrderedComparator;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.spi.LoggerContextShutdownAware;
import org.apache.logging.log4j.spi.LoggerContextShutdownEnabled;
import org.apache.logging.log4j.spi.LoggerRegistry;
import org.apache.logging.log4j.spi.Terminable;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.ServiceLoaderUtil;
import org.jspecify.annotations.Nullable;

@ServiceConsumer(value=ConfigurableInstanceFactoryPostProcessor.class, cardinality="multiple")
public class LoggerContext
extends AbstractLifeCycle
implements org.apache.logging.log4j.spi.LoggerContext,
AutoCloseable,
Terminable,
Consumer<Reconfigurable>,
LoggerContextShutdownEnabled {
    public static final Key<LoggerContext> KEY = Key.forClass(LoggerContext.class);
    private final LoggerRegistry<org.apache.logging.log4j.core.Logger> loggerRegistry = new LoggerRegistry();
    private final MessageFactory defaultMessageFactory;
    private final Collection<Consumer<Configuration>> configurationStartedListeners = new ArrayList<Consumer<Configuration>>();
    private final Collection<Consumer<Configuration>> configurationStoppedListeners = new ArrayList<Consumer<Configuration>>();
    private final Lazy<List<LoggerContextShutdownAware>> listeners = Lazy.lazy(CopyOnWriteArrayList::new);
    private final ConfigurableInstanceFactory instanceFactory;
    private final PropertyEnvironment environment;
    private final ConfigurationScheduler configurationScheduler;
    private volatile Configuration configuration;
    private final Configuration nullConfiguration;
    private static final String EXTERNAL_CONTEXT_KEY = "__EXTERNAL_CONTEXT_KEY__";
    private final ConcurrentMap<String, Object> externalMap = new ConcurrentHashMap<String, Object>();
    private String contextName;
    private volatile URI configLocation;
    private Cancellable shutdownCallback;
    private final Lock configLock = new ReentrantLock();

    public LoggerContext(String name, @Nullable Object externalContext, @Nullable URI configLocation, ConfigurableInstanceFactory instanceFactory) {
        this.contextName = Objects.requireNonNull(name);
        this.instanceFactory = Objects.requireNonNull(instanceFactory);
        this.instanceFactory.registerBinding(KEY, (Supplier)Lazy.weak((Object)this));
        ServiceLoaderUtil.safeStream(ConfigurableInstanceFactoryPostProcessor.class, ServiceLoader.load(ConfigurableInstanceFactoryPostProcessor.class, LoggerContext.class.getClassLoader()), (Logger)LOGGER).sorted(Comparator.comparing(Object::getClass, OrderedComparator.INSTANCE)).forEachOrdered(processor -> processor.postProcessFactory(instanceFactory));
        this.instanceFactory.registerInstancePostProcessor((InstancePostProcessor)new LoggerContextAwarePostProcessor(this));
        if (externalContext != null) {
            this.externalMap.put(EXTERNAL_CONTEXT_KEY, externalContext);
        }
        this.configLocation = configLocation;
        this.environment = (PropertyEnvironment)instanceFactory.getInstance(PropertyEnvironment.class);
        this.configurationScheduler = (ConfigurationScheduler)instanceFactory.getInstance(ConfigurationScheduler.class);
        this.defaultMessageFactory = (MessageFactory)instanceFactory.getInstance(MessageFactory.class);
        this.configuration = new DefaultConfiguration(this);
        this.nullConfiguration = new NullConfiguration(this);
    }

    private static @Nullable URI fileToUri(String fileName) {
        if (fileName != null) {
            try {
                return new File(fileName).toURI();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public LoggerContext(String contextName, Object externalContext, String configLocation, ConfigurableInstanceFactory instanceFactory) {
        this(contextName, externalContext, LoggerContext.fileToUri(configLocation), instanceFactory);
    }

    private void checkMessageFactory(ExtendedLogger logger, MessageFactory messageFactory) {
        String name = logger.getName();
        MessageFactory loggerMessageFactory = logger.getMessageFactory();
        MessageFactory currentMessageFactory = this.defaultMessageFactory;
        if (messageFactory != null && !loggerMessageFactory.equals(messageFactory)) {
            StatusLogger.getLogger().warn("The Logger {} was created with the message factory {} and is now requested with the message factory {}, which may create log events with unexpected formatting.", (Object)name, (Object)loggerMessageFactory, (Object)messageFactory);
        } else if (messageFactory == null && loggerMessageFactory != currentMessageFactory) {
            StatusLogger.getLogger().warn("The Logger {} was created with the message factory {} and is now requested with a null message factory (defaults to {}), which may create log events with unexpected formatting.", (Object)name, (Object)loggerMessageFactory, (Object)currentMessageFactory.getClass().getName());
        }
    }

    public PropertyEnvironment getEnvironment() {
        return this.environment;
    }

    public void addShutdownListener(LoggerContextShutdownAware listener) {
        ((List)this.listeners.get()).add(listener);
    }

    public List<LoggerContextShutdownAware> getListeners() {
        return (List)this.listeners.get();
    }

    public static LoggerContext getContext() {
        org.apache.logging.log4j.spi.LoggerContext context = LogManager.getContext();
        if (context instanceof LoggerContext) {
            LoggerContext ctx = (LoggerContext)context;
            return ctx;
        }
        throw new IllegalStateException("Expected instance of " + LoggerContext.class + " but got " + context.getClass());
    }

    public static LoggerContext getContext(boolean currentContext) {
        org.apache.logging.log4j.spi.LoggerContext context = LogManager.getContext((boolean)currentContext);
        if (context instanceof LoggerContext) {
            LoggerContext ctx = (LoggerContext)context;
            return ctx;
        }
        throw new IllegalStateException("Expected instance of " + LoggerContext.class + " but got " + context.getClass());
    }

    public static LoggerContext getContext(ClassLoader loader, boolean currentContext, URI configLocation) {
        org.apache.logging.log4j.spi.LoggerContext context = LogManager.getContext((ClassLoader)loader, (boolean)currentContext, (URI)configLocation);
        if (context instanceof LoggerContext) {
            LoggerContext ctx = (LoggerContext)context;
            return ctx;
        }
        throw new IllegalStateException("Expected instance of " + LoggerContext.class + " but got " + context.getClass());
    }

    @Override
    public void start() {
        LOGGER.debug("Starting {}...", (Object)this);
        if (((CoreProperties.LoggerContextProperties)this.environment.getProperty(CoreProperties.LoggerContextProperties.class)).stacktraceOnStart()) {
            LOGGER.debug("Stack trace to locate invoker", (Throwable)new Exception("Not a real error, showing stack trace to locate invoker"));
        }
        if (this.configLock.tryLock()) {
            try {
                if (this.isInitialized() || this.isStopped()) {
                    this.setStarting();
                    this.reconfigure();
                    if (this.configuration.isShutdownHookEnabled()) {
                        this.setUpShutdownHook();
                    }
                    this.setStarted();
                }
            }
            finally {
                this.configLock.unlock();
            }
        }
        LOGGER.debug("{} started OK.", (Object)this);
    }

    public void start(Configuration config) {
        LOGGER.info("Starting {}[name={}] with configuration {}...", (Object)this.getClass().getSimpleName(), (Object)this.getName(), (Object)config);
        if (this.configLock.tryLock()) {
            try {
                if (this.isInitialized() || this.isStopped()) {
                    if (config.isShutdownHookEnabled()) {
                        this.setUpShutdownHook();
                    }
                    this.setStarted();
                }
            }
            finally {
                this.configLock.unlock();
            }
        }
        this.setConfiguration(config);
        LOGGER.info("{}[name={}] started with configuration {}.", (Object)this.getClass().getSimpleName(), (Object)this.getName(), (Object)config);
    }

    private void setUpShutdownHook() {
        LoggerContextFactory factory;
        if (this.shutdownCallback == null && (factory = (LoggerContextFactory)this.instanceFactory.getInstance(LoggerContextFactory.class)) instanceof ShutdownCallbackRegistry) {
            LOGGER.debug(ShutdownCallbackRegistry.SHUTDOWN_HOOK_MARKER, "Shutdown hook enabled. Registering a new one.");
            ExecutorServices.ensureInitialized();
            try {
                final long shutdownTimeoutMillis = this.configuration.getShutdownTimeoutMillis();
                this.shutdownCallback = ((ShutdownCallbackRegistry)factory).addShutdownCallback(new Runnable(){

                    @Override
                    public void run() {
                        LoggerContext context = LoggerContext.this;
                        AbstractLifeCycle.LOGGER.debug(ShutdownCallbackRegistry.SHUTDOWN_HOOK_MARKER, "Stopping {}", (Object)context);
                        context.stop(shutdownTimeoutMillis, TimeUnit.MILLISECONDS);
                    }

                    public String toString() {
                        return "Shutdown callback for LoggerContext[name=" + LoggerContext.this.getName() + "]";
                    }
                });
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to register Log4j shutdown hook because JVM is shutting down.", e);
            }
            catch (SecurityException e) {
                LOGGER.error(ShutdownCallbackRegistry.SHUTDOWN_HOOK_MARKER, "Unable to register shutdown hook due to security restrictions", (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    public void terminate() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        LOGGER.debug("Stopping {}...", (Object)this);
        this.configLock.lock();
        try {
            if (this.isStopped()) {
                boolean bl = true;
                return bl;
            }
            this.setStopping();
            if (this.shutdownCallback != null) {
                this.shutdownCallback.cancel();
                this.shutdownCallback = null;
            }
            if (this.configurationScheduler.isStarted()) {
                this.configurationScheduler.stop(timeout, timeUnit);
            }
            Configuration prev = this.configuration;
            this.configuration = this.nullConfiguration;
            this.updateLoggers();
            prev.stop(timeout, timeUnit);
            this.externalMap.clear();
            LogManager.getFactory().removeContext((org.apache.logging.log4j.spi.LoggerContext)this);
        }
        finally {
            this.configLock.unlock();
            this.setStopped();
        }
        if (this.listeners.isInitialized()) {
            ((List)this.listeners.get()).forEach(listener -> {
                try {
                    listener.contextShutdown((org.apache.logging.log4j.spi.LoggerContext)this);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            });
        }
        LOGGER.debug("Stopped {} with status {}", (Object)this, (Object)true);
        return true;
    }

    public String getName() {
        return this.contextName;
    }

    public org.apache.logging.log4j.core.Logger getRootLogger() {
        return this.getLogger("");
    }

    public void setName(String name) {
        this.contextName = Objects.requireNonNull(name);
    }

    public Object getObject(String key) {
        return this.externalMap.get(key);
    }

    public Object putObject(String key, Object value) {
        return this.externalMap.put(key, value);
    }

    public Object putObjectIfAbsent(String key, Object value) {
        return this.externalMap.putIfAbsent(key, value);
    }

    public Object removeObject(String key) {
        return this.externalMap.remove(key);
    }

    public boolean removeObject(String key, Object value) {
        return this.externalMap.remove(key, value);
    }

    public void setExternalContext(Object context) {
        if (context != null) {
            this.externalMap.put(EXTERNAL_CONTEXT_KEY, context);
        } else {
            this.externalMap.remove(EXTERNAL_CONTEXT_KEY);
        }
    }

    public Object getExternalContext() {
        return this.externalMap.get(EXTERNAL_CONTEXT_KEY);
    }

    public org.apache.logging.log4j.core.Logger getLogger(String name) {
        return this.getLogger(name, this.defaultMessageFactory);
    }

    public Collection<org.apache.logging.log4j.core.Logger> getLoggers() {
        return this.loggerRegistry.getLoggers();
    }

    public org.apache.logging.log4j.core.Logger getLogger(String name, MessageFactory messageFactory) {
        MessageFactory actualMessageFactory = messageFactory != null ? messageFactory : this.defaultMessageFactory;
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)this.loggerRegistry.getLogger(name, actualMessageFactory);
        if (logger != null) {
            this.checkMessageFactory((ExtendedLogger)logger, actualMessageFactory);
            return logger;
        }
        logger = this.newLogger(name, actualMessageFactory);
        this.loggerRegistry.putIfAbsent(name, logger.getMessageFactory(), (ExtendedLogger)logger);
        return (org.apache.logging.log4j.core.Logger)this.loggerRegistry.getLogger(name, logger.getMessageFactory());
    }

    public LoggerRegistry<org.apache.logging.log4j.core.Logger> getLoggerRegistry() {
        return this.loggerRegistry;
    }

    public InstanceFactory getInstanceFactory() {
        return this.instanceFactory;
    }

    public boolean hasLogger(String name) {
        return this.loggerRegistry.hasLogger(name, this.defaultMessageFactory);
    }

    public boolean hasLogger(String name, MessageFactory messageFactory) {
        return this.loggerRegistry.hasLogger(name, messageFactory);
    }

    public boolean hasLogger(String name, Class<? extends MessageFactory> messageFactoryClass) {
        return this.loggerRegistry.hasLogger(name, messageFactoryClass);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Configuration getConfiguration(ConfigurationSource source) {
        return this.getConfigurationFactory().getConfiguration(this, source);
    }

    public Configuration getConfiguration(String name, URI configLocation) {
        return this.getConfigurationFactory().getConfiguration(this, name, configLocation);
    }

    public Configuration getConfiguration(String name, URI configLocation, ClassLoader loader) {
        return this.getConfigurationFactory().getConfiguration(this, name, configLocation, loader);
    }

    private URIConfigurationFactory getConfigurationFactory() {
        return (URIConfigurationFactory)this.instanceFactory.getInstance(URIConfigurationFactory.KEY);
    }

    public void addFilter(Filter filter) {
        this.configuration.addFilter(filter);
    }

    public void removeFilter(Filter filter) {
        this.configuration.removeFilter(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration setConfiguration(Configuration config) {
        if (config == null) {
            LOGGER.error("No configuration found for context '{}'.", (Object)this.contextName);
            return this.configuration;
        }
        this.configLock.lock();
        try {
            Configuration prev = this.configuration;
            config.addListener(this);
            ConcurrentMap map = (ConcurrentMap)config.getComponent("ContextProperties");
            try {
                map.computeIfAbsent("hostName", s -> NetUtils.getLocalHostname());
            }
            catch (Exception ex) {
                LOGGER.debug("Ignoring {}, setting hostName to 'unknown'", (Object)ex.toString());
                map.putIfAbsent("hostName", "unknown");
            }
            map.putIfAbsent("contextName", this.contextName);
            config.start();
            this.configuration = config;
            this.updateLoggers();
            if (prev != null) {
                prev.removeListener(this);
                prev.stop();
                this.notifyConfigurationStopped(prev);
            }
            Configuration configuration = prev;
            return configuration;
        }
        finally {
            this.configLock.unlock();
        }
    }

    public void addConfigurationStartedListener(Consumer<Configuration> listener) {
        this.configLock.lock();
        try {
            this.configurationStartedListeners.add(listener);
        }
        finally {
            this.configLock.unlock();
        }
    }

    public void removeConfigurationStartedListener(Consumer<Configuration> listener) {
        this.configLock.lock();
        try {
            this.configurationStartedListeners.remove(listener);
        }
        finally {
            this.configLock.unlock();
        }
    }

    private void notifyConfigurationStarted(Configuration configuration) {
        for (Consumer<Configuration> listener : this.configurationStartedListeners) {
            try {
                listener.accept(configuration);
            }
            catch (Throwable t) {
                LOGGER.error("Caught exception while notifying listener {} of configuration start {}", listener, (Object)configuration, (Object)t);
            }
        }
    }

    public void addConfigurationStoppedListener(Consumer<Configuration> listener) {
        this.configLock.lock();
        try {
            this.configurationStoppedListeners.add(listener);
        }
        finally {
            this.configLock.unlock();
        }
    }

    public void removeConfigurationStoppedListener(Consumer<Configuration> listener) {
        this.configLock.lock();
        try {
            this.configurationStoppedListeners.remove(listener);
        }
        finally {
            this.configLock.unlock();
        }
    }

    private void notifyConfigurationStopped(Configuration configuration) {
        for (Consumer<Configuration> listener : this.configurationStoppedListeners) {
            try {
                listener.accept(configuration);
            }
            catch (Throwable t) {
                LOGGER.error("Caught exception while notifying listener {} of configuration stop {}", listener, (Object)configuration, (Object)t);
            }
        }
    }

    public URI getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(URI configLocation) {
        this.configLocation = configLocation;
        this.reconfigure(configLocation);
    }

    private void reconfigure(URI configURI) {
        Object externalContext = this.externalMap.get(EXTERNAL_CONTEXT_KEY);
        ClassLoader cl = externalContext instanceof ClassLoader ? (ClassLoader)externalContext : null;
        LOGGER.debug("Reconfiguration started for context[name={}] at URI {} ({}) with optional ClassLoader: {}", (Object)this.contextName, (Object)configURI, (Object)this, (Object)cl);
        Configuration instance = this.getConfiguration(this.contextName, configURI, cl);
        if (instance == null) {
            LOGGER.error("Reconfiguration failed: No configuration found for '{}' at '{}' in '{}'", (Object)this.contextName, (Object)configURI, (Object)cl);
        } else {
            this.setConfiguration(instance);
            String location = this.configuration == null ? "?" : String.valueOf(this.configuration.getConfigurationSource());
            LOGGER.debug("Reconfiguration complete for {} at URI {} with optional ClassLoader: {}", (Object)this, (Object)location, (Object)cl);
        }
    }

    public void reconfigure() {
        this.reconfigure(this.configLocation);
    }

    public void reconfigure(Configuration configuration) {
        URI uri;
        this.setConfiguration(configuration);
        ConfigurationSource source = configuration.getConfigurationSource();
        if (source != null && (uri = source.getURI()) != null) {
            this.configLocation = uri;
        }
    }

    public void updateLoggers() {
        this.updateLoggers(this.configuration);
    }

    public void updateLoggers(Configuration config) {
        for (org.apache.logging.log4j.core.Logger logger : this.loggerRegistry.getLoggers()) {
            logger.updateConfiguration(config);
        }
        this.notifyConfigurationStarted(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Reconfigurable reconfigurable) {
        this.configLock.lock();
        try {
            long startMillis = System.currentTimeMillis();
            LOGGER.debug("Reconfiguration started for context {} ({})", (Object)this.contextName, (Object)this);
            ThreadContext.init();
            Configuration newConfig = reconfigurable.reconfigure();
            if (newConfig != null) {
                this.setConfiguration(newConfig);
                LOGGER.debug("Reconfiguration completed for {} ({}) in {} milliseconds.", (Object)this.contextName, (Object)this, (Object)(System.currentTimeMillis() - startMillis));
            } else {
                LOGGER.debug("Reconfiguration failed for {} ({}) in {} milliseconds.", (Object)this.contextName, (Object)this, (Object)(System.currentTimeMillis() - startMillis));
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    public String toString() {
        return "LoggerContext[" + this.contextName + "]";
    }

    protected Class<? extends Logger.Builder> getLoggerBuilderClass() {
        return Logger.Builder.class;
    }

    private org.apache.logging.log4j.core.Logger newLogger(String name, MessageFactory messageFactory) {
        return ((Logger.Builder)this.instanceFactory.getInstance(this.getLoggerBuilderClass())).setName(name).setMessageFactory(messageFactory).build();
    }

    public boolean includeLocation() {
        return true;
    }

    public static class Builder {
        private final ConfigurableInstanceFactory parentInstanceFactory;
        private String contextName;
        private @Nullable URI configLocation;
        private ClassLoader loader = LoggerContext.class.getClassLoader();

        @Inject
        public Builder(ConfigurableInstanceFactory parentInstanceFactory) {
            this.parentInstanceFactory = parentInstanceFactory;
        }

        private PropertyEnvironment createProperties(String contextName, ClassLoader loader) {
            PropertyEnvironment parentEnvironment = (PropertyEnvironment)this.parentInstanceFactory.getInstance(PropertyEnvironment.class);
            Logger statusLogger = (Logger)this.parentInstanceFactory.getInstance(Constants.STATUS_LOGGER_KEY);
            return new CompositePropertyEnvironment(parentEnvironment, List.of(new ContextualJavaPropsPropertySource(contextName), new ContextualEnvironmentPropertySource(contextName)), loader, statusLogger);
        }

        private ConfigurableInstanceFactory createInstanceFactory(PropertyEnvironment environment, ClassLoader loader) {
            return this.parentInstanceFactory.newChildInstanceFactory(() -> environment, () -> loader);
        }

        protected String getContextName() {
            return this.contextName;
        }

        public Builder setContextName(String contextName) {
            this.contextName = contextName;
            return this;
        }

        protected @Nullable URI getConfigLocation() {
            return this.configLocation;
        }

        public Builder setConfigLocation(URI configLocation) {
            this.configLocation = configLocation;
            return this;
        }

        public Builder setLoader(ClassLoader loader) {
            this.loader = loader;
            return this;
        }

        protected ConfigurableInstanceFactory createInstanceFactory() {
            return this.createInstanceFactory(this.createProperties(this.contextName, this.loader), this.loader);
        }

        public LoggerContext build() {
            return new LoggerContext(this.getContextName(), null, this.getConfigLocation(), this.createInstanceFactory());
        }
    }
}

