/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.impl.CoreProperties;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.PasswordDecryptor;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;

public class BasicAuthorizationProvider
implements AuthorizationProvider {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Base64.Encoder encoder = Base64.getEncoder();
    private String authString = null;

    public BasicAuthorizationProvider(CoreProperties.BasicAuthenticationProperties props) {
        String password = props.password();
        if (props.passwordDecryptor() != null) {
            try {
                PasswordDecryptor decryptor = (PasswordDecryptor)LoaderUtil.newInstanceOf(props.passwordDecryptor());
                password = decryptor.decryptPassword(password);
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to decrypt password.", (Throwable)ex);
            }
        }
        if (props.username() != null && password != null) {
            this.authString = "Basic " + encoder.encodeToString((props.username() + ":" + password).getBytes(StandardCharsets.UTF_8));
        }
    }

    @Override
    public void addAuthorization(URLConnection urlConnection) {
        if (this.authString != null) {
            urlConnection.setRequestProperty("Authorization", this.authString);
        }
    }
}

