/* ====================================================================
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 * ====================================================================
 */

package org.apache.pylucene.store;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.apache.pylucene.ref.PythonObject;
import org.apache.pylucene.ref.PythonObjectManager;

public class PythonIndexOutput extends IndexOutput {

    private PythonObject pythonObject;

    public PythonIndexOutput(String resourceDescription, String name)
    {
        super(resourceDescription, name);
    }

    public void pythonExtension(long pythonObject)
    {
        this.pythonObject = PythonObjectManager.register(pythonObject);
    }
    public long pythonExtension()
    {
        return this.pythonObject.pythonObject;
    }

    @Override
    public native long getFilePointer();
    @Override
    public native long getChecksum()
        throws IOException;
    @Override
    public native void close()
        throws IOException;
    @Override
    public native void writeByte(byte b)
        throws IOException;

    public native void writeBytes(byte[] bytes)
        throws IOException;

    @Override
    public void writeBytes(byte[] bytes, int offset, int length)
        throws IOException
    {
        if (offset > 0 || length < bytes.length)
        {
            byte[] data = new byte[length];

            System.arraycopy(bytes, offset, data, 0, length);
            writeBytes(data);
        }
        else
            writeBytes(bytes);
    }
}
