/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.DocumentReader$End;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.DocumentReader$Entry;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.DocumentReader$Start;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.DocumentReader$Text;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.EventNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.EventReader;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.NodeExtractor;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.NodeStack;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class DocumentReader
implements EventReader {
    private static final String RESERVED = "xml";
    private NodeExtractor queue;
    private NodeStack stack;
    private EventNode peek;

    public DocumentReader(Document document) {
        this.queue = new NodeExtractor(document);
        this.stack = new NodeStack();
        this.stack.push(document);
    }

    @Override
    public EventNode peek() {
        if (this.peek == null) {
            this.peek = this.next();
        }
        return this.peek;
    }

    @Override
    public EventNode next() {
        EventNode eventNode = this.peek;
        if (eventNode == null) {
            eventNode = this.read();
        } else {
            this.peek = null;
        }
        return eventNode;
    }

    private EventNode read() {
        Node node = (Node)this.queue.peek();
        if (node == null) {
            return this.end();
        }
        return this.read(node);
    }

    private EventNode read(Node node) {
        Node node2;
        Node node3 = node.getParentNode();
        if (node3 != (node2 = (Node)this.stack.top())) {
            if (node2 != null) {
                this.stack.pop();
            }
            return this.end();
        }
        if (node != null) {
            this.queue.poll();
        }
        return this.convert(node);
    }

    private EventNode convert(Node node) {
        short s = node.getNodeType();
        if (s == 1) {
            if (node != null) {
                this.stack.push(node);
            }
            return this.start(node);
        }
        return this.text(node);
    }

    private DocumentReader$Start start(Node node) {
        DocumentReader$Start documentReader$Start = new DocumentReader$Start(node);
        if (documentReader$Start.isEmpty()) {
            return this.build(documentReader$Start);
        }
        return documentReader$Start;
    }

    private DocumentReader$Start build(DocumentReader$Start documentReader$Start) {
        NamedNodeMap namedNodeMap = documentReader$Start.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = namedNodeMap.item(i);
            DocumentReader$Entry documentReader$Entry = this.attribute(node);
            if (documentReader$Entry.isReserved()) continue;
            documentReader$Start.add(documentReader$Entry);
        }
        return documentReader$Start;
    }

    private DocumentReader$Entry attribute(Node node) {
        return new DocumentReader$Entry(node);
    }

    private DocumentReader$Text text(Node node) {
        return new DocumentReader$Text(node);
    }

    private DocumentReader$End end() {
        return new DocumentReader$End(null);
    }
}

