/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import org.apache.solr.client.solrj.request.CollectionApiMapping;
import org.apache.solr.handler.admin.BaseHandlerApiSupport;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class CollectionHandlerApi
extends BaseHandlerApiSupport {
    final CollectionsHandler handler;
    static Collection<BaseHandlerApiSupport.ApiCommand> apiCommands = CollectionHandlerApi.createCollMapping();

    private static Collection<BaseHandlerApiSupport.ApiCommand> createCollMapping() {
        EnumMap<CollectionApiMapping.Meta, 1> result = new EnumMap<CollectionApiMapping.Meta, 1>(CollectionApiMapping.Meta.class);
        for (final CollectionApiMapping.Meta meta : CollectionApiMapping.Meta.values()) {
            for (final CollectionsHandler.CollectionOperation op : CollectionsHandler.CollectionOperation.values()) {
                if (op.action != meta.action) continue;
                result.put(meta, new BaseHandlerApiSupport.ApiCommand(){

                    @Override
                    public CollectionApiMapping.CommandMeta meta() {
                        return meta;
                    }

                    @Override
                    public void invoke(SolrQueryRequest req, SolrQueryResponse rsp, BaseHandlerApiSupport apiHandler) throws Exception {
                        ((CollectionHandlerApi)apiHandler).handler.invokeAction(req, rsp, ((CollectionHandlerApi)apiHandler).handler.coreContainer, op.action, op);
                    }
                });
            }
        }
        return result.values();
    }

    public CollectionHandlerApi(CollectionsHandler handler) {
        this.handler = handler;
    }

    @Override
    protected Collection<BaseHandlerApiSupport.ApiCommand> getCommands() {
        return apiCommands;
    }

    protected List<CollectionApiMapping.V2EndPoint> getEndPoints() {
        return Arrays.asList(CollectionApiMapping.EndPoint.values());
    }
}

