/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.util;

import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.SGTypes;
import org.exolab.javasource.JAnnotation;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class DescriptorJClass
extends JClass {
    private static final JClass _ClassDescriptorClass = new JClass("org.exolab.castor.mapping.ClassDescriptor");
    private static final JClass _FieldDescriptorClass = new JClass("org.exolab.castor.mapping.FieldDescriptor");
    private static final JClass _XMLFieldDescriptorClass = new JClass("org.exolab.castor.xml.XMLFieldDescriptor");
    private static final JType _TypeValidatorClass = new JClass("org.exolab.castor.xml.TypeValidator");
    private JMethod _getElementDefinition = null;
    private JMethod _getNameSpacePrefix = null;
    private JMethod _getNameSpaceURI = null;
    private JMethod _getXMLName = null;
    private JMethod _getAccessMode = null;
    private JMethod _getIdentity = null;
    private JMethod _getExtends = null;
    private JMethod _getJavaClass = null;
    private final JClass _type;
    private final BuilderConfiguration _config;

    public DescriptorJClass(BuilderConfiguration config, String className, JClass type) {
        super(className);
        this._config = config;
        this._type = type;
        this.init();
    }

    public JMethod getElementDefinitionMethod() {
        return this._getElementDefinition;
    }

    public JMethod getNameSpacePrefixMethod() {
        return this._getNameSpacePrefix;
    }

    public JMethod getNameSpacePrefixURI() {
        return this._getNameSpaceURI;
    }

    public JMethod getXMLNameMethod() {
        return this._getXMLName;
    }

    public JMethod getAccessModeMethod() {
        return this._getAccessMode;
    }

    public JMethod getExtendsMethod() {
        return this._getExtends;
    }

    public JMethod getIdentityMethod() {
        return this._getIdentity;
    }

    public JMethod getJavaClassMethod() {
        return this._getJavaClass;
    }

    private void init() {
        String superClass = null;
        if (this._config != null) {
            superClass = this._config.getProperty("org.exolab.castor.builder.superclass", null);
        }
        boolean extended = false;
        if (this._type.getSuperClassQualifiedName() == null || this._type.getSuperClassQualifiedName().equals(superClass)) {
            this.setSuperClass("org.exolab.castor.xml.util.XMLClassDescriptorImpl");
        } else {
            extended = true;
            this.setSuperClass(this._type.getSuperClassQualifiedName() + "Descriptor");
        }
        superClass = null;
        this.addField(new JField(JType.BOOLEAN, "elementDefinition"));
        this.addField(new JField(SGTypes.String, "nsPrefix"));
        this.addField(new JField(SGTypes.String, "nsURI"));
        this.addField(new JField(SGTypes.String, "xmlName"));
        this.addField(new JField(_XMLFieldDescriptorClass, "identity"));
        this.addDefaultConstructor(extended);
        this.addXMLClassDescriptorImplOverrides();
        this.addXMLClassDescriptorOverrides();
        this.addClassDescriptorOverrides(extended);
    }

    private void addDefaultConstructor(boolean extended) {
        this.addConstructor(this.createConstructor());
        JConstructor cons = this.getConstructor(0);
        JSourceCode jsc = cons.getSourceCode();
        jsc.add("super();");
        if (extended) {
            jsc.add("setExtendsWithoutFlatten(");
            jsc.append("new ");
            jsc.append(this.getSuperClassQualifiedName());
            jsc.append("());");
        }
    }

    private void addXMLClassDescriptorImplOverrides() {
        this._getElementDefinition = new JMethod("isElementDefinition", JType.BOOLEAN, "true if XML schema definition of this Class is that of a global\nelement or element with anonymous type definition.");
        JSourceCode jsc = this._getElementDefinition.getSourceCode();
        jsc.add("return elementDefinition;");
        this.addMethod(this._getElementDefinition);
    }

    private void addXMLClassDescriptorOverrides() {
        JMethod method = new JMethod("getNameSpacePrefix", SGTypes.String, "the namespace prefix to use when marshalling as XML.");
        if (this._config.useJava50()) {
            method.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        JSourceCode jsc = method.getSourceCode();
        jsc.add("return nsPrefix;");
        this.addMethod(method);
        this._getNameSpacePrefix = method;
        method = new JMethod("getNameSpaceURI", SGTypes.String, "the namespace URI used when marshalling and unmarshalling as XML.");
        if (this._config.useJava50()) {
            method.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        jsc = method.getSourceCode();
        jsc.add("return nsURI;");
        this.addMethod(method);
        this._getNameSpaceURI = method;
        method = new JMethod("getValidator", _TypeValidatorClass, "a specific validator for the class described by this ClassDescriptor.");
        if (this._config.useJava50()) {
            method.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        jsc = method.getSourceCode();
        jsc.add("return this;");
        this.addMethod(method);
        method = new JMethod("getXMLName", SGTypes.String, "the XML Name for the Class being described.");
        if (this._config.useJava50()) {
            method.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        jsc = method.getSourceCode();
        jsc.add("return xmlName;");
        this.addMethod(method);
        this._getXMLName = method;
    }

    private void addClassDescriptorOverrides(boolean extended) {
        JClass amClass = new JClass("org.exolab.castor.mapping.AccessMode");
        this._getAccessMode = new JMethod("getAccessMode", amClass, "the access mode specified for this class.");
        if (this._config.useJava50()) {
            this._getAccessMode.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        JSourceCode jsc = this._getAccessMode.getSourceCode();
        jsc.add("return null;");
        this.addMethod(this._getAccessMode);
        this._getExtends = new JMethod("getExtends", _ClassDescriptorClass, "the class descriptor of the class extended by this class.");
        if (this._config.useJava50()) {
            this._getExtends.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        jsc = this._getExtends.getSourceCode();
        if (extended) {
            jsc.add("return super.getExtends();");
        } else {
            jsc.add("return null;");
        }
        this.addMethod(this._getExtends, false);
        this._getIdentity = new JMethod("getIdentity", _FieldDescriptorClass, "the identity field, null if this class has no identity.");
        if (this._config.useJava50()) {
            this._getIdentity.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        jsc = this._getIdentity.getSourceCode();
        if (extended) {
            jsc.add("if (identity == null) {");
            jsc.indent();
            jsc.add("return super.getIdentity();");
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add("return identity;");
        this.addMethod(this._getIdentity, false);
        this._getJavaClass = new JMethod("getJavaClass", SGTypes.Class, "the Java class represented by this descriptor.");
        if (this._config.useJava50()) {
            this._getJavaClass.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        jsc = this._getJavaClass.getSourceCode();
        jsc.add("return ");
        jsc.append(DescriptorJClass.classType(this._type));
        jsc.append(";");
        this.addMethod(this._getJavaClass, false);
    }

    private static String classType(JType jType) {
        if (jType.isPrimitive()) {
            return jType.getWrapperName() + ".TYPE";
        }
        return jType.toString() + ".class";
    }
}

