/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.util.CharSequences;

public final class StandardDateFormat
extends DateFormat {
    private static final long serialVersionUID = 2764313272939921664L;
    public static final String UTC = "UTC";
    private static final OffsetTime MIDNIGHT = OffsetTime.of(0, 0, 0, 0, ZoneOffset.UTC);
    public static final DateTimeFormatter FORMAT = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 5, SignStyle.NORMAL).optionalStart().appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalStart().appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).optionalStart().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().optionalEnd().optionalEnd().optionalStart().appendZoneOrOffsetId().toFormatter(Locale.ROOT);
    private static TemporalQuery<?>[] QUERIES = new TemporalQuery[]{Instant::from, LocalDateTime::from, LocalDate::from};
    public static final int MILLISECONDS_PER_DAY = 86400000;
    public static final int MILLIS_PER_SECOND = 1000;
    public static final int NANOS_PER_MILLISECOND = 1000000;
    public static final int NANOS_PER_SECOND = 1000000000;
    private DateTimeFormatter format;

    public static Temporal parseBest(CharSequence charSequence) {
        return charSequence != null ? (Temporal)FORMAT.parseBest(StandardDateFormat.toISO(charSequence, 0, charSequence.length()), QUERIES) : null;
    }

    public static Instant parseInstantUTC(CharSequence charSequence) {
        return charSequence != null ? StandardDateFormat.parseInstantUTC(charSequence, 0, charSequence.length()) : null;
    }

    public static Instant parseInstantUTC(CharSequence charSequence, int n, int n2) {
        TemporalAccessor temporalAccessor = FORMAT.parseBest(StandardDateFormat.toISO(charSequence, n, n2), QUERIES);
        if (temporalAccessor instanceof Instant) {
            return (Instant)temporalAccessor;
        }
        OffsetDateTime offsetDateTime = temporalAccessor instanceof LocalDateTime ? ((LocalDateTime)temporalAccessor).atOffset(ZoneOffset.UTC) : ((LocalDate)temporalAccessor).atTime(MIDNIGHT);
        return offsetDateTime.toInstant();
    }

    static CharSequence toISO(CharSequence charSequence, int n, int n2) {
        int n3;
        n = CharSequences.skipLeadingWhitespaces(charSequence, n, n2);
        n2 = CharSequences.skipTrailingWhitespaces(charSequence, n, n2);
        StringBuilder stringBuilder = null;
        int n4 = 0;
        for (int i = n2; i > n; i -= n3) {
            int n5;
            block7: {
                boolean bl;
                int n6;
                block8: {
                    n5 = Character.codePointBefore(charSequence, i);
                    n3 = Character.charCount(n5);
                    if (!Character.isWhitespace(n5)) break block7;
                    n6 = i;
                    i = CharSequences.skipTrailingWhitespaces(charSequence, n, i - n3);
                    n5 = Character.codePointBefore(charSequence, i);
                    n3 = Character.charCount(n5);
                    bl = false;
                    if (!Character.isDigit(n4) || !Character.isDigit(n5)) break block8;
                    boolean bl2 = bl = CharSequences.indexOf(charSequence, 58, n, n2) > n6;
                    if (!bl) break block7;
                }
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n2 - n).append(charSequence, n, n2);
                    charSequence = stringBuilder;
                    i -= n;
                    n6 -= n;
                    n = 0;
                }
                if (bl) {
                    stringBuilder.replace(i, n6, "T");
                } else {
                    stringBuilder.delete(i, n6);
                }
                n2 = stringBuilder.length();
            }
            n4 = n5;
        }
        return charSequence.subSequence(n, n2);
    }

    public static Temporal toHeuristicTemporal(Date date, ZoneId zoneId) {
        if (date == null) {
            return null;
        }
        long l = date.getTime();
        if (l % 86400000L == 0L) {
            return LocalDate.ofEpochDay(l / 86400000L);
        }
        Instant instant = Instant.ofEpochMilli(l);
        if (zoneId == null) {
            zoneId = ZoneOffset.UTC;
        } else if (!zoneId.equals(ZoneOffset.UTC)) {
            return OffsetDateTime.ofInstant(instant, zoneId);
        }
        return LocalDateTime.ofInstant(instant, zoneId);
    }

    public static Date toDate(TemporalAccessor temporalAccessor) {
        long l;
        if (temporalAccessor == null) {
            return null;
        }
        if (temporalAccessor instanceof Instant) {
            l = ((Instant)temporalAccessor).toEpochMilli();
        } else if (temporalAccessor.isSupported(ChronoField.INSTANT_SECONDS)) {
            l = Math.multiplyExact(temporalAccessor.getLong(ChronoField.INSTANT_SECONDS), 1000L);
            l = Math.addExact(l, temporalAccessor.getLong(ChronoField.NANO_OF_SECOND) / 1000000L);
        } else {
            l = Math.multiplyExact(temporalAccessor.getLong(ChronoField.EPOCH_DAY), 86400000L);
            if (temporalAccessor.isSupported(ChronoField.MILLI_OF_DAY)) {
                l = Math.addExact(l, temporalAccessor.getLong(ChronoField.MILLI_OF_DAY));
            }
        }
        return new Date(l);
    }

    public static boolean hasDateFields(Class<?> clazz) {
        return clazz == LocalDate.class || clazz == LocalDateTime.class || clazz == OffsetDateTime.class || clazz == ZonedDateTime.class;
    }

    public static boolean hasTimeFields(Class<?> clazz) {
        return clazz == LocalTime.class || clazz == OffsetTime.class || clazz == LocalDateTime.class || clazz == OffsetDateTime.class || clazz == ZonedDateTime.class;
    }

    public StandardDateFormat() {
        this.format = FORMAT;
    }

    public StandardDateFormat(Locale locale) {
        this.format = FORMAT.withLocale(locale);
    }

    public StandardDateFormat(Locale locale, TimeZone timeZone) {
        this(locale);
        if (!UTC.equals(timeZone.getID())) {
            this.setTimeZone(timeZone);
        }
    }

    @Override
    public final Calendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance(this.getTimeZone(), this.format.getLocale());
        }
        return this.calendar;
    }

    @Override
    public final NumberFormat getNumberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getInstance(this.format.getLocale());
        }
        return this.numberFormat;
    }

    @Override
    public final TimeZone getTimeZone() {
        ZoneId zoneId = this.format.getZone();
        return TimeZone.getTimeZone(zoneId != null ? zoneId : ZoneOffset.UTC);
    }

    @Override
    public final void setTimeZone(TimeZone timeZone) {
        this.format = this.format.withZone(timeZone.toZoneId());
        if (this.calendar != null) {
            super.setTimeZone(timeZone);
        }
    }

    @Override
    public final void setLenient(boolean bl) {
        this.getCalendar().setLenient(bl);
    }

    @Override
    public final boolean isLenient() {
        return this.getCalendar().isLenient();
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.format.formatTo(StandardDateFormat.toHeuristicTemporal(date, null), stringBuffer);
        return stringBuffer;
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        try {
            return StandardDateFormat.toDate(this.format.parse((CharSequence)string, parsePosition));
        }
        catch (ArithmeticException | DateTimeException runtimeException) {
            parsePosition.setErrorIndex(StandardDateFormat.getErrorIndex(runtimeException, parsePosition));
            return null;
        }
    }

    @Override
    public Date parse(String string) throws ParseException {
        try {
            return StandardDateFormat.toDate(this.format.parse(StandardDateFormat.toISO(string, 0, string.length())));
        }
        catch (ArithmeticException | DateTimeException runtimeException) {
            throw (ParseException)new ParseException(runtimeException.getLocalizedMessage(), StandardDateFormat.getErrorIndex(runtimeException, null)).initCause(runtimeException);
        }
    }

    private static int getErrorIndex(RuntimeException runtimeException, ParsePosition parsePosition) {
        if (runtimeException instanceof DateTimeParseException) {
            return ((DateTimeParseException)runtimeException).getErrorIndex();
        }
        if (parsePosition != null) {
            return parsePosition.getIndex();
        }
        return 0;
    }

    @Override
    public int hashCode() {
        return 31 * this.format.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof StandardDateFormat && this.format.equals(((StandardDateFormat)object).format);
    }

    @Override
    public Object clone() {
        StandardDateFormat standardDateFormat = new StandardDateFormat();
        standardDateFormat.format = this.format;
        return standardDateFormat;
    }
}

