/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.schema.Resolver;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class SaxUnmarshaller
implements DocumentHandler,
ErrorHandler {
    protected Locator _locator = null;
    private Resolver _resolver;

    public abstract String elementName();

    public abstract Object getObject();

    public void finish() throws SAXException {
    }

    public Locator getDocumentLocator() {
        return this._locator;
    }

    public Resolver getResolver() {
        return this._resolver;
    }

    public void setResolver(Resolver resolver) {
        this._resolver = resolver;
    }

    public static boolean isWhiteSpace(char[] chars, int start, int length) {
        int max = start + length;
        block3: for (int i = start; i < max; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public void error(String err) throws SAXException {
        if (this._locator != null) {
            err = err + "\n   line: " + this._locator.getLineNumber();
        }
        throw new SAXException(err);
    }

    public void illegalAttribute(String attName) throws SAXException {
        String err = "Illegal attribute '" + attName + "' found on element <" + this.elementName() + ">.";
        if (this._locator != null) {
            err = err + "\n   line: " + this._locator.getLineNumber();
        }
        throw new SAXException(err);
    }

    public void illegalElement(String name) throws SAXException {
        String err = "Illegal element '" + name + "' found as child of <" + this.elementName() + ">.";
        if (this._locator != null) {
            err = err + "\n   line: " + this._locator.getLineNumber();
        }
        throw new SAXException(err);
    }

    public void redefinedElement(String name) throws SAXException {
        this.redefinedElement(name, null);
    }

    public void redefinedElement(String name, String xtraInfo) throws SAXException {
        String err = "redefintion of element '" + name + "' within element <" + this.elementName() + ">.";
        if (this._locator != null) {
            err = err + "\n   line: " + this._locator.getLineNumber();
        }
        if (xtraInfo != null) {
            err = err + "\n   " + xtraInfo;
        }
        throw new SAXException(err + "\n");
    }

    public void outOfOrder(String name) throws SAXException {
        StringBuffer err = new StringBuffer("out of order element <");
        err.append(name);
        err.append("> found in <");
        err.append(this.elementName());
        err.append(">.");
        throw new SAXException(err.toString());
    }

    public static int toInt(String str) throws IllegalArgumentException {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            String err = str + " is not a valid integer. ";
            throw new IllegalArgumentException(err);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String name) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }
}

