/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Arrays;
import org.apache.sis.geometry.AbstractDirectPosition;

public abstract class DirectPositionView
extends AbstractDirectPosition {
    public int offset;
    final int dimension;

    DirectPositionView(int n, int n2) {
        this.offset = n;
        this.dimension = n2;
    }

    public final int getDimension() {
        return this.dimension;
    }

    public static final class Float
    extends DirectPositionView {
        private final float[] coordinates;

        public Float(float[] fArray, int n, int n2) {
            super(n, n2);
            this.coordinates = fArray;
        }

        public double getOrdinate(int n) {
            assert (n >= 0 && n < this.dimension) : n;
            return this.coordinates[this.offset + n];
        }
    }

    public static final class Double
    extends DirectPositionView {
        private final double[] coordinates;

        public Double(double[] dArray) {
            super(0, dArray.length);
            this.coordinates = dArray;
        }

        public Double(double[] dArray, int n, int n2) {
            super(n, n2);
            this.coordinates = dArray;
        }

        public double getOrdinate(int n) {
            assert (n >= 0 && n < this.dimension) : n;
            return this.coordinates[this.offset + n];
        }

        @Override
        public double[] getCoordinate() {
            return Arrays.copyOfRange(this.coordinates, this.offset, this.offset + this.dimension);
        }
    }
}

