/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.sshd.common.config.keys.BuiltinIdentities;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.keyprovider.MappedKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.security.SecurityUtils;

public final class IdentityUtils {
    private IdentityUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static String getIdentityFileName(String prefix, String type, String suffix) {
        if (GenericUtils.isEmpty(type)) {
            return null;
        }
        return GenericUtils.trimToEmpty(prefix) + type.toLowerCase() + GenericUtils.trimToEmpty(suffix);
    }

    public static KeyPairProvider createKeyPairProvider(Map<String, KeyPair> ids, boolean supportedOnly) {
        if (MapEntryUtils.isEmpty(ids)) {
            return null;
        }
        TreeMap<String, KeyPair> pairsMap = new TreeMap<String, KeyPair>(String.CASE_INSENSITIVE_ORDER);
        ids.forEach((type, kp) -> {
            BuiltinIdentities id = BuiltinIdentities.fromName(type);
            if (supportedOnly && (id == null || !id.isSupported())) {
                return;
            }
            String keyType = KeyUtils.getKeyType(kp);
            if (GenericUtils.isEmpty(keyType)) {
                return;
            }
            KeyPair prev = pairsMap.put(keyType, (KeyPair)kp);
            if (prev != null) {
                return;
            }
        });
        if (MapEntryUtils.isEmpty(pairsMap)) {
            return null;
        }
        return new MappedKeyPairProvider(pairsMap);
    }

    public static NavigableMap<String, KeyPair> loadIdentities(SessionContext session, Map<String, ? extends Path> paths, FilePasswordProvider provider, OpenOption ... options) throws IOException, GeneralSecurityException {
        if (MapEntryUtils.isEmpty(paths)) {
            return Collections.emptyNavigableMap();
        }
        TreeMap<String, KeyPair> ids = new TreeMap<String, KeyPair>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, ? extends Path> pe : paths.entrySet()) {
            Iterable<KeyPair> pairs;
            String type = pe.getKey();
            Path path = pe.getValue();
            PathResource location = new PathResource(path, options);
            try (InputStream inputStream = location.openInputStream();){
                pairs = SecurityUtils.loadKeyPairIdentities(session, location, inputStream, provider);
            }
            if (pairs == null) continue;
            for (KeyPair kp : pairs) {
                KeyPair prev = ids.put(type, kp);
                ValidateUtils.checkTrue(prev == null, "Multiple keys for type=%s in %s", type, path);
            }
        }
        return ids;
    }
}

