/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.util;

import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LocaleUtils {
    private static final Log log = LogFactory.getLog((Class)LocaleUtils.class);

    private LocaleUtils() {
    }

    public static Locale toLocale(String localeString) {
        String country;
        String variant;
        String language;
        int separator;
        if (localeString == null || localeString.length() == 0) {
            Locale locale = Locale.getDefault();
            if (log.isWarnEnabled()) {
                log.warn((Object)("Locale name in faces-config.xml null or empty, setting locale to default locale : " + locale.toString()));
            }
            return locale;
        }
        int separatorCountry = localeString.indexOf(95);
        if (separatorCountry >= 0) {
            separator = 95;
        } else {
            separatorCountry = localeString.indexOf(45);
            separator = 45;
        }
        if (separatorCountry < 0) {
            language = localeString;
            variant = "";
            country = "";
        } else {
            language = localeString.substring(0, separatorCountry);
            int separatorVariant = localeString.indexOf(separator, separatorCountry + 1);
            if (separatorVariant < 0) {
                country = localeString.substring(separatorCountry + 1);
                variant = "";
            } else {
                country = localeString.substring(separatorCountry + 1, separatorVariant);
                variant = localeString.substring(separatorVariant + 1);
            }
        }
        return new Locale(language, country, variant);
    }

    public static Locale converterTagLocaleFromString(String name) {
        try {
            Locale locale;
            StringTokenizer st = new StringTokenizer(name, "_");
            String language = st.nextToken();
            if (st.hasMoreTokens()) {
                String country = st.nextToken();
                if (st.hasMoreTokens()) {
                    String variant = st.nextToken();
                    locale = new Locale(language, country, variant);
                } else {
                    locale = new Locale(language, country);
                }
            } else {
                locale = new Locale(language);
            }
            return locale;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Locale parsing exception - invalid string representation '" + name + "'");
        }
    }
}

