/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ExpressionFactory;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewVisitOption;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.servlet.ServletContext;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.myfaces.application.FacesServletMappingUtils;
import org.apache.myfaces.application.viewstate.StateUtils;
import org.apache.myfaces.cdi.util.BeanEntry;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.config.FacesConfigValidator;
import org.apache.myfaces.config.FacesConfigurator;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.annotation.CdiAnnotationProviderExtension;
import org.apache.myfaces.context.ExceptionHandlerImpl;
import org.apache.myfaces.context.servlet.StartupFacesContextImpl;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;
import org.apache.myfaces.push.EndpointImpl;
import org.apache.myfaces.push.WebsocketConfigurator;
import org.apache.myfaces.push.WebsocketFacesInit;
import org.apache.myfaces.spi.FacesFlowProvider;
import org.apache.myfaces.spi.FacesFlowProviderFactory;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.InjectionProviderException;
import org.apache.myfaces.spi.InjectionProviderFactory;
import org.apache.myfaces.spi.ServiceProviderFinder;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.spi.ViewScopeProvider;
import org.apache.myfaces.spi.ViewScopeProviderFactory;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.util.WebConfigParamUtils;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.StringUtils;
import org.apache.myfaces.view.facelets.ViewPoolProcessor;
import org.apache.myfaces.view.facelets.tag.MetaRulesetImpl;
import org.apache.myfaces.webapp.FacesInitializer;
import org.apache.myfaces.webapp.MyFacesHttpSessionListener;
import org.apache.myfaces.webapp.WebConfigParamsLogger;

public abstract class AbstractFacesInitializer
implements FacesInitializer {
    private static final Logger log = Logger.getLogger(AbstractFacesInitializer.class.getName());
    public static final String CDI_BEAN_MANAGER_INSTANCE = "oam.cdi.BEAN_MANAGER_INSTANCE";
    private static final String CDI_SERVLET_CONTEXT_BEAN_MANAGER_ATTRIBUTE = "javax.enterprise.inject.spi.BeanManager";
    public static final String INJECTED_BEAN_STORAGE_KEY = "org.apache.myfaces.spi.BEAN_ENTRY_STORAGE";

    @Override
    public void initFaces(ServletContext servletContext) {
        try {
            ResourceBundle.Control resourceBundleControl;
            String useEncryption;
            Boolean mappingAdded;
            FacesServletMappingUtils.ServletRegistrationInfo facesServletRegistration;
            FacesContext facesContext;
            ExternalContext externalContext;
            ServiceProviderFinder spf;
            Map<String, List<String>> spfConfig;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Initializing MyFaces");
            }
            if ((spfConfig = (spf = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext = (facesContext = FacesContext.getCurrentInstance()).getExternalContext())).calculateKnownServiceProviderMapInfo(externalContext, ServiceProviderFinder.KNOWN_SERVICES)) != null) {
                spf.initKnownServiceProviderMapInfo(externalContext, spfConfig);
            }
            if (!(WebConfigParamUtils.getBooleanInitParameter(externalContext, "org.apache.myfaces.INITIALIZE_ALWAYS_STANDALONE", false) || (facesServletRegistration = FacesServletMappingUtils.getFacesServletRegistration(facesContext, servletContext, false)) != null && facesServletRegistration.getMappings() != null && facesServletRegistration.getMappings().length != 0 || (mappingAdded = (Boolean)servletContext.getAttribute("org.apache.myfaces.FACES_SERVLET_FOUND")) != null && mappingAdded.booleanValue() || (mappingAdded = (Boolean)servletContext.getAttribute("org.apache.myfaces.DYNAMICALLY_ADDED_FACES_SERVLET")) != null && mappingAdded.booleanValue())) {
                if (log.isLoggable(Level.WARNING)) {
                    log.warning("No mappings of FacesServlet found. Abort initializing MyFaces.");
                }
                return;
            }
            this.initCDIIntegration(servletContext, externalContext);
            this.initContainerIntegration(servletContext, externalContext);
            ExternalSpecifications.isBeanValidationAvailable();
            ExternalSpecifications.isCDIAvailable(externalContext);
            ExternalSpecifications.isEL3Available();
            ExternalSpecifications.isServlet4Available();
            ViewScopeProviderFactory viewScopeProviderFactory = ViewScopeProviderFactory.getViewScopeHandlerFactory(externalContext);
            ViewScopeProvider viewScopeProvider = viewScopeProviderFactory.getViewScopeHandler(externalContext);
            FacesFlowProviderFactory facesFlowProviderFactory = FacesFlowProviderFactory.getFacesFlowProviderFactory(externalContext);
            FacesFlowProvider facesFlowProvider = facesFlowProviderFactory.getFacesFlowProvider(externalContext);
            MyFacesHttpSessionListener listener = (MyFacesHttpSessionListener)externalContext.getApplicationMap().get(MyFacesHttpSessionListener.APPLICATION_MAP_KEY);
            if (listener != null) {
                listener.setViewScopeProvider(viewScopeProvider);
                listener.setFacesFlowProvider(facesFlowProvider);
            }
            if ("false".equals(useEncryption = servletContext.getInitParameter("org.apache.myfaces.USE_ENCRYPTION"))) {
                log.warning("org.apache.myfaces.USE_ENCRYPTION is set to false. This is unsecure and should only be used for local or intranet applications!");
            } else {
                StateUtils.initSecret(servletContext);
            }
            this._dispatchApplicationEvent(servletContext, PostConstructApplicationEvent.class);
            this.initWebsocketIntegration(servletContext, externalContext);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("ServletContext initialized");
            }
            WebConfigParamsLogger.logWebContextParams(facesContext);
            ViewPoolProcessor.initialize(facesContext);
            MyfacesConfig config = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext());
            if (config.isAutomaticExtensionlessMapping()) {
                this.initAutomaticExtensionlessMapping(facesContext, servletContext);
            }
            if ((resourceBundleControl = config.getResourceBundleControl()) != null) {
                facesContext.getExternalContext().getApplicationMap().put("org.apache.myfaces.RESOURCE_BUNDLE_CONTROL", resourceBundleControl);
            }
            if (!facesContext.isProjectStage(ProjectStage.Production) && !facesContext.isProjectStage(ProjectStage.UnitTest)) {
                int i;
                ProjectStage projectStage = facesContext.getApplication().getProjectStage();
                StringBuilder message = new StringBuilder("\n\n");
                message.append("********************************************************************\n");
                message.append("*** WARNING: Apache MyFaces Core is running in ");
                message.append(projectStage.name().toUpperCase());
                message.append(" mode.");
                int length = projectStage.name().length();
                for (i = 0; i < 11 - length; ++i) {
                    message.append(' ');
                }
                message.append(" ***\n");
                message.append("***                                            ");
                for (i = 0; i < length; ++i) {
                    message.append('^');
                }
                for (i = 0; i < 18 - length; ++i) {
                    message.append(' ');
                }
                message.append("***\n");
                message.append("*** Do NOT deploy to your live server(s) without changing this.  ***\n");
                message.append("*** See Application#getProjectStage() for more information.      ***\n");
                message.append("********************************************************************\n");
                message.append("\n");
                log.log(Level.WARNING, message.toString());
            }
            this.cleanupAfterStartup(facesContext);
            servletContext.setAttribute("org.apache.myfaces.INITIALIZED", (Object)Boolean.TRUE);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "An error occured while initializing MyFaces: " + ex.getMessage(), ex);
        }
    }

    protected void cleanupAfterStartup(FacesContext facesContext) {
        BeanManager beanManager;
        CdiAnnotationProviderExtension extension;
        ExternalContext externalContext = facesContext.getExternalContext();
        if (ExternalSpecifications.isCDIAvailable(externalContext) && (extension = CDIUtils.getOptional(beanManager = CDIUtils.getBeanManager(externalContext), CdiAnnotationProviderExtension.class)) != null) {
            extension.release();
        }
    }

    private void _dispatchApplicationEvent(ServletContext servletContext, Class<? extends SystemEvent> eventClass) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        application.publishEvent(facesContext, eventClass, Application.class, application);
    }

    @Override
    public void destroyFaces(ServletContext servletContext) {
        if (!Boolean.TRUE.equals(servletContext.getAttribute("org.apache.myfaces.INITIALIZED"))) {
            return;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this._dispatchApplicationEvent(servletContext, PreDestroyApplicationEvent.class);
        this._callPreDestroyOnInjectedJSFArtifacts(facesContext);
        MetaRulesetImpl.clearMetadataTargetCache();
        if (facesContext.getExternalContext().getApplicationMap().containsKey("org.apache.myfaces.push")) {
            WebsocketFacesInit.clearWebsocketSessionLRUCache(facesContext.getExternalContext());
        }
        try {
            Class c = ClassUtils.classForName("javax.faces.component.UIViewParameter");
            Method m = c.getDeclaredMethod("releaseRenderer", new Class[0]);
            m.setAccessible(true);
            m.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected RuntimeConfig buildConfiguration(ServletContext servletContext, ExternalContext externalContext, ExpressionFactory expressionFactory) {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        runtimeConfig.setExpressionFactory(expressionFactory);
        new FacesConfigurator(externalContext).configure();
        this.validateFacesConfig(servletContext, externalContext);
        return runtimeConfig;
    }

    protected void validateFacesConfig(ServletContext servletContext, ExternalContext externalContext) {
        String validate = servletContext.getInitParameter("org.apache.myfaces.VALIDATE");
        if ("true".equals(validate) && log.isLoggable(Level.WARNING)) {
            List<String> warnings = FacesConfigValidator.validate(externalContext);
            for (String warning : warnings) {
                log.warning(warning);
            }
        }
    }

    protected static ExpressionFactory getUserDefinedExpressionFactory(ExternalContext externalContext) {
        String expressionFactoryClassName = MyfacesConfig.getCurrentInstance(externalContext).getExpressionFactory();
        if (StringUtils.isNotBlank(expressionFactoryClassName)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Attempting to load the ExpressionFactory implementation you've specified: '" + expressionFactoryClassName + "'.");
            }
            return AbstractFacesInitializer.loadExpressionFactory(expressionFactoryClassName);
        }
        return null;
    }

    protected static ExpressionFactory loadExpressionFactory(String expressionFactoryClassName) {
        return AbstractFacesInitializer.loadExpressionFactory(expressionFactoryClassName, true);
    }

    protected static ExpressionFactory loadExpressionFactory(String expressionFactoryClassName, boolean logMissing) {
        try {
            ClassLoader cl = ClassUtils.getContextClassLoader();
            if (cl == null) {
                cl = AbstractFacesInitializer.class.getClassLoader();
            }
            Class<?> expressionFactoryClass = cl.loadClass(expressionFactoryClassName);
            return (ExpressionFactory)expressionFactoryClass.newInstance();
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "An error occured while instantiating a new ExpressionFactory. Attempted to load class '" + expressionFactoryClassName + "'.", ex);
            }
            return null;
        }
    }

    @Override
    public FacesContext initStartupFacesContext(ServletContext servletContext) {
        return this._createFacesContext(servletContext, true);
    }

    @Override
    public void destroyStartupFacesContext(FacesContext facesContext) {
        this._releaseFacesContext(facesContext);
    }

    @Override
    public FacesContext initShutdownFacesContext(ServletContext servletContext) {
        return this._createFacesContext(servletContext, false);
    }

    @Override
    public void destroyShutdownFacesContext(FacesContext facesContext) {
        this._releaseFacesContext(facesContext);
    }

    private FacesContext _createFacesContext(ServletContext servletContext, boolean startup) {
        StartupServletExternalContextImpl externalContext = new StartupServletExternalContextImpl(servletContext, startup);
        ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
        StartupFacesContextImpl facesContext = new StartupFacesContextImpl((ExternalContext)externalContext, (ExternalContext)externalContext, exceptionHandler, startup);
        UIViewRoot startupViewRoot = new UIViewRoot();
        startupViewRoot.setLocale(Locale.getDefault());
        ((FacesContext)facesContext).setViewRoot(startupViewRoot);
        return facesContext;
    }

    private void _releaseFacesContext(FacesContext facesContext) {
        if (facesContext != null) {
            facesContext.release();
        }
    }

    protected abstract void initContainerIntegration(ServletContext var1, ExternalContext var2);

    protected void initCDIIntegration(ServletContext servletContext, ExternalContext externalContext) {
        Object beanManager = servletContext.getAttribute(CDI_SERVLET_CONTEXT_BEAN_MANAGER_ATTRIBUTE);
        if (beanManager == null) {
            beanManager = this.lookupBeanManagerFromCDI();
        }
        if (beanManager == null) {
            beanManager = this.lookupBeanManagerFromJndi();
        }
        if (beanManager != null) {
            externalContext.getApplicationMap().put(CDI_BEAN_MANAGER_INSTANCE, beanManager);
        }
    }

    private Object lookupBeanManagerFromCDI() {
        try {
            Class cdiClass = ClassUtils.simpleClassForName("javax.enterprise.inject.spi.CDI", false);
            if (cdiClass != null) {
                Method currentMethod = cdiClass.getMethod("current", new Class[0]);
                Object cdi = currentMethod.invoke(null, new Object[0]);
                Method getBeanManagerMethod = cdiClass.getMethod("getBeanManager", new Class[0]);
                Object beanManager = getBeanManagerMethod.invoke(cdi, new Object[0]);
                return beanManager;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Object lookupBeanManagerFromJndi() {
        Object beanManager = null;
        Class icclazz = null;
        Method lookupMethod = null;
        try {
            icclazz = ClassUtils.simpleClassForName("javax.naming.InitialContext");
            if (icclazz != null) {
                lookupMethod = icclazz.getMethod("doLookup", String.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (lookupMethod != null) {
            try {
                beanManager = lookupMethod.invoke((Object)icclazz, "java:comp/BeanManager");
            }
            catch (Exception exception) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            if (beanManager == null) {
                try {
                    beanManager = lookupMethod.invoke((Object)icclazz, "java:comp/env/BeanManager");
                }
                catch (Exception exception) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
        }
        return beanManager;
    }

    public void _callPreDestroyOnInjectedJSFArtifacts(FacesContext facesContext) {
        InjectionProvider injectionProvider = InjectionProviderFactory.getInjectionProviderFactory(facesContext.getExternalContext()).getInjectionProvider(facesContext.getExternalContext());
        List injectedBeanStorage = (List)facesContext.getExternalContext().getApplicationMap().get(INJECTED_BEAN_STORAGE_KEY);
        if (injectedBeanStorage != null) {
            for (BeanEntry entry : injectedBeanStorage) {
                try {
                    injectionProvider.preDestroy(entry.getInstance(), entry.getCreationMetaData());
                }
                catch (InjectionProviderException ex) {
                    log.log(Level.INFO, "Exception on PreDestroy", ex);
                }
            }
            injectedBeanStorage.clear();
        }
    }

    protected void initWebsocketIntegration(ServletContext servletContext, ExternalContext externalContext) {
        Boolean b = WebConfigParamUtils.getBooleanInitParameter(externalContext, "javax.faces.ENABLE_WEBSOCKET_ENDPOINT");
        if (Boolean.TRUE.equals(b)) {
            ServerContainer serverContainer = (ServerContainer)servletContext.getAttribute(ServerContainer.class.getName());
            if (serverContainer == null) {
                log.log(Level.INFO, "f:websocket support enabled but cannot found websocket ServerContainer instance on current context.");
                return;
            }
            try {
                serverContainer.addEndpoint(ServerEndpointConfig.Builder.create(EndpointImpl.class, (String)"/javax.faces.push/{channel}").configurator((ServerEndpointConfig.Configurator)new WebsocketConfigurator(externalContext)).build());
                WebsocketFacesInit.initWebsocketSessionLRUCache(externalContext);
                externalContext.getApplicationMap().put("org.apache.myfaces.push", Boolean.TRUE);
            }
            catch (DeploymentException e) {
                log.log(Level.INFO, "Exception on initialize Websocket Endpoint: ", e);
            }
        }
    }

    protected void initAutomaticExtensionlessMapping(FacesContext facesContext, ServletContext servletContext) {
        FacesServletMappingUtils.ServletRegistrationInfo facesServletRegistration = FacesServletMappingUtils.getFacesServletRegistration(facesContext, servletContext, false);
        if (facesServletRegistration != null) {
            facesContext.getApplication().getViewHandler().getViews(facesContext, "/", ViewVisitOption.RETURN_AS_MINIMAL_IMPLICIT_OUTCOME).forEach(s -> facesServletRegistration.getRegistration().addMapping(new String[]{s}));
        }
    }
}

