/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIPanel;
import org.apache.myfaces.tobago.internal.component.AbstractUIReload;
import org.apache.myfaces.tobago.internal.renderkit.renderer.PanelRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.model.CollapseMode;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class PanelRenderer
extends PanelRendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIPanel panel = (AbstractUIPanel)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = panel.getClientId(facesContext);
        boolean collapsed = panel.isCollapsed();
        Markup markup = panel.getMarkup();
        AbstractUIReload reload = ComponentUtils.getReloadFacet((UIComponent)panel);
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        writer.writeClassAttribute((CssItem)TobagoClass.PANEL, TobagoClass.PANEL.createMarkup(markup), new CssItem[]{collapsed ? TobagoClass.COLLAPSED : null, panel.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null});
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)panel);
        String tip = panel.getTip();
        if (tip != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, tip, true);
        }
        if (reload != null && reload.isRendered()) {
            writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.RELOAD, reload.getFrequency());
        }
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, panel)));
        if (panel.getCollapsedMode() != CollapseMode.none) {
            this.encodeHidden(writer, clientId, collapsed);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
    }
}

