/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.RegexValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUITextarea;
import org.apache.myfaces.tobago.internal.renderkit.renderer.MessageLayoutRendererBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.sanitizer.SanitizeMode;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextareaRenderer
extends MessageLayoutRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TextareaRenderer.class);

    @Override
    protected void setSubmittedValue(FacesContext facesContext, EditableValueHolder component, String newValue) {
        String value = newValue;
        AbstractUITextarea textarea = (AbstractUITextarea)component;
        if (ComponentUtils.getDataAttribute((UIComponent)textarea, "html-editor") != null && SanitizeMode.auto == textarea.getSanitize()) {
            Sanitizer sanitizer = TobagoConfig.getInstance(facesContext).getSanitizer();
            value = sanitizer.sanitize(newValue);
        }
        if (TobagoConfig.getInstance(facesContext).isDecodeLineFeed()) {
            value = value.replace("\r\n", "\n");
        }
        super.setSubmittedValue(facesContext, (EditableValueHolder)textarea, value);
    }

    @Override
    public void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        String currentValue;
        if (!(component instanceof AbstractUITextarea)) {
            LOG.error("Wrong type: Need " + AbstractUITextarea.class.getName() + ", but was " + component.getClass().getName());
            return;
        }
        AbstractUITextarea input = (AbstractUITextarea)component;
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        String clientId = input.getClientId(facesContext);
        String fieldId = input.getFieldId(facesContext);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Integer rows = input.getRows();
        boolean readonly = input.isReadonly();
        boolean disabled = input.isDisabled();
        Markup markup = input.getMarkup();
        writer.startElement(HtmlElements.TEXTAREA);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(fieldId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)input);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.ROWS, rows);
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, input.isRequired());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, input.getTabIndex());
        if (input.getAccessKey() != null) {
            writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(input.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey(facesContext, input.getAccessKey(), clientId);
        }
        writer.writeClassAttribute((CssItem)TobagoClass.TEXTAREA, TobagoClass.TEXTAREA.createMarkup(input.getMarkup()), new CssItem[]{BootstrapClass.borderColor(ComponentUtils.getMaximumSeverity((UIComponent)input)), BootstrapClass.FORM_CONTROL, input.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null});
        int maxLength = 0;
        int minLength = 0;
        String pattern = null;
        for (Validator validator : input.getValidators()) {
            if (validator instanceof LengthValidator) {
                LengthValidator lengthValidator = (LengthValidator)validator;
                maxLength = lengthValidator.getMaximum();
                minLength = lengthValidator.getMinimum();
                continue;
            }
            if (!(validator instanceof RegexValidator)) continue;
            RegexValidator regexValidator = (RegexValidator)validator;
            pattern = regexValidator.getPattern();
        }
        if (maxLength > 0) {
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAXLENGTH, maxLength);
        }
        if (minLength > 0) {
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MINLENGTH, minLength);
        }
        if (pattern != null) {
            writer.writeAttribute(HtmlAttributes.PATTERN, pattern, true);
        }
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, input)));
        HtmlRendererUtils.renderFocus(clientId, input.isFocus(), ComponentUtils.isError(input), facesContext, writer);
        String placeholder = input.getPlaceholder();
        if (!disabled && !readonly && StringUtils.isNotBlank(placeholder)) {
            writer.writeAttribute(HtmlAttributes.PLACEHOLDER, placeholder, true);
        }
        if ((currentValue = RenderUtils.currentValue((UIComponent)input)) != null) {
            if (ComponentUtils.getDataAttribute((UIComponent)input, "html-editor") != null && SanitizeMode.auto == input.getSanitize()) {
                Sanitizer sanitizer = TobagoConfig.getInstance(facesContext).getSanitizer();
                currentValue = sanitizer.sanitize(currentValue);
            }
            if (currentValue.startsWith("\r\n")) {
                currentValue = "\r\n" + currentValue;
            } else if (currentValue.startsWith("\n")) {
                currentValue = "\n" + currentValue;
            } else if (currentValue.startsWith("\r")) {
                currentValue = "\r" + currentValue;
            }
            writer.writeText(currentValue);
        }
        writer.endElement(HtmlElements.TEXTAREA);
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
    }

    @Override
    protected String getFieldId(FacesContext facesContext, UIComponent component) {
        AbstractUITextarea input = (AbstractUITextarea)component;
        return input.getFieldId(facesContext);
    }
}

