/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.ext;

import java.io.IOException;
import java.text.MessageFormat;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.component.html.ext.HtmlMessage;
import org.apache.myfaces.component.html.ext.HtmlMessages;
import org.apache.myfaces.renderkit.html.ext.HtmlMessageRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlMessagesRendererBase;

public class HtmlMessagesRenderer
extends HtmlMessagesRendererBase {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        this.renderMessages(facesContext, component);
        if (component instanceof HtmlMessages && ((HtmlMessages)component).getForceSpan()) {
            ResponseWriter writer = facesContext.getResponseWriter();
            HtmlMessages htmlMessages = (HtmlMessages)component;
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)component.getClientId(facesContext), null);
            if (htmlMessages.getStyleClass() != null) {
                writer.writeAttribute("class", (Object)htmlMessages.getStyleClass(), null);
            }
            if (htmlMessages.getStyle() != null) {
                writer.writeAttribute("style", (Object)htmlMessages.getStyle(), null);
            }
            writer.endElement("span");
        }
    }

    protected String getSummary(FacesContext facesContext, UIComponent message, FacesMessage facesMessage, String msgClientId) {
        String summaryFormat;
        String msgSummary = facesMessage.getSummary();
        if (msgSummary == null) {
            return null;
        }
        String inputLabel = null;
        if (msgClientId != null) {
            inputLabel = HtmlMessageRenderer.findInputLabel(facesContext, msgClientId);
        }
        if (inputLabel == null) {
            inputLabel = "";
        }
        if ((message instanceof HtmlMessages && ((HtmlMessages)message).isReplaceIdWithLabel() || message instanceof HtmlMessage && ((HtmlMessage)message).isReplaceIdWithLabel()) && inputLabel.length() != 0) {
            msgSummary = msgSummary.replaceAll(HtmlMessageRenderer.findInputId(facesContext, msgClientId), inputLabel);
        }
        if (msgClientId == null) {
            summaryFormat = this.getGlobalSummaryFormat(message);
            if (summaryFormat == null) {
                summaryFormat = this.getSummaryFormat(message);
            }
        } else {
            summaryFormat = this.getSummaryFormat(message);
        }
        if (summaryFormat == null) {
            return msgSummary;
        }
        MessageFormat format = new MessageFormat(summaryFormat, facesContext.getViewRoot().getLocale());
        return format.format(new Object[]{msgSummary, inputLabel});
    }

    private String getSummaryFormat(UIComponent message) {
        if (message instanceof HtmlMessages) {
            return ((HtmlMessages)message).getSummaryFormat();
        }
        return (String)message.getAttributes().get("summaryFormat");
    }

    private String getGlobalSummaryFormat(UIComponent message) {
        if (message instanceof HtmlMessages) {
            return ((HtmlMessages)message).getGlobalSummaryFormat();
        }
        return (String)message.getAttributes().get("globalSummaryFormat");
    }

    protected String getDetail(FacesContext facesContext, UIComponent message, FacesMessage facesMessage, String msgClientId) {
        String detailFormat;
        String msgDetail = facesMessage.getDetail();
        if (msgDetail == null) {
            return null;
        }
        String inputLabel = null;
        if (msgClientId != null) {
            inputLabel = HtmlMessageRenderer.findInputLabel(facesContext, msgClientId);
        }
        if (inputLabel == null) {
            inputLabel = "";
        }
        if ((message instanceof HtmlMessages && ((HtmlMessages)message).isReplaceIdWithLabel() || message instanceof HtmlMessage && ((HtmlMessage)message).isReplaceIdWithLabel()) && inputLabel.length() != 0) {
            msgDetail = msgDetail.replaceAll(HtmlMessageRenderer.findInputId(facesContext, msgClientId), inputLabel);
        }
        if ((detailFormat = message instanceof HtmlMessage ? ((HtmlMessage)message).getDetailFormat() : (String)message.getAttributes().get("detailFormat")) == null) {
            return msgDetail;
        }
        MessageFormat format = new MessageFormat(detailFormat, facesContext.getViewRoot().getLocale());
        return format.format(new Object[]{msgDetail, inputLabel});
    }
}

