/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.inputHtml;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.inputHtml.InputHtml;
import org.apache.myfaces.custom.tabbedpane.AbstractHtmlPanelTabbedPane;
import org.apache.myfaces.custom.tabbedpane.HtmlPanelTab;
import org.apache.myfaces.custom.tabbedpane.HtmlPanelTabbedPane;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.HTMLEncoder;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;

public class InputHtmlRenderer
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog(HtmlRendererUtils.class);
    private static String ROWSPAN_ATTR = "rowspan";
    private static String I18N_TRANSLATE_ATTR = "i18n:translate";
    private static String I18N_ATTRIBUTES_ATTR = "i18n:attributes";

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (!UserRoleUtils.isEnabledOnUserRole(uiComponent)) {
            return false;
        }
        return ((InputHtml)uiComponent).isDisabled();
    }

    private static boolean useFallback(InputHtml editor) {
        return editor.getFallback().equals("true");
    }

    public void encodeEnd(FacesContext context, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(context, uiComponent, InputHtml.class);
        InputHtml editor = (InputHtml)uiComponent;
        if (HtmlRendererUtils.isDisplayValueOnly((UIComponent)editor)) {
            this.encodeDisplayValueOnly(context, editor);
        } else if (InputHtmlRenderer.useFallback(editor)) {
            this.encodeEndFallBackMode(context, editor);
        } else if (!this.isVisible(editor)) {
            this.encodeHidden(context, editor);
        } else if (!InputHtmlRenderer.hasThisPageAlreadyRenderedAnInputHtml(context)) {
            this.encodeEndNormalMode(context, editor);
            InputHtmlRenderer.setThisPageAlreadyRenderedAnInputHtml(context);
        } else {
            log.warn((Object)("Only one inputHtml can be displayed at the same time. The component will be rendered isung a textarea.\nConpoment : " + RendererUtils.getPathToComponent((UIComponent)editor)));
            this.encodeEndFallBackMode(context, editor);
        }
    }

    private static boolean hasThisPageAlreadyRenderedAnInputHtml(FacesContext context) {
        return context.getExternalContext().getRequestMap().containsKey(InputHtmlRenderer.class.getName());
    }

    private static void setThisPageAlreadyRenderedAnInputHtml(FacesContext context) {
        context.getExternalContext().getRequestMap().put(InputHtmlRenderer.class.getName(), Boolean.TRUE);
    }

    private boolean isVisible(InputHtml editor) {
        for (Object parent = editor.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof HtmlPanelTab)) continue;
            HtmlPanelTab panelTab = (HtmlPanelTab)parent;
            AbstractHtmlPanelTabbedPane panelTabbedPane = null;
            for (UIComponent panelAncestor = panelTab.getParent(); panelAncestor != null; panelAncestor = panelAncestor.getParent()) {
                if (!(panelAncestor instanceof HtmlPanelTabbedPane)) continue;
                panelTabbedPane = (HtmlPanelTabbedPane)panelAncestor;
                break;
            }
            if (panelTabbedPane != null) {
                if (panelTabbedPane.isClientSide()) {
                    parent = panelTabbedPane;
                    continue;
                }
                int selectedIndex = ((HtmlPanelTabbedPane)panelTabbedPane).getSelectedIndex();
                List children = panelTabbedPane.getChildren();
                int tabIdx = 0;
                int len = children.size();
                for (int i = 0; i < len && tabIdx <= selectedIndex; ++i) {
                    UIComponent child = this.htmlTabbedPaneRenderer_getUIComponent((UIComponent)children.get(i));
                    if (!(child instanceof HtmlPanelTab)) continue;
                    if (child == panelTab) {
                        if (!child.isRendered() || tabIdx != selectedIndex) {
                            return false;
                        }
                        parent = panelTabbedPane;
                        continue;
                    }
                    ++tabIdx;
                }
                continue;
            }
            log.debug((Object)("pannelTabbedPane == null for component " + RendererUtils.getPathToComponent((UIComponent)panelTab)));
        }
        return true;
    }

    private UIComponent htmlTabbedPaneRenderer_getUIComponent(UIComponent uiComponent) {
        if (uiComponent instanceof UIForm || uiComponent instanceof UINamingContainer) {
            List children = uiComponent.getChildren();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                uiComponent = this.htmlTabbedPaneRenderer_getUIComponent((UIComponent)children.get(i));
            }
        }
        return uiComponent;
    }

    private void encodeHidden(FacesContext context, InputHtml editor) throws IOException {
        String clientId = editor.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("textarea", (UIComponent)editor);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("style", (Object)"display:none", null);
        String text = RendererUtils.getStringValue(context, (UIComponent)editor);
        writer.writeText((Object)text, "value");
        writer.endElement("textarea");
    }

    private void encodeDisplayValueOnly(FacesContext context, InputHtml editor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", (UIComponent)editor);
        HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)editor, context);
        HtmlRendererUtils.renderDisplayValueOnlyAttributes((UIComponent)editor, writer);
        String text = RendererUtils.getStringValue(context, (UIComponent)editor);
        writer.write(editor.getHtmlBody(text));
        writer.endElement("span");
    }

    private void encodeEndFallBackMode(FacesContext context, InputHtml editor) throws IOException {
        String clientId = editor.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("textarea", (UIComponent)editor);
        writer.writeAttribute("name", (Object)clientId, null);
        HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)editor, context);
        if (editor.getStyle() != null) {
            writer.writeAttribute("style", (Object)editor.getStyle(), null);
        }
        if (editor.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)editor.getStyleClass(), null);
        }
        if (this.isDisabled(context, (UIComponent)editor)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        String text = RendererUtils.getStringValue(context, (UIComponent)editor);
        writer.write(InputHtmlRenderer.htmlToPlainText(text, editor));
        writer.endElement("textarea");
    }

    private static String htmlToPlainText(String html, InputHtml editor) {
        return editor.getHtmlBody(html).replaceAll("<br.*>", "\n").replaceAll("<.+?>", "");
    }

    private void encodeEndNormalMode(FacesContext context, InputHtml editor) throws IOException {
        String clientId = editor.getClientId(context);
        FormInfo parentFormInfo = RendererUtils.findNestingForm((UIComponent)editor, context);
        if (parentFormInfo == null) {
            throw new FacesException("InputHtml must be embedded in a form.");
        }
        String formId = parentFormInfo.getFormName();
        AddResource addResource = AddResourceFactory.getInstance(context);
        addResource.addStyleSheet(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupustyles.css");
        addResource.addStyleSheet(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupudrawerstyles.css");
        addResource.addStyleSheet(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "myFaces.css");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "sarissa.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "sarissa_ieemu_xpath.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupuhelpers.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupueditor.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupubasetools.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupuloggers.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupunoi18n.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupucleanupexpressions.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupucontentfilters.js");
        if (editor.isShowAnyToolBox()) {
            addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kuputoolcollapser.js");
        }
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupucontextmenu.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupuinit.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupustart.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupusourceedit.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupuspellchecker.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupudrawers.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "kupuundo.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "diff_match_patch.js");
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, InputHtmlRenderer.class, "myFacesUtils.js");
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("style", (Object)"display: none;", null);
        writer.startElement("xml", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupuconfig", null);
        writer.writeAttribute("class", (Object)"kupuconfig", null);
        writer.startElement("kupuconfig", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "dst", "fulldoc.html", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "use_css", "1", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "reload_after_save", "0", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "strict_output", "1", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "content_type", "application/xhtml+xml", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "compatible_singletons", "1", (UIComponent)editor);
        writer.startElement("table_classes", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "class", "plain", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "class", "listing", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "class", "grid", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "class", "data", (UIComponent)editor);
        writer.endElement("table_classes");
        writer.startElement("cleanup_expressions", (UIComponent)editor);
        writer.startElement("set", (UIComponent)editor);
        writer.startElement("name", (UIComponent)editor);
        writer.write("Convert single quotes to curly ones");
        writer.endElement("name");
        writer.startElement("expression", (UIComponent)editor);
        writer.startElement("reg", (UIComponent)editor);
        writer.write("(\\W)'");
        writer.endElement("reg");
        writer.startElement("replacement", (UIComponent)editor);
        writer.write("\\1&#x8216;");
        writer.endElement("replacement");
        writer.endElement("expression");
        writer.startElement("expression", (UIComponent)editor);
        writer.startElement("reg", (UIComponent)editor);
        writer.write("'");
        writer.endElement("reg");
        writer.startElement("replacement", (UIComponent)editor);
        writer.write("&#x8217;");
        writer.endElement("replacement");
        writer.endElement("expression");
        writer.endElement("set");
        writer.startElement("set", (UIComponent)editor);
        writer.startElement("name", (UIComponent)editor);
        writer.write("Reduce whitespace");
        writer.endElement("name");
        writer.startElement("expression", (UIComponent)editor);
        writer.startElement("reg", (UIComponent)editor);
        writer.write("[\\n\\r\\t]");
        writer.endElement("reg");
        writer.startElement("replacement", (UIComponent)editor);
        writer.write("\\x20");
        writer.endElement("replacement");
        writer.endElement("expression");
        writer.startElement("expression", (UIComponent)editor);
        writer.startElement("reg", (UIComponent)editor);
        writer.write("[ ]{2}");
        writer.endElement("reg");
        writer.startElement("replacement", (UIComponent)editor);
        writer.write("\\x20");
        writer.endElement("replacement");
        writer.endElement("expression");
        writer.endElement("set");
        writer.endElement("cleanup_expressions");
        InputHtmlRenderer.writeTag(writer, "image_xsl_uri", addResource.getResourceUri(context, InputHtmlRenderer.class, "kupudrawers/drawer.xsl"), (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "link_xsl_uri", addResource.getResourceUri(context, InputHtmlRenderer.class, "kupudrawers/drawer.xsl"), (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "image_libraries_uri", addResource.getResourceUri(context, InputHtmlRenderer.class, "kupudrawers/imagelibrary.xml"), (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "link_libraries_uri", addResource.getResourceUri(context, InputHtmlRenderer.class, "kupudrawers/linklibrary.xml"), (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "search_images_uri", "", (UIComponent)editor);
        InputHtmlRenderer.writeTag(writer, "search_links_uri", "", (UIComponent)editor);
        writer.endElement("kupuconfig");
        writer.endElement("xml");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-fulleditor", null);
        writer.writeAttribute("xmlns:i18n", (Object)"http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:domain", (Object)"kupu", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb", null);
        writer.writeAttribute("id", (Object)"toolbar", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-tb-buttons", null);
        writer.writeAttribute("class", (Object)"kupu-tb-buttons", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("style", (Object)"float: right", null);
        writer.writeAttribute("id", (Object)"kupu-logo", null);
        if (editor.isAddKupuLogo()) {
            writer.startElement("button", (UIComponent)editor);
            writer.writeAttribute("type", (Object)"button", null);
            writer.writeAttribute("class", (Object)"kupu-logo", null);
            writer.writeAttribute("title", (Object)"Kupu 1.4.16", null);
            writer.writeAttribute(I18N_ATTRIBUTES_ATTR, (Object)"title title_logo;", null);
            writer.writeAttribute("accesskey", (Object)"k", null);
            writer.writeAttribute("onclick", (Object)"window.open('http://kupu.oscom.org');", null);
            writer.write("&#160;");
            writer.endElement("button");
        }
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("style", (Object)"float: right", null);
        writer.writeAttribute("id", (Object)"kupu-zoom", null);
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"kupu-zoom", null);
        writer.writeAttribute("id", (Object)"kupu-zoom-button", null);
        writer.writeAttribute(I18N_ATTRIBUTES_ATTR, (Object)"title title_zoom;", null);
        writer.writeAttribute("title", (Object)"Zoom: Access key (Alt or Ctrl) + X", null);
        writer.writeAttribute("accesskey", (Object)"x", null);
        writer.write("&#160;");
        writer.endElement("button");
        writer.endElement("span");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-tb-styles", null);
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"P", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"Normal", null);
        writer.write("Normal paragraph");
        writer.endElement("option");
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"H1", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"Heading 1", null);
        writer.write("Heading 1");
        writer.endElement("span");
        writer.endElement("option");
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"H2", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"Heading 2", null);
        writer.write("Heading 2");
        writer.endElement("span");
        writer.endElement("option");
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"H3", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"Heading 3", null);
        writer.write("Heading 3");
        writer.endElement("span");
        writer.endElement("option");
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"H4", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"Heading 4", null);
        writer.write("Heading 4");
        writer.endElement("span");
        writer.endElement("option");
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"H5", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"Heading 5", null);
        writer.write("Heading 5");
        writer.endElement("span");
        writer.endElement("option");
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"H6", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"Heading 6", null);
        writer.write("Heading 6");
        writer.endElement("span");
        writer.endElement("option");
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"PRE", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"Formatted", null);
        writer.write("Formatted");
        writer.endElement("option");
        writer.endElement("select");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("style", (Object)"display: none", null);
        InputHtmlRenderer.writeButton(writer, "kupu-save", "save: alt-s", "s", (UIComponent)editor, null);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-basicmarkup", null);
        InputHtmlRenderer.writeButton(writer, "kupu-bold", "Bold: Access key (Alt or Ctrl) + B", "b", (UIComponent)editor, "title title_bold;");
        InputHtmlRenderer.writeButton(writer, "kupu-italic", "Italic: Access key (Alt or Ctrl) + I", "i", (UIComponent)editor, "title title_italic;");
        InputHtmlRenderer.writeButton(writer, "kupu-underline", "Underline: Access key (Alt or Ctrl) + U", "u", (UIComponent)editor, "title title_underline;");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-subsuper", null);
        InputHtmlRenderer.writeButton(writer, "kupu-subscript", "Subscript: Access key (Alt or Ctrl) + -", "-", (UIComponent)editor, "title title_subscript;");
        InputHtmlRenderer.writeButton(writer, "kupu-superscript", "Superscript: Access key (Alt or Ctrl) + +", "+", (UIComponent)editor, "title title_superscript;");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-color", null);
        InputHtmlRenderer.writeButton(writer, "kupu-forecolor", "text color: alt-f", "f", (UIComponent)editor, "title title_text_color;");
        InputHtmlRenderer.writeButton(writer, "kupu-hilitecolor", "background color: alt-h", "h", (UIComponent)editor, "title title_back_color;");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-justify", null);
        InputHtmlRenderer.writeButton(writer, "kupu-justifyleft", "Left justify: Access key (Alt or Ctrl) + L", "l", (UIComponent)editor, "title title_ljust;");
        InputHtmlRenderer.writeButton(writer, "kupu-justifycenter", "Center justify: Access key (Alt or Ctrl) + C", "c", (UIComponent)editor, "title title_center;");
        InputHtmlRenderer.writeButton(writer, "kupu-justifyright", "Right justify: Access key (Alt or Ctrl) + R", "r", (UIComponent)editor, "title title_rjust;");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-list", null);
        InputHtmlRenderer.writeButton(writer, "kupu-insertorderedlist", "Numbered list: Access key (Alt or Ctrl) + #", "#", "kupu-list-ol-addbutton", (UIComponent)editor, "title title_numlist;");
        InputHtmlRenderer.writeButton(writer, "kupu-insertunorderedlist", "Unordered list: Access key (Alt or Ctrl) + *", "*", "kupu-list-ul-addbutton", (UIComponent)editor, "title title_unorderedlist;");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-definitionlist", null);
        InputHtmlRenderer.writeButton(writer, "kupu-insertdefinitionlist", "Definition list: Access key (Alt or Ctrl) + =", "=", "kupu-list-dl-addbutton", (UIComponent)editor, "title title_deflist;");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-indent", null);
        InputHtmlRenderer.writeButton(writer, "kupu-outdent", "Decrease quote level: Access key (Alt or Ctrl) + <", "<", (UIComponent)editor, "title title_decrease_quote;");
        InputHtmlRenderer.writeButton(writer, "kupu-indent", "Increase quote level: Access key (Alt or Ctrl) + >", ">", (UIComponent)editor, "title title_increase_quote;");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        if (!editor.isAllowExternalLinks()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        InputHtmlRenderer.writeButton(writer, "kupu-image", "Insert image", null, "kupu-imagelibdrawer-button", false, (UIComponent)editor, "title title_insert_image;");
        InputHtmlRenderer.writeButton(writer, "kupu-inthyperlink", "Insert internal link", null, "kupu-linklibdrawer-button", false, (UIComponent)editor, "title title_insert_internal_link;");
        InputHtmlRenderer.writeButton(writer, "kupu-exthyperlink", "Insert external link", null, "kupu-linkdrawer-button", (UIComponent)editor, "title title_insert_external_link;");
        InputHtmlRenderer.writeButton(writer, "kupu-anchors", "Insert anchors", null, "kupu-anchors", (UIComponent)editor, "title title_insert_anchors;");
        InputHtmlRenderer.writeButton(writer, "kupu-table", "Insert table", null, "kupu-tabledrawer-button", (UIComponent)editor, "title title_insert_table;");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-remove", null);
        InputHtmlRenderer.writeButton(writer, "kupu-removeimage invisible", "Remove image", null, "kupu-removeimage-button", (UIComponent)editor, "title title_removeimage;");
        InputHtmlRenderer.writeButton(writer, "kupu-removelink invisible", "Remove link", null, "kupu-removelink-button", (UIComponent)editor, "title title_removelink;");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup", null);
        writer.writeAttribute("id", (Object)"kupu-bg-undo", null);
        InputHtmlRenderer.writeButton(writer, "kupu-undo", "Undo: Access key (Alt or Ctrl) + Z", "z", (UIComponent)editor, "title title_undo;");
        InputHtmlRenderer.writeButton(writer, "kupu-redo", "Redo: Access key (Alt or Ctrl) + Y", "y", (UIComponent)editor, "title title_redo;");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup kupu-spellchecker-span", null);
        writer.writeAttribute("id", (Object)"kupu-spellchecker", null);
        writer.writeAttribute("style", (Object)"display: none", null);
        InputHtmlRenderer.writeButton(writer, "kupu-spellchecker", "Check spelling", null, (UIComponent)editor, "title title_check_spelling;");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tb-buttongroup kupu-source-span", null);
        writer.writeAttribute("id", (Object)"kupu-source", null);
        if (!editor.isAllowEditSource()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        InputHtmlRenderer.writeButton(writer, "kupu-source", "Switch between visual editor and HTML view", "h", (UIComponent)editor, "title toggle_source_view;");
        writer.endElement("span");
        writer.endElement("span");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-ulstyles", null);
        writer.writeAttribute("class", (Object)"kupu-ulstyles", null);
        InputHtmlRenderer.writeOption(writer, "disc", "list-disc", "&#x25CF;", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "square", "list-square", "&#x25A0;", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "circle", "list-circle", "&#x25CB;", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "none", "list-nobullet", "no bullet", (UIComponent)editor);
        writer.endElement("select");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-olstyles", null);
        writer.writeAttribute("class", (Object)"kupu-olstyles", null);
        InputHtmlRenderer.writeOption(writer, "decimal", "list-decimal", "1", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "upper-roman", "list-upperroman", "I", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "lower-roman", "list-lowerroman", "i", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "upper-alpha", "list-upperalpha", "A", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "lower-alpha", "list-loweralpha", "a", (UIComponent)editor);
        writer.endElement("select");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("style", (Object)"display:block;", null);
        writer.writeAttribute("class", (Object)"kupu-librarydrawer-parent", null);
        writer.startElement("iframe", (UIComponent)editor);
        writer.writeAttribute("style", (Object)"display:none", null);
        writer.writeAttribute("class", (Object)"kupu-anchorframe", null);
        writer.writeAttribute("src", (Object)"javascript:''", null);
        writer.writeAttribute("scrolling", (Object)"auto", null);
        writer.writeAttribute("frameborder", (Object)"1", null);
        writer.endElement("iframe");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-linkdrawer", null);
        writer.writeAttribute("class", (Object)"kupu-drawer kupu-linkdrawer", null);
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-drawer-title", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"title_external_link", null);
        writer.write("External Link");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-linkdrawer-addlink", null);
        writer.writeAttribute("class", (Object)"kupu-panels kupu-linkdrawer-addlink", null);
        writer.startElement("ul", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tabs", null);
        writer.startElement("li", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-linkdrawer-addlink selected", null);
        writer.startElement("a", (UIComponent)editor);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tab_link", null);
        writer.writeAttribute("shape", (Object)"rect", null);
        writer.write("Link to url");
        writer.endElement("a");
        writer.endElement("li");
        writer.startElement("li", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-linkdrawer-embed", null);
        writer.startElement("a", (UIComponent)editor);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tab_embed", null);
        writer.writeAttribute("shape", (Object)"rect", null);
        writer.write("Embed external object");
        writer.endElement("a");
        writer.endElement("li");
        writer.endElement("ul");
        writer.startElement("table", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tabbed", null);
        writer.startElement("tbody", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-addlink", null);
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_link_text", null);
        writer.write("Link the highlighted text to this URL:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-st kupu-linkdrawer-input", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("onkeypress", (Object)"return HandleDrawerEnter(event, 'linkdrawer-preview');", null);
        writer.endElement("input");
        writer.endElement("td");
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)"kupu-preview-button", null);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("id", (Object)"linkdrawer-preview", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.preview()", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"button_preview", null);
        writer.write("Preview");
        writer.endElement("button");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-linkdrawer-anchors", null);
        writer.writeAttribute("style", (Object)"display:none", null);
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"2", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("label", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_anchor", null);
        writer.writeAttribute("for", (Object)"anchorselect", null);
        writer.write("Anchor");
        writer.endElement("label");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"anchorselect", null);
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"opt_top_of_page", null);
        writer.writeAttribute("value", (Object)"", null);
        writer.write("top of page (default)");
        writer.endElement("option");
        writer.endElement("select");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"2", null);
        writer.writeAttribute("align", (Object)"center", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"watermark", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"watermark_preview", null);
        writer.write("Preview");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("iframe", (UIComponent)editor);
        writer.writeAttribute("frameborder", (Object)"1", null);
        writer.writeAttribute("scrolling", (Object)"auto", null);
        writer.writeAttribute("width", (Object)"440", null);
        writer.writeAttribute("height", (Object)"198", null);
        writer.writeAttribute("class", (Object)"kupu-linkdrawer-preview", null);
        writer.writeAttribute("src", (Object)"javascript:''", null);
        writer.endElement("iframe");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.startElement("tbody", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-embed", null);
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"help_paste_here", null);
        writer.write("Paste &lt;object&gt; or &lt;embed&gt; tag here:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("textarea", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-st kupu-embed-input", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"placeholder_html_code", null);
        writer.write("[insert arbitrary HTML code here]");
        writer.endElement("textarea");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"custom_html_help", null);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.write("You may use this box to insert custom snippets of");
        writer.write("HTML code. There is no guarantee that any code");
        writer.write("inserted in this way will be preserved when you save");
        writer.write("your edits. To select an existing object from IE click on");
        writer.write("the border, from Firefox double click it.");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialogbuttons", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.save()", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"button_ok", null);
        writer.write("Ok");
        writer.endElement("button");
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.closeDrawer()", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"button_cancel", null);
        writer.write("Cancel");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-tabledrawer", null);
        writer.writeAttribute("class", (Object)"kupu-drawer kupu-tabledrawer", null);
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-drawer-title", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_title", null);
        writer.write("Table");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-panels", null);
        writer.startElement("table", (UIComponent)editor);
        writer.writeAttribute("width", (Object)"300", null);
        writer.startElement("tr", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-panelsrow", null);
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-panel", null);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-addtable", null);
        writer.startElement("table", (UIComponent)editor);
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_class_label", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.write("Table Class");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-addclasschooser", null);
        InputHtmlRenderer.writeOption(writer, "plain", "Plain", "Plain", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "listing", "Listing", "Listing", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "grid", "Grid", "Grid", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "data", "Data", "Data", (UIComponent)editor);
        writer.endElement("select");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_rows_label", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.write("Rows");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-newrows", null);
        writer.writeAttribute("value", (Object)"3", null);
        writer.writeAttribute("onkeypress", (Object)"return HandleDrawerEnter(event);", null);
        writer.endElement("input");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_columns_label", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.write("Columns");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-newcols", null);
        writer.writeAttribute("value", (Object)"3", null);
        writer.writeAttribute("onkeypress", (Object)"return HandleDrawerEnter(event);", null);
        writer.endElement("input");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-makeheader", null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("checked", (Object)"checked", null);
        writer.writeAttribute("onkeypress", (Object)"return HandleDrawerEnter(event);", null);
        writer.writeAttribute("id", (Object)"tabledrawer_makeheader", null);
        writer.endElement("input");
        writer.startElement("label", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_headings_label", null);
        writer.writeAttribute("for", (Object)"tabledrawer_makeheader", null);
        writer.write("Create Headings");
        writer.endElement("label");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_add_table_button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.createTable()", null);
        writer.write("Add Table");
        writer.endElement("button");
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_fix_tables_button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.fixAllTables()", null);
        writer.write("Fix All Tables");
        writer.endElement("button");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-edittable", null);
        writer.startElement("table", (UIComponent)editor);
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_class_label", null);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.write("Table Class");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-editclasschooser", null);
        writer.writeAttribute("onchange", (Object)"drawertool.current_drawer.setTableClass(this.options[this.selectedIndex].value)", null);
        InputHtmlRenderer.writeOption(writer, "plain", "Plain", "Plain", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "listing", "Listing", "Listing", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "grid", "Grid", "Grid", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "data", "Data", "Data", (UIComponent)editor);
        writer.endElement("select");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_alignment_label", null);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.write("Current column alignment");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-tabledrawer-alignchooser", null);
        writer.writeAttribute("class", (Object)"kupu-tabledrawer-alignchooser", null);
        writer.writeAttribute("onchange", (Object)"drawertool.current_drawer.tool.setColumnAlign(this.options[this.selectedIndex].value)", null);
        InputHtmlRenderer.writeOption(writer, "left", "tabledrawer_left_option", "Left", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "center", "tabledrawer_center_option", "Center", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "right", "tabledrawer_right_option", "Right", (UIComponent)editor);
        writer.endElement("select");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_column_label", null);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.write("Column");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_add_button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.addTableColumn()", null);
        writer.write("Add");
        writer.endElement("button");
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_remove_button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.delTableColumn()", null);
        writer.write("Remove");
        writer.endElement("button");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_row_label", null);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.write("Row");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_add_button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.addTableRow()", null);
        writer.write("Add");
        writer.endElement("button");
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_remove_button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.delTableRow()", null);
        writer.write("Remove");
        writer.endElement("button");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("th", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_table_label", null);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.write("Fix Table");
        writer.endElement("th");
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_fix_button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.fixTable()", null);
        writer.write("Fix");
        writer.endElement("button");
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_remove_button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.delTable()", null);
        writer.write("Remove");
        writer.endElement("button");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialogbuttons", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tabledrawer_close_button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.closeDrawer(this)", null);
        writer.write("Close");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-anchordrawer", null);
        writer.writeAttribute("class", (Object)"kupu-drawer kupu-anchordrawer", null);
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-drawer-title", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"anchordrawer_title", null);
        writer.write("Anchors");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-panels kupu-ins-bm", null);
        writer.startElement("ul", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tabs", null);
        writer.startElement("li", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-ins-bm selected", null);
        writer.startElement("a", (UIComponent)editor);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tab_link_anchor", null);
        writer.writeAttribute("shape", (Object)"rect", null);
        writer.write("Link to anchor");
        writer.endElement("a");
        writer.endElement("li");
        writer.startElement("li", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-anchor", null);
        writer.startElement("a", (UIComponent)editor);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tab_manage_anchors", null);
        writer.writeAttribute("shape", (Object)"rect", null);
        writer.write("Manage Anchors");
        writer.endElement("a");
        writer.endElement("li");
        writer.startElement("li", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toc", null);
        writer.startElement("a", (UIComponent)editor);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"tab_toc", null);
        writer.writeAttribute("shape", (Object)"rect", null);
        writer.write("Table of contents");
        writer.endElement("a");
        writer.endElement("li");
        writer.endElement("ul");
        writer.startElement("table", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-tabbed", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-bm-select", null);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-bm-sel1", null);
        writer.writeAttribute("size", (Object)"10", null);
        writer.endElement("select");
        writer.endElement("td");
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-bm-heading", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-bm-tablestyle invis-ins-bm invis-anchor", null);
        writer.startElement("label", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_table_style", null);
        writer.writeAttribute("for", (Object)"kupu-bm-outcls", null);
        writer.write("Table style");
        writer.endElement("label");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-bm-outcls", null);
        writer.writeAttribute("size", (Object)"1", null);
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"Normal", null);
        writer.write("Normal paragraph");
        writer.endElement("option");
        writer.endElement("select");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-bm-numbering invis-ins-bm invis-anchor", null);
        writer.startElement("label", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_numbering", null);
        writer.writeAttribute("for", (Object)"kupu-bm-number", null);
        writer.write("Numbering");
        writer.endElement("label");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("class", (Object)"hide-ins-bm hide-anchor", null);
        writer.writeAttribute("checked", (Object)"checked", null);
        writer.writeAttribute("id", (Object)"kupu-bm-number", null);
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"invis-ins-bm", null);
        writer.startElement("label", (UIComponent)editor);
        writer.writeAttribute("for", (Object)"kupu-bm-checkall", null);
        writer.startElement("em", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_toggle_all", null);
        writer.write("toggle all");
        writer.endElement("em");
        writer.endElement("label");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("class", (Object)"hide-ins-bm", null);
        writer.writeAttribute("checked", (Object)"checked", null);
        writer.writeAttribute("id", (Object)"kupu-bm-checkall", null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-bm-paras", null);
        writer.write("&#160;");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)editor);
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-bm-sel2", null);
        writer.writeAttribute("size", (Object)"1", null);
        writer.writeAttribute("class", (Object)"hide-ins-bm hide-anchor", null);
        writer.startElement("option", (UIComponent)editor);
        writer.writeAttribute("value", (Object)"", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"opt_2nd_style", null);
        writer.write("(optional 2nd style)");
        writer.endElement("option");
        writer.endElement("select");
        writer.endElement("td");
        writer.startElement("td", (UIComponent)editor);
        writer.writeAttribute("colspan", (Object)"1", null);
        writer.writeAttribute(ROWSPAN_ATTR, (Object)"1", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-bm-help", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"hide-anchor hide-toc discreet", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"create_anchor_link_help", null);
        writer.write("Select a paragraph style then choose a paragraph and Ok to insert a link to that location.");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"hide-ins-bm hide-anchor discreet", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"create_toc_help", null);
        writer.write("Select one or two paragraph styles, then Ok to insert a table of contents.");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"hide-ins-bm hide-toc discreet", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"create_anchor_help", null);
        writer.write("Anchors are created for checked paragraphs and");
        writer.write("removed for unchecked paragraphs when you press Ok.");
        writer.write("Anchors in use on this page may not be deleted.");
        writer.endElement("span");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialogbuttons", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.current_drawer.save()", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"button_ok", null);
        writer.write("Ok");
        writer.endElement("button");
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-dialog-button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("onclick", (Object)"drawertool.closeDrawer()", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"button_cancel", null);
        writer.write("Cancel");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolboxes", null);
        writer.writeAttribute("id", (Object)"kupu-toolboxes", null);
        if (!editor.isShowAnyToolBox()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox", null);
        writer.writeAttribute("id", (Object)"kupu-toolbox-properties", null);
        if (!editor.isShowPropertiesToolBox()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-heading", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"title_properties", null);
        writer.write("Properties");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_title", null);
        writer.write("Title:");
        writer.endElement("div");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("id", (Object)"kupu-properties-title", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.endElement("input");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_description", null);
        writer.write("Description:");
        writer.endElement("div");
        writer.startElement("textarea", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("id", (Object)"kupu-properties-description", null);
        writer.endElement("textarea");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox", null);
        writer.writeAttribute("id", (Object)"kupu-toolbox-links", null);
        if (!editor.isShowLinksToolBox()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-heading", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_links", null);
        writer.write("Links");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-toolbox-addlink", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_link_text", null);
        writer.write("Link the highlighted text to this URL:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-link-input", null);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.endElement("input");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-buttons", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("id", (Object)"kupu-link-button", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-action", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"button_makelink", null);
        writer.write("Make Link");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox", null);
        writer.writeAttribute("id", (Object)"kupu-toolbox-images", null);
        if (!editor.isShowImagesToolBox()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-heading", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"title_images", null);
        writer.write("Images");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_image_class", null);
        writer.write("Image class:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("id", (Object)"kupu-image-float-select", null);
        InputHtmlRenderer.writeOption(writer, "image-inline", "opt_inline", "Inline", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "image-left", "opt_left", "Left", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "image-right", "opt_right", "Right", (UIComponent)editor);
        writer.endElement("select");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_insert_image_url", null);
        writer.write("Insert image at the following URL:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-image-input", null);
        writer.writeAttribute("value", (Object)"kupuimages/kupu_icon.gif", null);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.endElement("input");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-buttons", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("id", (Object)"kupu-image-addbutton", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-action", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"button_insert_image", null);
        writer.write("Insert Image");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox", null);
        writer.writeAttribute("id", (Object)"kupu-toolbox-tables", null);
        if (!editor.isShowTablesToolBox()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-heading", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"title_tables", null);
        writer.write("Tables");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_table_class", null);
        writer.write("Table Class:");
        writer.endElement("span");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("id", (Object)"kupu-table-classchooser", null);
        writer.write(32);
        writer.endElement("select");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-toolbox-addtable", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-addtable", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_rows", null);
        writer.write("Rows:");
        writer.endElement("div");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("id", (Object)"kupu-table-newrows", null);
        writer.endElement("input");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_columns", null);
        writer.write("Columns:");
        writer.endElement("div");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("id", (Object)"kupu-table-newcols", null);
        writer.endElement("input");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_headings", null);
        writer.write("Headings:");
        writer.endElement("span");
        writer.startElement("input", (UIComponent)editor);
        writer.writeAttribute("name", (Object)"kupu-table-makeheader", null);
        writer.writeAttribute("id", (Object)"kupu-table-makeheader", null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.endElement("input");
        writer.startElement("label", (UIComponent)editor);
        writer.writeAttribute("for", (Object)"kupu-table-makeheader", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_create", null);
        writer.write("Create");
        writer.endElement("label");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-buttons", null);
        InputHtmlRenderer.writeButton(writer, "kupu-table-fixall-button", "Fix Table", (UIComponent)editor, "button_fix_table");
        InputHtmlRenderer.writeButton(writer, "kupu-table-addtable-button", "Add Table", (UIComponent)editor, "button_add_table");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-toolbox-edittable", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-edittable", null);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_col_align", null);
        writer.write("Col Align:");
        writer.endElement("span");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"wide", null);
        writer.writeAttribute("id", (Object)"kupu-table-alignchooser", null);
        InputHtmlRenderer.writeOption(writer, "left", "tabledrawer_left_option", "Left", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "center", "tabledrawer_center_option", "Center", (UIComponent)editor);
        InputHtmlRenderer.writeOption(writer, "right", "tabledrawer_right_option", "Right", (UIComponent)editor);
        writer.endElement("select");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-buttons", null);
        writer.startElement("br", (UIComponent)editor);
        writer.writeAttribute("clear", (Object)"none", null);
        writer.endElement("br");
        InputHtmlRenderer.writeButton(writer, "kupu-table-addcolumn-button", "Add Column", (UIComponent)editor, "button_add_column");
        InputHtmlRenderer.writeButton(writer, "kupu-table-delcolumn-button", "Remove Column", (UIComponent)editor, "button_remove_column");
        writer.startElement("br", (UIComponent)editor);
        writer.writeAttribute("clear", (Object)"none", null);
        writer.endElement("br");
        InputHtmlRenderer.writeButton(writer, "kupu-table-addrow-button", "Add Row", (UIComponent)editor, "button_add_row");
        InputHtmlRenderer.writeButton(writer, "kupu-table-delrow-button", "Remove Row", (UIComponent)editor, "button_remove_row");
        InputHtmlRenderer.writeButton(writer, "kupu-table-fix-button", "Fix Table", (UIComponent)editor, "button_fix_table");
        InputHtmlRenderer.writeButton(writer, "kupu-table-del-button", "Remove Table", (UIComponent)editor, "button_remove_table");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox", null);
        writer.writeAttribute("id", (Object)"kupu-toolbox-cleanupexpressions", null);
        if (!editor.isShowCleanupExpressionsToolBox()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-heading", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"title_cleanup_expressions", null);
        writer.write("Cleanup expressions");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.startElement("span", (UIComponent)editor);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"label_select_cleanup", null);
        writer.write("Select a cleanup action:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("select", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupucleanupexpressionselect", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-st", null);
        writer.endElement("select");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("style", (Object)"text-align: center", null);
        writer.startElement("button", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("id", (Object)"kupucleanupexpressionbutton", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-action", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"perform_action", null);
        writer.write("Perform action");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox", null);
        writer.writeAttribute("id", (Object)"kupu-toolbox-debug", null);
        if (!editor.isShowDebugToolBox()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        writer.startElement("h1", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-toolbox-heading", null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)"title_debug_log", null);
        writer.write("Debug Log");
        writer.endElement("h1");
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-toolbox-debuglog", null);
        writer.writeAttribute("class", (Object)"kupu-toolbox-label", null);
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("table", (UIComponent)editor);
        writer.writeAttribute("id", (Object)"kupu-colorchooser", null);
        writer.writeAttribute("class", (Object)"kupu-colorchooser", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("style", (Object)"position: fixed; border-style: solid; border-color: black; border-width: 1px;", null);
        writer.endElement("table");
        writer.startElement("div", (UIComponent)editor);
        if (!editor.isShowAnyToolBox()) {
            writer.writeAttribute("style", (Object)"margin-right: 0.3em", null);
        }
        if (editor.getStyle() != null) {
            addResource.addInlineStyleAtPosition(context, AddResource.HEADER_BEGIN, "#kupu-editor{height: inherit;}\ndiv.kupu-fulleditor{" + editor.getStyle() + "}");
        }
        writer.writeAttribute("class", (Object)("kupu-editorframe" + (editor.getStyleClass() == null ? "" : " " + editor.getStyleClass())), null);
        writer.startElement("iframe", (UIComponent)editor);
        writer.writeAttribute("id", (Object)InputHtmlRenderer.getIFrameID(editor, context), null);
        writer.writeAttribute("class", (Object)"kupu-editor-iframe", null);
        writer.writeAttribute("frameborder", (Object)"0", null);
        writer.writeAttribute("scrolling", (Object)"auto", null);
        writer.writeAttribute("onmouseover", (Object)"myFacesKupuReactivateDesignMode(this)", null);
        writer.writeAttribute("onfocus", (Object)"myFacesKupuReactivateDesignMode(this)", null);
        writer.endElement("iframe");
        writer.startElement("textarea", (UIComponent)editor);
        writer.writeAttribute("class", (Object)"kupu-editor-textarea", null);
        writer.writeAttribute("id", (Object)"kupu-editor-textarea", null);
        writer.write(32);
        writer.endElement("textarea");
        writer.endElement("div");
        writer.endElement("div");
        String text = editor.getValueAsHtmlDocument(context);
        String encodedText = text == null ? "" : JavascriptUtils.encodeString(text);
        String resourceBaseURL = addResource.getResourceUri(context, InputHtmlRenderer.class, null);
        writer.startElement("script", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("myFacesKupuSet(\"" + encodedText + "\"," + "\"" + clientId + "\"," + "\"" + formId + "\"," + "\"" + resourceBaseURL + "\"" + ");");
        writer.endElement("script");
    }

    private static String getIFrameID(InputHtml editor, FacesContext context) {
        return editor.getClientId(context) + "_iframe";
    }

    private static void writeTag(ResponseWriter writer, String tagName, String tagBody, UIComponent component) throws IOException {
        writer.startElement(tagName, component);
        writer.writeText((Object)tagBody, null);
        writer.endElement(tagName);
    }

    private static void writeButton(ResponseWriter writer, String classAttr, String title, String accessKey, UIComponent component, String i18nattributes) throws IOException {
        InputHtmlRenderer.writeButton(writer, classAttr, title, accessKey, classAttr + "-button", component, i18nattributes);
    }

    private static void writeButton(ResponseWriter writer, String classAttr, String title, String accessKey, String id, UIComponent component, String i18nattributes) throws IOException {
        InputHtmlRenderer.writeButton(writer, classAttr, title, accessKey, id, true, component, i18nattributes);
    }

    private static void writeButton(ResponseWriter writer, String classAttr, String title, String accessKey, String id, boolean display, UIComponent component, String i18nattributes) throws IOException {
        writer.startElement("button", component);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)classAttr, null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("title", (Object)title, null);
        writer.writeAttribute(I18N_ATTRIBUTES_ATTR, (Object)(i18nattributes == null ? "title" : i18nattributes), null);
        if (!display) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
        if (accessKey != null) {
            writer.writeAttribute("accesskey", (Object)accessKey, null);
        }
        writer.write("&#160;");
        writer.endElement("button");
    }

    private static void writeButton(ResponseWriter writer, String id, String text, UIComponent component, String i18nattributes) throws IOException {
        writer.startElement("button", component);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute(I18N_ATTRIBUTES_ATTR, (Object)i18nattributes, null);
        writer.write(text);
        writer.endElement("button");
    }

    private static void writeOption(ResponseWriter writer, String value, String translate, String body, UIComponent component) throws IOException {
        writer.startElement("option", component);
        writer.writeAttribute("value", (Object)value, null);
        writer.writeAttribute(I18N_TRANSLATE_ATTR, (Object)translate, null);
        writer.write(body);
        writer.endElement("option");
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, InputHtml.class);
        InputHtml editor = (InputHtml)uiComponent;
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = uiComponent.getClientId(facesContext);
        if (paramMap.containsKey(clientId)) {
            String submitedText = (String)paramMap.get(clientId);
            String htmlText = InputHtmlRenderer.useFallback(editor) ? HTMLEncoder.encode(submitedText, true, true) : submitedText;
            editor.setSubmittedValue(htmlText);
        } else {
            log.warn((Object)("There should always be a submitted value for an input if it is rendered, its form is submitted, and it was not originally rendered disabled or read-only.  You cannot submit a form after disabling an input element via javascript.  Consider setting read-only to true instead or resetting the disabled value back to false prior to form submission. Component : " + RendererUtils.getPathToComponent((UIComponent)editor)));
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, InputHtml.class);
        InputHtml editor = (InputHtml)uiComponent;
        String submittedDocument = editor.getValueFromDocument((String)submittedValue);
        return RendererUtils.getConvertedUIOutputValue(facesContext, (UIOutput)editor, submittedDocument);
    }
}

