/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.selectOneLanguage;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectOne;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.component.html.ext.HtmlSelectOneMenu;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;

public abstract class AbstractSelectOneLanguage
extends HtmlSelectOneMenu {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.SelectOneLanguage";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.SelectOneLanguageRenderer";
    private Integer _maxLength = null;
    private String _emptySelection = null;

    public AbstractSelectOneLanguage() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public abstract Integer getMaxLength();

    public abstract String getEmptySelection();

    private Set getFilterSet() {
        List selectItems = RendererUtils.getSelectItemList((UISelectOne)this);
        HashSet<String> set = new HashSet<String>(selectItems.size());
        Iterator i = selectItems.iterator();
        while (i.hasNext()) {
            set.add(((SelectItem)i.next()).getValue().toString().toLowerCase());
        }
        return set;
    }

    protected List getLanguagesChoicesAsSelectItemList() {
        Integer maxLength;
        int maxDescriptionLength;
        Set filterSet = this.getFilterSet();
        String[] availableLanguages = Locale.getISOLanguages();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale currentLocale = viewRoot != null ? viewRoot.getLocale() : facesContext.getApplication().getDefaultLocale();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (int i = 0; i < availableLanguages.length; ++i) {
            String languageCode = availableLanguages[i];
            if (!filterSet.isEmpty() && !filterSet.contains(languageCode)) continue;
            Locale tmp = new Locale(languageCode);
            map.put(tmp.getDisplayLanguage(currentLocale), languageCode);
        }
        ArrayList<SelectItem> languagesSelectItems = new ArrayList<SelectItem>(map.size());
        if (this.getEmptySelection() != null) {
            languagesSelectItems.add(new SelectItem((Object)"", this.getEmptySelection()));
        }
        int n = maxDescriptionLength = (maxLength = this.getMaxLength()) == null ? Integer.MAX_VALUE : maxLength;
        if (maxDescriptionLength < 5) {
            maxDescriptionLength = 5;
        }
        for (String languageName : map.keySet()) {
            String languageCode = (String)map.get(languageName);
            String label = languageName.length() <= maxDescriptionLength ? languageName : languageName.substring(0, maxDescriptionLength - 3) + "...";
            languagesSelectItems.add(new SelectItem((Object)languageCode, label));
        }
        return languagesSelectItems;
    }

    protected void validateValue(FacesContext context, Object value) {
        UISelectItems selectItems = new UISelectItems();
        selectItems.setTransient(true);
        selectItems.setValue((Object)this.getLanguagesChoicesAsSelectItemList());
        this.getChildren().add(selectItems);
        super.validateValue(context, value);
    }
}

